/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.MessageReorientCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.MessageConnectionHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.ReconnectMessageHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

public class CustomMessageReorientCommand
extends MessageReorientCommand {
    public CustomMessageReorientCommand(ReorientRelationshipRequest request) {
        super(request);
    }

    protected boolean canReorientSource() {
        if (!(this.getOldSource() instanceof Element) || !(this.getNewSource() instanceof Element)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Interaction)) {
            return false;
        }
        Interaction container = (Interaction)this.getLink().eContainer();
        boolean canExistMessage = UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistMessage_4003(container, this.getLink(), this.getNewSource(), this.getOldTarget());
        if (!canExistMessage) {
            return false;
        }
        if (!(this.getNewSource() instanceof ExecutionSpecification)) {
            return false;
        }
        return MessageConnectionHelper.canReorientSource(this.getLink(), this.getNewSource());
    }

    protected boolean canReorientTarget() {
        if (!(this.getOldTarget() instanceof Element) || !(this.getNewTarget() instanceof Element)) {
            return false;
        }
        Element source = this.getLink().getOwner();
        if (!(this.getLink().eContainer() instanceof Interaction)) {
            return false;
        }
        Interaction container = (Interaction)this.getLink().eContainer();
        if (!UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistMessage_4003(container, this.getLink(), source, this.getNewTarget())) {
            return false;
        }
        if (!(this.getNewTarget() instanceof ExecutionSpecification)) {
            return false;
        }
        return MessageConnectionHelper.canReorientTarget(this.getLink(), this.getNewTarget());
    }

    protected CommandResult reorientSource() throws ExecutionException {
        MessageEnd sendEvent = this.getLink().getSendEvent();
        ReconnectMessageHelper.updateMessageEnd(sendEvent, this.getOldSource(), this.getNewSource());
        if (this.getOldSource() instanceof ExecutionSpecification && sendEvent == ((ExecutionSpecification)this.getOldSource()).getStart()) {
            OccurrenceSpecificationHelper.resetExecutionStart((ExecutionSpecification)this.getOldSource(), (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
        }
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        MessageEnd receiveEvent = this.getLink().getReceiveEvent();
        ReconnectMessageHelper.updateMessageEnd(receiveEvent, this.getOldTarget(), this.getNewTarget());
        ReconnectMessageHelper.updateMessage(this.getLink());
        if (this.getOldTarget() instanceof ExecutionSpecification && receiveEvent == ((ExecutionSpecification)this.getOldTarget()).getStart()) {
            OccurrenceSpecificationHelper.resetExecutionStart((ExecutionSpecification)this.getOldTarget(), (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
        }
        if (this.getNewTarget() instanceof ExecutionSpecification && receiveEvent instanceof MessageOccurrenceSpecification) {
            OccurrenceSpecificationHelper.resetExecutionStart((ExecutionSpecification)this.getNewTarget(), (Element)receiveEvent);
        }
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }
}

