/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IPopupEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.uml.diagram.common.directedit.MultilineLabelDirectEditManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.util.MessageDirection;
import org.eclipse.papyrus.uml.diagram.sequence.Activator;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.UMLEditPartFactory;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.locator.GateLocator;
import org.eclipse.papyrus.uml.diagram.sequence.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class GateNameEditPart
extends LabelEditPart
implements ITextAwareEditPart,
IBorderItemEditPart {
    public static final String GATE_NAME_TYPE = "Gate_Name";
    private DirectEditManager manager;
    private IParser parser;
    private List<?> parserElements;
    private String defaultText;
    protected int directEditionMode = 0;
    protected IDirectEditorConfiguration configuration;

    static {
        GateNameEditPart.registerSnapBackPosition((String)GATE_NAME_TYPE, (Point)new Point(-32, 0));
    }

    public GateNameEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new UMLTextSelectionEditPolicy());
    }

    public IBorderItemLocator getBorderItemLocator() {
        IFigure parentFigure = this.getFigure().getParent();
        if (parentFigure != null && parentFigure.getLayoutManager() != null) {
            Object constraint = parentFigure.getLayoutManager().getConstraint(this.getFigure());
            return (IBorderItemLocator)constraint;
        }
        return null;
    }

    public void refreshBounds() {
        IBorderItemLocator borderItemLocator;
        EditPart parent;
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        if (x == 0 && y == 0 && (parent = this.getParent()) instanceof GateEditPart) {
            GateEditPart gateEditPart = (GateEditPart)parent;
            EObject elt = gateEditPart.resolveSemanticElement();
            Dimension preferredSize = this.getFigure().getPreferredSize(width, height);
            IBorderItemLocator locator = gateEditPart.getBorderItemLocator();
            if (locator instanceof GateLocator) {
                int alignment = ((GateLocator)locator).getAlignment(((GateLocator)locator).getConstraint());
                if (1 == alignment) {
                    x = gateEditPart.getTargetConnections().isEmpty() ? -preferredSize.width - 1 : GateEditPart.DEFAULT_SIZE.width + 1;
                    y = elt instanceof Gate && GateHelper.isInnerCFGate((Gate)elt) ? GateEditPart.DEFAULT_SIZE.height - 2 : -GateEditPart.DEFAULT_SIZE.height + 2;
                } else if (4 == alignment) {
                    x = gateEditPart.getSourceConnections().isEmpty() ? GateEditPart.DEFAULT_SIZE.width + 1 : -preferredSize.width - 1;
                    y = elt instanceof Gate && GateHelper.isInnerCFGate((Gate)elt) ? GateEditPart.DEFAULT_SIZE.height - 2 : -GateEditPart.DEFAULT_SIZE.height + 2;
                } else if (8 == alignment) {
                    y = -GateEditPart.DEFAULT_SIZE.height - 1;
                } else if (32 == alignment) {
                    y = GateEditPart.DEFAULT_SIZE.height + 1;
                }
            }
        }
        if ((borderItemLocator = this.getBorderItemLocator()) != null) {
            borderItemLocator.setConstraint(new Rectangle(x, y, width, height));
        }
    }

    public int getKeyPoint() {
        return 4;
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getText();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getText();
        }
        return ((Label)figure).getText();
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setText(text);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setText(text);
        } else {
            ((Label)figure).setText(text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getIcon();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getIcon();
        }
        return ((Label)figure).getIcon();
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setIcon(icon);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setIcon(icon);
        } else {
            ((Label)figure).setIcon(icon);
        }
    }

    public void setLabel(WrappingLabel figure) {
        this.unregisterVisuals();
        this.setFigure((IFigure)figure);
        this.defaultText = this.getLabelTextHelper((IFigure)figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    protected Image getLabelIcon() {
        return null;
    }

    protected String getLabelText() {
        String text = null;
        EObject parserElement = this.getParserElement();
        if (parserElement != null && this.getParser() != null) {
            text = this.getParser().getPrintString((IAdaptable)new EObjectAdapter(parserElement), this.getParserOptions().intValue());
        }
        if (text == null || text.length() == 0) {
            text = this.defaultText;
        }
        return text;
    }

    public void setLabelText(String text) {
        EditPolicy sfEditPolicy;
        this.setLabelTextHelper(this.getFigure(), text);
        EditPolicy pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (pdEditPolicy instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    protected boolean isEditable() {
        return this.getParser() != null;
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = GateNameEditPart.this.getParserElement();
                    final IParser parser = GateNameEditPart.this.getParser();
                    try {
                        IParserEditStatus valid = (IParserEditStatus)GateNameEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                            public void run() {
                                this.setResult(parser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                            }
                        });
                        return valid.getCode() == 0 ? null : valid.getMessage();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = new GateNameParser();
        }
        return this.parser;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new MultilineLabelDirectEditManager((GraphicalEditPart)this, MultilineLabelDirectEditManager.getTextCellEditorClass((GraphicalEditPart)this), UMLEditPartFactory.getTextCellEditorLocator(this)));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void performDirectEdit() {
        this.getManager().show();
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }

    private void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        if (this.directEditionMode == 0) {
            this.directEditionMode = this.getDirectEditionType();
        }
        switch (this.directEditionMode) {
            case 8: {
                return;
            }
            case 4: {
                this.updateExtendedEditorConfiguration();
                if (this.configuration == null || this.configuration.getLanguage() == null) {
                    this.performDefaultDirectEditorEdit(theRequest);
                    break;
                }
                this.configuration.preEditAction((Object)this.resolveSemanticElement());
                Dialog dialog = null;
                if (this.configuration instanceof IPopupEditorConfiguration) {
                    IPopupEditorHelper helper = ((IPopupEditorConfiguration)this.configuration).createPopupEditorHelper((Object)this);
                    helper.showEditor();
                    return;
                }
                if (this.configuration instanceof IAdvancedEditorConfiguration) {
                    dialog = ((IAdvancedEditorConfiguration)this.configuration).createDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()));
                } else if (this.configuration instanceof IDirectEditorConfiguration) {
                    dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()), this.configuration);
                } else {
                    return;
                }
                final Dialog finalDialog = dialog;
                if (dialog.open() != 0) break;
                TransactionalEditingDomain domain = this.getEditingDomain();
                RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                    protected void doExecute() {
                        GateNameEditPart.this.configuration.postEditAction((Object)GateNameEditPart.this.resolveSemanticElement(), ((ILabelEditorDialog)finalDialog).getValue());
                    }
                };
                domain.getCommandStack().execute((Command)command);
                break;
            }
            case 2: {
                try {
                    this.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            if (GateNameEditPart.this.isActive() && GateNameEditPart.this.isEditable()) {
                                if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                                    Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                                    GateNameEditPart.this.performDirectEdit(initialChar.charValue());
                                } else if (theRequest instanceof DirectEditRequest && GateNameEditPart.this.getEditText().equals(GateNameEditPart.this.getLabelText())) {
                                    DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                                    GateNameEditPart.this.performDirectEdit(editRequest.getLocation());
                                } else {
                                    GateNameEditPart.this.performDirectEdit();
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    protected void refreshLabel() {
        EditPolicy sfEditPolicy;
        EditPolicy pdEditPolicy;
        EditPolicy maskLabelPolicy = this.getEditPolicy("MaskManagedLabelPolicy");
        if (maskLabelPolicy == null) {
            this.setLabelTextHelper(this.getFigure(), this.getLabelText());
            this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
        }
        if ((pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
        this.refreshBounds();
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextUnderline(style.isUnderline());
        }
        if (this.resolveSemanticElement() instanceof Feature) {
            if (((Feature)this.resolveSemanticElement()).isStatic()) {
                ((WrappingLabel)this.getFigure()).setTextUnderline(true);
            } else {
                ((WrappingLabel)this.getFigure()).setTextUnderline(false);
            }
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextStrikeThrough(style.isStrikeThrough());
        }
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject element = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(element);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + i, (NotificationListener)this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = GateNameEditPart.this.getLabelTextHelper(GateNameEditPart.this.getFigure());
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return (View)this.getModel();
    }

    public int getDirectEditionType() {
        if (this.checkExtendedEditor()) {
            this.initExtendedEditorConfiguration();
            return 4;
        }
        if (this.checkDefaultEdition()) {
            return 2;
        }
        return 8;
    }

    protected boolean checkExtendedEditor() {
        if (this.resolveSemanticElement() != null) {
            return DirectEditorsUtil.hasSpecificEditorConfiguration((String)this.resolveSemanticElement().eClass().getInstanceClassName());
        }
        return false;
    }

    protected boolean checkDefaultEdition() {
        return this.getParser() != null;
    }

    protected void initExtendedEditorConfiguration() {
        if (this.configuration == null) {
            String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
            this.configuration = languagePreferred != null && !languagePreferred.equals("") ? DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)this.resolveSemanticElement().eClass().getInstanceClassName()) : DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (String)this.resolveSemanticElement().eClass().getInstanceClassName());
        }
    }

    protected void updateExtendedEditorConfiguration() {
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
        if (languagePreferred != null && !languagePreferred.equals("") && languagePreferred != this.configuration.getLanguage()) {
            this.configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)this.resolveSemanticElement().eClass().getInstanceClassName());
        } else if ("Simple Direct Editor".equals(languagePreferred)) {
            this.configuration = null;
        }
    }

    protected void performDefaultDirectEditorEdit(final Request theRequest) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    if (GateNameEditPart.this.isActive() && GateNameEditPart.this.isEditable()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            GateNameEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && GateNameEditPart.this.getEditText().equals(GateNameEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            GateNameEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            GateNameEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else {
            ISemanticParser modelParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
            }
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createFigure() {
        WrappingLabel label = new WrappingLabel();
        this.defaultText = this.getLabelTextHelper((IFigure)label);
        return label;
    }

    public class GateNameParser
    extends MessageFormatParser
    implements ISemanticParser {
        public GateNameParser() {
            super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
        }

        public String getPrintString(IAdaptable adapter, int flags) {
            return super.getPrintString(adapter, flags);
        }

        protected String getPrintString(Gate gate) {
            Message message = gate.getMessage();
            if (message != null) {
                MessageDirection direction = null;
                EObject parent = gate.eContainer();
                if (parent instanceof CombinedFragment) {
                    CombinedFragment cf = (CombinedFragment)parent;
                    if (gate == message.getSendEvent()) {
                        MessageEnd receiveEvent = message.getReceiveEvent();
                        Lifeline lifeline = this.getCoveredBy(receiveEvent);
                        if (!cf.getCovereds().contains((Object)lifeline)) {
                            direction = MessageDirection.OUT;
                        }
                    } else {
                        MessageEnd sendEvent = message.getSendEvent();
                        Lifeline coveredBy = this.getCoveredBy(sendEvent);
                        if (!cf.getCovereds().contains((Object)coveredBy)) {
                            direction = MessageDirection.IN;
                        }
                    }
                } else if (parent instanceof Interaction) {
                    if (gate == message.getSendEvent()) {
                        direction = MessageDirection.IN;
                    } else if (gate == message.getReceiveEvent()) {
                        direction = MessageDirection.OUT;
                    }
                }
                if (direction == null) {
                    if (gate == message.getSendEvent()) {
                        direction = MessageDirection.OUT;
                    } else if (gate == message.getReceiveEvent()) {
                        direction = MessageDirection.IN;
                    }
                }
                if (direction != null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(String.valueOf(direction.getName()) + "_");
                    buf.append(message.getName());
                    return new String(buf);
                }
            }
            return null;
        }

        private Lifeline getCoveredBy(MessageEnd messageEnd) {
            if (messageEnd == null) {
                return null;
            }
            if (messageEnd instanceof OccurrenceSpecification) {
                return ((OccurrenceSpecification)messageEnd).getCovered();
            }
            return null;
        }

        protected EStructuralFeature getEStructuralFeature(Object notification) {
            Object feature;
            EStructuralFeature featureImpl = null;
            if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
                featureImpl = (EStructuralFeature)feature;
            }
            return featureImpl;
        }

        private boolean isValidFeature(EStructuralFeature feature) {
            return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature);
        }

        public List getSemanticElementsBeingParsed(EObject element) {
            if (element instanceof Gate) {
                return Collections.singletonList(element);
            }
            return Collections.emptyList();
        }

        public boolean areSemanticElementsAffected(EObject listener, Object notification) {
            EStructuralFeature feature = this.getEStructuralFeature(notification);
            return this.isValidFeature(feature);
        }
    }
}

