/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.update.UpdaterLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramUpdater;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCanonicalEditPolicy
extends CanonicalEditPolicy {
    protected void refreshOnActivate() {
        List c = this.getHost().getChildren();
        int i = 0;
        while (i < c.size()) {
            ((EditPart)c.get(i)).activate();
            ++i;
        }
        super.refreshOnActivate();
    }

    protected EStructuralFeature getFeatureToSynchronize() {
        return UMLPackage.eINSTANCE.getPackage_PackagedElement();
    }

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        List<UMLNodeDescriptor> childDescriptors = UMLDiagramUpdater.getPackage_1000SemanticChildren(viewObject);
        for (UMLNodeDescriptor d : childDescriptors) {
            result.add(d.getModelElement());
        }
        return result;
    }

    protected boolean isOrphaned(Collection<EObject> semanticChildren, View view) {
        return this.isMyDiagramElement(view) && !semanticChildren.contains(view.getElement());
    }

    private boolean isMyDiagramElement(View view) {
        return 2001 == UMLVisualIDRegistry.getVisualID(view);
    }

    protected void refreshSemantic() {
        if (this.resolveSemanticElement() == null) {
            return;
        }
        LinkedList<IAdaptable> createdViews = new LinkedList<IAdaptable>();
        List<UMLNodeDescriptor> childDescriptors = UMLDiagramUpdater.getPackage_1000SemanticChildren((View)this.getHost().getModel());
        LinkedList orphaned = new LinkedList();
        LinkedList<View> knownViewChildren = new LinkedList<View>();
        for (View v : this.getViewChildren()) {
            if (!this.isMyDiagramElement(v)) continue;
            knownViewChildren.add(v);
        }
        Iterator<UMLNodeDescriptor> descriptorsIterator = childDescriptors.iterator();
        while (descriptorsIterator.hasNext()) {
            UMLNodeDescriptor next = descriptorsIterator.next();
            String hint = UMLVisualIDRegistry.getType(next.getVisualID());
            LinkedList<View> perfectMatch = new LinkedList<View>();
            for (View childView : this.getViewChildren()) {
                EObject semanticElement = childView.getElement();
                if (!next.getModelElement().equals(semanticElement) || !hint.equals(childView.getType())) continue;
                perfectMatch.add(childView);
            }
            if (perfectMatch.size() <= 0) continue;
            descriptorsIterator.remove();
            knownViewChildren.remove(perfectMatch.getFirst());
        }
        orphaned.addAll(knownViewChildren);
        ArrayList<CreateViewRequest.ViewDescriptor> viewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>(childDescriptors.size());
        for (UMLNodeDescriptor next : childDescriptors) {
            String hint = UMLVisualIDRegistry.getType(next.getVisualID());
            CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(next.getModelElement(), hint);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, hint, -1, false, this.host().getDiagramPreferencesHint());
            viewDescriptors.add(descriptor);
        }
        boolean changed = this.deleteViews(orphaned.iterator());
        CreateViewRequest request = this.getCreateViewRequest(viewDescriptors);
        Command cmd = this.getCreateViewCommand((CreateRequest)request);
        if (cmd != null && cmd.canExecute()) {
            SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)this.host().getNotationView())).execute();
            this.executeCommand(cmd);
            List nl = (List)request.getNewObject();
            createdViews.addAll(nl);
        }
        if (changed || createdViews.size() > 0) {
            this.postProcessRefreshSemantic(createdViews);
        }
        Collection<IAdaptable> createdConnectionViews = this.refreshConnections();
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private EditPart getSourceEditPart(UpdaterLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        return this.getEditPart(descriptor.getSource(), domain2NotationMap);
    }

    private EditPart getTargetEditPart(UpdaterLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        return this.getEditPart(descriptor.getDestination(), domain2NotationMap);
    }

    protected final EditPart getHintedEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap, int hintVisualId) {
        View view = domain2NotationMap.getHinted(domainModelElement, UMLVisualIDRegistry.getType(hintVisualId));
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private Collection<IAdaptable> refreshConnections() {
        Domain2Notation domain2NotationMap = new Domain2Notation();
        Collection<UMLLinkDescriptor> linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        block0: while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = UMLVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator<UMLLinkDescriptor> linkDescriptorsIterator = linkDescriptors.iterator();
            while (linkDescriptorsIterator.hasNext()) {
                UMLLinkDescriptor nextLinkDescriptor = linkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                linkDescriptorsIterator.remove();
                continue block0;
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection<UMLLinkDescriptor> collectAllLinks(View view, Domain2Notation domain2NotationMap) {
        if (!"PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID(view))) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_1000ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 2001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInteraction_2001ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConsiderIgnoreFragment_3007ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getCombinedFragment_3004ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInteractionOperand_3005ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInteractionUse_3002ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3016: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getContinuation_3016ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getLifeline_3001ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getActionExecutionSpecification_3006ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getBehaviorExecutionSpecification_3003ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3017: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getStateInvariant_3017ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3018: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getCombinedFragment_3018ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3019: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getTimeConstraint_3019ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3020: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getTimeObservation_3020ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3021: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDurationConstraint_3021ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3022: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDestructionOccurrenceSpecification_3022ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConstraint_3008ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getComment_3009ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3023: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDurationConstraint_3023ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 3024: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDurationObservation_3024ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 4003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getMessage_4003ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 4004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getMessage_4004ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 4005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getMessage_4005ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 4006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getMessage_4006ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 4007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getMessage_4007ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 4008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getMessage_4008ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 4009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getMessage_4009ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
                break;
            }
            case 4012: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getGeneralOrdering_4012ContainedLinks(view));
                }
                domain2NotationMap.putView(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection<IAdaptable> createConnections(Collection<UMLLinkDescriptor> linkDescriptors, Domain2Notation domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (UMLLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getSourceEditPart(nextLinkDescriptor, domain2NotationMap);
            EditPart targetEditPart = this.getTargetEditPart(nextLinkDescriptor, domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), UMLVisualIDRegistry.getType(nextLinkDescriptor.getVisualID()), -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap) {
        View view = (View)domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Domain2Notation
    extends HashMap<EObject, View> {
        protected Domain2Notation() {
        }

        public boolean containsDomainElement(EObject domainElement) {
            return this.containsKey(domainElement);
        }

        public View getHinted(EObject domainEObject, String hint) {
            return (View)this.get(domainEObject);
        }

        public void putView(EObject domainElement, View view) {
            if (!this.containsKey(view.getElement())) {
                this.put(domainElement, view);
            }
        }
    }
}

