/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.locator;

import java.util.Collections;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.locator.AdvancedBorderItemLocator;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomDurationConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomTimeConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomTimeObservationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DestructionOccurrenceSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;

public class TimeMarkElementPositionLocator
extends AdvancedBorderItemLocator {
    private EditPart editPart = null;

    public TimeMarkElementPositionLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public TimeMarkElementPositionLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public TimeMarkElementPositionLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public void setEditPart(EditPart part) {
        this.editPart = part;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Point destr;
        Rectangle realLocation = new Rectangle(proposedLocation);
        int side = TimeMarkElementPositionLocator.findClosestSideOfParent(realLocation, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realLocation.getTopLeft(), side, 0, borderItem);
        if (this.timeElementPointsDestructionEvent() && (destr = this.getDestructionEventCenter()) != null) {
            if (this.editPart instanceof DurationConstraintEditPart) {
                realLocation.height = destr.y - newTopLeft.y;
            } else if (this.editPart instanceof TimeObservationEditPart || this.editPart instanceof TimeConstraintEditPart) {
                newTopLeft.y = destr.y - realLocation.height / 2;
            }
        }
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    protected Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem) {
        Point recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        IFigure conflictingBorderItem = this.getConflictingBorderItemFigure(recommendedLocation, borderItem);
        if (circuitCount < 2 && conflictingBorderItem != null) {
            if (suggestedSide == 8) {
                return this.locateOnBorder(recommendedLocation, 16, circuitCount + 1, borderItem);
            }
            return this.locateOnBorder(recommendedLocation, 8, circuitCount + 1, borderItem);
        }
        return recommendedLocation;
    }

    protected Rectangle getParentDotLineBorder() {
        for (Object childFig : this.getParentFigure().getChildren()) {
            if (!(childFig instanceof LifelineFigure)) continue;
            LifelineDotLineCustomFigure dotline = ((LifelineFigure)((Object)childFig)).getFigureLifelineDotLineFigure();
            return dotline.getBounds().getCopy();
        }
        return super.getParentBorder();
    }

    protected Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        int[] horizontalGap = this.getHorizontalGap();
        Rectangle bounds = this.getParentDotLineBorder();
        int parentFigureXCenter = bounds.getCenter().x;
        int parentFigureHeight = bounds.height;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = this.getCorrectSize(borderItem);
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureXCenter - borderItemSize.width + horizontalGap[0];
        int eastX = parentFigureXCenter + horizontalGap[1];
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        }
        return new Point(newX, newY);
    }

    private Point getDestructionEventCenter() {
        LifelineEditPart lifeline = SequenceUtil.getParentLifelinePart(this.editPart);
        if (lifeline != null) {
            for (Object child : lifeline.getChildren()) {
                if (!(child instanceof DestructionOccurrenceSpecificationEditPart)) continue;
                return ((DestructionOccurrenceSpecificationEditPart)((Object)child)).getFigure().getBounds().getCenter();
            }
        }
        return null;
    }

    private boolean timeElementPointsDestructionEvent() {
        if (this.editPart instanceof GraphicalEditPart) {
            EObject element = ((GraphicalEditPart)this.editPart).resolveSemanticElement();
            EList occurrences = Collections.emptyList();
            if (element instanceof TimeObservation) {
                NamedElement occurence = ((TimeObservation)element).getEvent();
                occurrences = Collections.singletonList(occurence);
            } else if (element instanceof TimeConstraint || element instanceof DurationConstraint) {
                occurrences = ((IntervalConstraint)element).getConstrainedElements();
            }
            for (Element occurrence : occurrences) {
                if (!(occurrence instanceof DestructionOccurrenceSpecificationEditPart)) continue;
                return true;
            }
        }
        return false;
    }

    private int[] getHorizontalGap() {
        int[] horizontalGap = new int[2];
        if (this.editPart instanceof GraphicalEditPart) {
            LifelineEditPart lifeline = SequenceUtil.getParentLifelinePart(this.editPart);
            EObject element = ((GraphicalEditPart)this.editPart).resolveSemanticElement();
            EList occurrences = Collections.emptyList();
            if (element instanceof TimeObservation) {
                NamedElement occurence = ((TimeObservation)element).getEvent();
                occurrences = Collections.singletonList(occurence);
            } else if (element instanceof TimeConstraint || element instanceof DurationConstraint) {
                occurrences = ((IntervalConstraint)element).getConstrainedElements();
            }
            boolean horizontalGapSet = false;
            for (Element occurrence : occurrences) {
                if (!(occurrence instanceof OccurrenceSpecification)) continue;
                EditPart part = SequenceUtil.getLinkedEditPart((EditPart)lifeline, (OccurrenceSpecification)occurrence);
                if (part instanceof ConnectionEditPart && occurrence instanceof MessageOccurrenceSpecification) {
                    ConnectionEditPart conn = (ConnectionEditPart)part;
                    Message message = ((MessageOccurrenceSpecification)occurrence).getMessage();
                    if (message != null) {
                        boolean start = message.getSendEvent() != null && message.getSendEvent().equals(occurrence);
                        part = start ? conn.getSource() : conn.getTarget();
                    }
                }
                if (!(part instanceof ShapeNodeEditPart) || ((Object)((Object)lifeline)).equals(part)) continue;
                Rectangle execBounds = ((ShapeNodeEditPart)part).getFigure().getBounds();
                Rectangle parentBounds = this.getParentBorder();
                int leftGap = execBounds.getLeft().x - parentBounds.getCenter().x;
                int rightGap = execBounds.getRight().x - parentBounds.getCenter().x;
                if (part instanceof DestructionOccurrenceSpecificationEditPart) {
                    leftGap = 0;
                    rightGap = 0;
                }
                if (!horizontalGapSet) {
                    horizontalGap[0] = leftGap;
                    horizontalGap[1] = rightGap;
                    horizontalGapSet = true;
                    continue;
                }
                horizontalGap[0] = Math.min(horizontalGap[0], leftGap);
                horizontalGap[1] = Math.max(horizontalGap[1], rightGap);
            }
        }
        return horizontalGap;
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        Point parentCenter = parentBorder.getCenter();
        Point childCenter = proposedLocation.getCenter();
        if (childCenter.x < parentCenter.x) {
            return 8;
        }
        return 16;
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getCorrectSize(borderItem);
        Rectangle rectSuggested = this.getConstraint().getCopy();
        if (rectSuggested.getTopLeft().x == 0 && rectSuggested.getTopLeft().y == 0) {
            rectSuggested.setLocation(this.getPreferredLocation(borderItem));
        } else {
            rectSuggested.setLocation(rectSuggested.getLocation().translate(this.getParentBorder().getTopLeft()));
        }
        rectSuggested.setSize(size);
        Rectangle validLocation = this.getValidLocation(rectSuggested, borderItem);
        borderItem.setBounds(validLocation);
        if (this.timeElementPointsDestructionEvent() && this.editPart instanceof DurationConstraintEditPart) {
            int w = this.getConstraint().getSize().width;
            this.getConstraint().setSize(w, validLocation.height);
        }
        this.setCurrentSideOfParent(TimeMarkElementPositionLocator.findClosestSideOfParent(borderItem.getBounds(), this.getParentBorder()));
        this.redrawTimeMarks(borderItem, validLocation);
    }

    protected final Dimension getCorrectSize(IFigure borderItem) {
        Dimension size = this.getConstraint().getSize();
        if (size.isEmpty()) {
            size.union(borderItem.getPreferredSize(size.width, size.height));
        }
        return size;
    }

    private void redrawTimeMarks(IFigure borderItem, Rectangle location) {
        for (Object child : borderItem.getChildren()) {
            if (child instanceof CustomTimeConstraintEditPart.TimeConstraintFigure) {
                ((CustomTimeConstraintEditPart.TimeConstraintFigure)((Object)child)).setCurrentSideOfFigure(this.getCurrentSideOfParent(), location);
                continue;
            }
            if (child instanceof CustomTimeObservationEditPart.TimeObservationFigure) {
                ((CustomTimeObservationEditPart.TimeObservationFigure)((Object)child)).setCurrentSideOfFigure(this.getCurrentSideOfParent(), location);
                continue;
            }
            if (child instanceof CustomDurationConstraintEditPart.CustomDurationConstraintFigure) {
                ((CustomDurationConstraintEditPart.CustomDurationConstraintFigure)((Object)child)).updateArrow(location.width, location.height);
                continue;
            }
            if (!(child instanceof DefaultSizeNodeFigure)) continue;
            this.redrawTimeMarks((IFigure)child, location);
        }
    }
}

