/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.EditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceDeleteHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;

public class CombinedFragmentDeleteHelper {
    public static ICommand createDestroyElementCommand(CombinedFragment cf, TransactionalEditingDomain transactionalEditingDomain, IElementEditService provider, DestroyElementRequest req, ICommand deleteCommand, CombinedFragmentEditPart host) {
        CompositeTransactionalCommand deleteAll = new CompositeTransactionalCommand(transactionalEditingDomain, null);
        deleteAll.add((IUndoableOperation)deleteCommand);
        CompositeTransactionalCommand deleteCfOnly = new CompositeTransactionalCommand(transactionalEditingDomain, null);
        for (InteractionOperand op : cf.getOperands()) {
            deleteCfOnly.add((IUndoableOperation)new MoveOperandFragmentsCommand(host, cf, op, new EditRequest(transactionalEditingDomain, (Element)cf)));
        }
        deleteCfOnly.add((IUndoableOperation)new DeleteCombinedFragmentCommand(transactionalEditingDomain, provider, req));
        return new SelectAndDeleteCommand(deleteAll, deleteCfOnly, new String[]{"Delete all", "Keep contents"});
    }

    public static ICommand createDeleteViewCommand(CombinedFragment cf, TransactionalEditingDomain transactionalEditingDomain, CombinedFragmentEditPart host) {
        CompositeTransactionalCommand deleteAll = new CompositeTransactionalCommand(transactionalEditingDomain, null);
        List<Element> elements = SequenceUtil.getCombinedFragmentAssociatedElement(cf);
        SequenceDeleteHelper.deleteView(deleteAll, elements, transactionalEditingDomain);
        CompositeTransactionalCommand deleteCfOnly = new CompositeTransactionalCommand(transactionalEditingDomain, null);
        for (InteractionOperand op : cf.getOperands()) {
            deleteCfOnly.add((IUndoableOperation)new MoveOperandFragmentsCommand(host, cf, op, new EditRequest(transactionalEditingDomain, (Element)cf)));
        }
        for (Element element : cf.getOperands()) {
            SequenceDeleteHelper.deleteView(deleteCfOnly, element, transactionalEditingDomain);
        }
        return new SelectAndDeleteCommand(deleteAll, deleteCfOnly, new String[]{"Hide all", "Keep contents"});
    }

    static Rectangle getAbsoluteBounds(AbstractGraphicalEditPart part) {
        Rectangle b = part.getFigure().getBounds().getCopy();
        part.getFigure().translateToAbsolute((Translatable)b);
        return b;
    }

    public static EditPart findEditPartByModel(EditPart part, EObject m) {
        List children = part.getChildren();
        if (children != null && children.size() > 0) {
            for (Object o : children) {
                EditPart p = (EditPart)o;
                Object model = p.getModel();
                if (model != null && model instanceof View && m.equals(((View)model).getElement())) {
                    return p;
                }
                EditPart res = CombinedFragmentDeleteHelper.findEditPartByModel(p, m);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    static class DeleteCombinedFragmentCommand
    extends AbstractTransactionalCommand {
        private IElementEditService provider;
        private DestroyElementRequest req;

        public DeleteCombinedFragmentCommand(TransactionalEditingDomain domain, IElementEditService provider, DestroyElementRequest req) {
            super(domain, null, null);
            this.provider = provider;
            this.req = req;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ICommand deleteCommand = this.provider.getEditCommand((IEditCommandRequest)this.req);
            try {
                deleteCommand.execute(monitor, info);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            return CommandResult.newOKCommandResult();
        }
    }

    public static class EditRequest
    extends AbstractEditCommandRequest {
        private Element elementToEdit;

        public EditRequest(TransactionalEditingDomain editingDomain, Element elementToEdit) {
            super(editingDomain);
            this.elementToEdit = elementToEdit;
        }

        public Object getEditHelperContext() {
            IClientContext context = this.getClientContext();
            if (context == null) {
                return this.getElementToEdit();
            }
            return new EditHelperContext((EObject)this.getElementToEdit(), context);
        }

        public Element getElementToEdit() {
            return this.elementToEdit;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveOperandFragmentsCommand
    extends EditElementCommand {
        private InteractionFragment parent;
        private EList<InteractionFragment> fragmentsToMove;
        private InteractionOperand sourceOperand;
        private CombinedFragment combinedFragment;
        private CombinedFragmentEditPart host;

        public MoveOperandFragmentsCommand(CombinedFragmentEditPart host, CombinedFragment cf, InteractionOperand op, EditRequest editRequest) {
            super(null, (EObject)editRequest.getElementToEdit(), (IEditCommandRequest)editRequest);
            InteractionOperand enclosingOp = cf.getEnclosingOperand();
            if (enclosingOp != null) {
                Element owner = enclosingOp.getOwner();
                if (owner instanceof CombinedFragment) {
                    this.parent = enclosingOp;
                }
            } else {
                Element owner = cf.getOwner();
                if (owner instanceof Interaction) {
                    this.parent = (InteractionFragment)owner;
                }
            }
            this.host = host;
            this.sourceOperand = op;
            this.combinedFragment = cf;
            this.fragmentsToMove = op.getFragments();
        }

        public boolean canExecute() {
            return this.sourceOperand != null && this.combinedFragment != null;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.parent != null && !this.fragmentsToMove.isEmpty()) {
                List<CombinedFragmentEditPart> parts = this.collectCombinedFragmentParts();
                if (this.parent instanceof InteractionOperand) {
                    ((InteractionOperand)this.parent).getFragments().addAll(this.fragmentsToMove);
                    this.moveToOperandPart((GraphicalEditPart)((InteractionOperandEditPart)this.host.getParent()), parts);
                } else if (this.parent instanceof Interaction) {
                    ((Interaction)this.parent).getFragments().addAll(this.fragmentsToMove);
                    this.moveToInteractionPart((GraphicalEditPart)((InteractionInteractionCompartmentEditPart)this.host.getParent()), parts);
                }
            }
            this.sourceOperand.getFragments().clear();
            return CommandResult.newOKCommandResult();
        }

        private void moveToOperandPart(GraphicalEditPart op, List<CombinedFragmentEditPart> keepParts) {
            if (!keepParts.isEmpty()) {
                Rectangle parentBounds = CombinedFragmentDeleteHelper.getAbsoluteBounds((AbstractGraphicalEditPart)op.getParent());
                for (CombinedFragmentEditPart cef : keepParts) {
                    View view = cef.getNotationView();
                    op.getNotationView().getPersistedChildren().add((Object)view);
                    Bounds bounds = (Bounds)((Shape)cef.getNotationView()).getLayoutConstraint();
                    Rectangle absolute = CombinedFragmentDeleteHelper.getAbsoluteBounds((AbstractGraphicalEditPart)cef);
                    bounds.setX(absolute.x() - parentBounds.x());
                    bounds.setY(absolute.y() - parentBounds.y());
                }
            }
        }

        private void moveToInteractionPart(GraphicalEditPart op, List<CombinedFragmentEditPart> keepParts) {
            if (!keepParts.isEmpty()) {
                Rectangle b = CombinedFragmentDeleteHelper.getAbsoluteBounds((AbstractGraphicalEditPart)op);
                for (CombinedFragmentEditPart cef : keepParts) {
                    View view = cef.getNotationView();
                    op.getNotationView().getPersistedChildren().add((Object)view);
                    Bounds bounds = (Bounds)((Shape)cef.getNotationView()).getLayoutConstraint();
                    Rectangle absolute = CombinedFragmentDeleteHelper.getAbsoluteBounds((AbstractGraphicalEditPart)cef);
                    absolute.performTranslate(-b.x, -b.y);
                    bounds.setX(absolute.x() - 5);
                    bounds.setY(absolute.y() - 6);
                }
            }
        }

        private List<CombinedFragmentEditPart> collectCombinedFragmentParts() {
            ArrayList<CombinedFragmentEditPart> parts = new ArrayList<CombinedFragmentEditPart>();
            for (InteractionFragment f : this.fragmentsToMove) {
                EditPart p;
                if (!(f instanceof CombinedFragment) || !((p = CombinedFragmentDeleteHelper.findEditPartByModel((EditPart)this.host, (EObject)f)) instanceof CombinedFragmentEditPart)) continue;
                parts.add((CombinedFragmentEditPart)p);
            }
            return parts;
        }
    }

    public static class SelectAndDeleteCommand
    extends PopupMenuCommand {
        private String choice;
        private CompositeTransactionalCommand deletaAllCommand;
        private CompositeTransactionalCommand keepCommand;
        private String[] labels;

        public SelectAndDeleteCommand(CompositeTransactionalCommand deletaAllCommand, CompositeTransactionalCommand keepCommand, String[] labels) {
            super("prompt for delete", Display.getCurrent().getActiveShell());
            PopupMenu popupMenu = new PopupMenu(Arrays.asList(labels), (ILabelProvider)new SelectLabelProvider());
            this.setPopupMenu(popupMenu);
            this.labels = labels;
            this.deletaAllCommand = deletaAllCommand;
            this.keepCommand = keepCommand;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
            if (!cmdResult.getStatus().isOK()) {
                return cmdResult;
            }
            this.choice = cmdResult.getReturnValue().toString();
            if (this.choice.contains(this.labels[0])) {
                this.deletaAllCommand.execute(progressMonitor, info);
                return this.deletaAllCommand.getCommandResult();
            }
            this.keepCommand.execute(progressMonitor, info);
            return this.keepCommand.getCommandResult();
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.choice != null && this.choice.contains(this.labels[0])) {
                this.deletaAllCommand.undo(progressMonitor, info);
                return this.deletaAllCommand.getCommandResult();
            }
            this.keepCommand.undo(progressMonitor, info);
            return this.keepCommand.getCommandResult();
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.choice.contains(this.labels[0])) {
                this.deletaAllCommand.redo(progressMonitor, info);
                return this.deletaAllCommand.getCommandResult();
            }
            this.keepCommand.redo(progressMonitor, info);
            return this.keepCommand.getCommandResult();
        }
    }

    public static class SelectLabelProvider
    extends LabelProvider {
        public String getText(Object object) {
            return object.toString();
        }

        public Image getImage(Object object) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE");
        }
    }
}

