/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.services.validation.EcoreDiagnostician;
import org.eclipse.papyrus.infra.services.validation.IPapyrusDiagnostician;
import org.eclipse.papyrus.infra.services.validation.ValidationTool;
import org.eclipse.papyrus.infra.services.validation.ValidationUtils;
import org.eclipse.papyrus.infra.services.validation.preferences.PreferenceUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractValidateCommand
extends AbstractTransactionalCommand {
    final String modelValidationViewID = "org.eclipse.papyrus.views.validation.ModelValidationView";
    protected TransactionalEditingDomain domain;
    protected EObject selectedElement;
    protected Diagnostic diagnostic;
    protected IPapyrusDiagnostician diagnostician;

    public AbstractValidateCommand(String label, TransactionalEditingDomain domain, EObject selectedElement) {
        this(label, domain, selectedElement, new EcoreDiagnostician());
    }

    public AbstractValidateCommand(String label, TransactionalEditingDomain domain, EObject selectedElement, IPapyrusDiagnostician diagnostician) {
        super(domain, label, Collections.EMPTY_LIST);
        this.domain = domain;
        this.selectedElement = selectedElement;
        this.diagnostician = diagnostician;
    }

    protected Resource getValidationResource() {
        return ValidationUtils.getValidationResource(this.selectedElement);
    }

    protected void runValidation(final EObject validateElement) {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runValidationWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    AbstractValidateCommand.this.diagnostic = AbstractValidateCommand.this.validate(progressMonitor, validateElement);
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        IRunnableWithProgress createMarkersWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    AbstractValidateCommand.this.handleDiagnostic(progressMonitor, AbstractValidateCommand.this.diagnostic, validateElement, shell);
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        createMarkersWithProgress = new ValidationTool(validateElement).wrap(createMarkersWithProgress);
        try {
            this.diagnostic = null;
            new ProgressMonitorDialog(shell).run(true, true, runValidationWithProgress);
            if (this.diagnostic != null) {
                int markersToCreate = this.diagnostic.getChildren().size();
                if (markersToCreate > 0 && PreferenceUtils.getAutoShowValidation()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.papyrus.views.validation.ModelValidationView");
                }
                new ProgressMonitorDialog(shell).run(false, true, createMarkersWithProgress);
            }
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
        }
    }

    protected Diagnostic validate(IProgressMonitor progressMonitor, EObject validateElement) {
        int validationSteps = 0;
        TreeIterator i = validateElement.eAllContents();
        while (i.hasNext()) {
            ++validationSteps;
            i.next();
        }
        progressMonitor.beginTask("", validationSteps);
        AdapterFactory adapterFactory = this.domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory() : null;
        this.diagnostician.initialize(adapterFactory, progressMonitor);
        BasicDiagnostic diagnostic = this.diagnostician.createDefaultDiagnostic(validateElement);
        Map<Object, Object> context = this.diagnostician.createDefaultContext();
        progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{this.diagnostician.getObjectLabel(validateElement)}));
        this.diagnostician.validate(validateElement, (DiagnosticChain)diagnostic, context);
        if (progressMonitor.isCanceled()) {
            return null;
        }
        return diagnostic;
    }

    protected void handleDiagnostic(IProgressMonitor monitor, Diagnostic diagnostic, EObject validateElement, Shell shell) {
        Resource resource = this.getValidationResource();
        if (resource != null && validateElement != null) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            ValidationTool vt = new ValidationTool(validateElement, resource);
            int markersToCreate = diagnostic.getChildren().size();
            sub.beginTask("Delete existing markers", 1);
            this.flushDisplayEvents(shell.getDisplay());
            vt.deleteSubMarkers((IProgressMonitor)sub.newChild(1));
            monitor.setTaskName("Create markers (total: " + markersToCreate + " markers) and refresh diagrams");
            this.flushDisplayEvents(shell.getDisplay());
            vt.createMarkers(diagnostic, (IProgressMonitor)sub.newChild(1));
            sub.done();
        }
    }

    protected void flushDisplayEvents(Display display) {
        while (display.readAndDispatch()) {
        }
    }

    public boolean canExecute() {
        return this.selectedElement != null;
    }
}

