/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.decoration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.decoration.Activator;
import org.eclipse.papyrus.infra.services.decoration.DecorationChange;
import org.eclipse.papyrus.infra.services.decoration.IDecorationService;
import org.eclipse.papyrus.infra.services.decoration.IDecorationSpecificFunctions;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.DecorationSpecificFunctions;
import org.eclipse.papyrus.infra.services.decoration.util.DecorationUtils;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecorationService
extends Observable
implements IDecorationService {
    private final Map<String, Decoration> decorations = new HashMap<String, Decoration>();

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
    }

    @Override
    public void startService() throws ServiceException {
    }

    @Override
    public void disposeService() throws ServiceException {
    }

    public Map<String, Decoration> getDecorations() {
        return this.decorations;
    }

    @Override
    public synchronized void addListener(Observer o) {
        this.addObserver(o);
    }

    @Override
    public synchronized void deleteListener(Observer o) {
        this.deleteObserver(o);
    }

    @Override
    public synchronized void removeDecoration(String id) {
        Decoration decoration = this.decorations.get(id);
        if (decoration != null) {
            this.decorations.remove(id);
            this.setChanged();
            this.notifyObservers(new DecorationChange(DecorationChange.DecorationChangeKind.DecorationRemoved, decoration));
        }
    }

    public synchronized IPapyrusDecoration addDecoration(IPapyrusMarker marker, EObject element) {
        try {
            IDecorationSpecificFunctions infoUtil = DecorationSpecificFunctions.getDecorationInterface(marker.getType());
            if (infoUtil != null) {
                ImageDescriptor imageForGE = infoUtil.getImageDescriptorForGE(marker);
                ImageDescriptor imageForME = infoUtil.getImageDescriptorForME(marker);
                Decoration.PreferedPosition position = infoUtil.getPreferedPosition(marker);
                int priority = infoUtil.getPriority(marker);
                IPapyrusDecoration decoration = this.addDecoration(marker.toString(), marker.getType(), element, imageForGE, imageForME, position, infoUtil.getMessage(marker), priority);
                return decoration;
            }
        }
        catch (CoreException e) {
            Activator.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public synchronized IPapyrusDecoration addDecoration(String id, String type, EObject element, ImageDescriptor decorationImageForGE, ImageDescriptor decorationImageForME, Decoration.PreferedPosition position, String message, int priority) {
        DecorationChange.DecorationChangeKind decorationChangeKind;
        Decoration decoration = this.decorations.get(id);
        if (decoration == null) {
            decorationChangeKind = DecorationChange.DecorationChangeKind.DecorationAdded;
            decoration = new Decoration(id, type, decorationImageForGE, decorationImageForME, message, element, priority);
            this.decorations.put(id, decoration);
        } else {
            decorationChangeKind = DecorationChange.DecorationChangeKind.DecorationModified;
            decoration.setDecorationImageForGE(decorationImageForGE);
            decoration.setDecorationImageForME(decorationImageForME);
            decoration.setMessage(message);
            decoration.setPriority(priority);
        }
        decoration.setPosition(position);
        this.setChanged();
        this.notifyObservers(new DecorationChange(decorationChangeKind, decoration));
        return decoration;
    }

    @Override
    public List<IPapyrusDecoration> getDecorations(Object element, boolean navigateToParents) {
        DecorationUtils tool = new DecorationUtils(element);
        return tool.getDecorations(this, navigateToParents);
    }

    public void notifyMarkerChange(EObject eObjectOfMarker, IPapyrusMarker marker, int addedOrRemoved) {
        if (addedOrRemoved == 1) {
            this.addDecoration(marker, eObjectOfMarker);
        } else {
            this.removeDecoration(marker.toString());
        }
    }

    public boolean isNotifiedOnInitialMarkerCheck() {
        return true;
    }
}

