/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.results;

import com.swtdesigner.ResourceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.views.search.regex.PatternHelper;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.AttributeMatch;
import org.eclipse.papyrus.views.search.results.ModelElementMatch;
import org.eclipse.papyrus.views.search.results.ModelMatch;
import org.eclipse.papyrus.views.search.results.ViewerMatch;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.papyrus.views.search.utils.MatchUtils;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class PapyrusSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    MatchFilter[] possibleMatchFilter;
    private AbstractPapyrusQuery searchQuery;

    public PapyrusSearchResult(AbstractPapyrusQuery query) {
        this.searchQuery = query;
        this.possibleMatchFilter = new MatchFilter[0];
    }

    public AbstractPapyrusQuery getQuery() {
        return this.searchQuery;
    }

    public void setPossibleMatchFilter(MatchFilter[] possibleMatchFilter) {
        this.possibleMatchFilter = possibleMatchFilter;
    }

    public MatchFilter[] getAllMatchFilters() {
        return this.possibleMatchFilter;
    }

    public String getLabel() {
        return String.valueOf(this.getMatchCount()) + Messages.PapyrusSearchResult_0 + this.searchQuery.getSearchQueryText() + Messages.PapyrusSearchResult_1;
    }

    public String getTooltip() {
        return Messages.PapyrusSearchResult_2;
    }

    public ImageDescriptor getImageDescriptor() {
        return ResourceManager.getPluginImageDescriptor("org.eclipse.papyrus.uml.search.ui", "icons/PapyrusSearch.png");
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        HashSet<AbstractResultEntry> results = new HashSet<AbstractResultEntry>();
        Set allMatches = MatchUtils.getMatches((AbstractTextSearchResult)result, (boolean)true);
        for (AbstractResultEntry modelMatch : allMatches) {
            Object element = modelMatch.getElement();
            if (!(element instanceof ScopeEntry) || !((ScopeEntry)element).getResource().equals((Object)file)) continue;
            results.add(modelMatch);
        }
        Match[] arrayResult = new Match[results.size()];
        return results.toArray(arrayResult);
    }

    public IFile getFile(Object element) {
        if (element instanceof ScopeEntry && ((ScopeEntry)element).getResource() instanceof IFile) {
            return (IFile)((ScopeEntry)element).getResource();
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element;
        if (match instanceof AbstractResultEntry && (element = match.getElement()) instanceof ScopeEntry) {
            ((ScopeEntry)element).getResource();
            if (((ScopeEntry)element).getResource().equals((Object)ResourceUtil.getResource((IEditorInput)editor.getEditorInput()))) {
                return true;
            }
        }
        return false;
    }

    public Match[] getMatches(Object element) {
        Match match;
        Match[] matchList = super.getMatches(element);
        HashSet<Match> matchToKeep = new HashSet<Match>();
        ArrayList<Object> sourceList = new ArrayList<Object>();
        Match[] matchArray = matchList;
        int n = matchList.length;
        int n2 = 0;
        while (n2 < n) {
            match = matchArray[n2];
            if (match instanceof AbstractResultEntry && ((AbstractResultEntry)match).getSource() != null) {
                if (match instanceof AttributeMatch) {
                    Pattern pattern;
                    Matcher m;
                    EAttribute attribute;
                    String value = null;
                    EObject target = (EObject)((AbstractResultEntry)match).getSource();
                    if (((AttributeMatch)match).getMetaAttribute() instanceof EAttribute) {
                        attribute = (EAttribute)((AttributeMatch)match).getMetaAttribute();
                        value = String.valueOf(target.eGet((EStructuralFeature)attribute));
                    } else if (((AttributeMatch)match).getMetaAttribute() instanceof Property) {
                        attribute = (Property)((AttributeMatch)match).getMetaAttribute();
                        value = (String)((Element)((AbstractResultEntry)match).getSource()).getValue(((AttributeMatch)match).getStereotype(), attribute.getName());
                    }
                    if (value != null && !this.getQuery().isRegularExpression()) {
                        if (value.length() >= match.getOffset() + match.getLength()) {
                            value = value.substring(match.getOffset(), match.getLength());
                            if (this.searchQuery.isCaseSensitive()) {
                                if (value.equals(this.searchQuery.getSearchQueryText())) {
                                    ((AbstractResultEntry)match).recursiveHierarchy((AbstractResultEntry)((AbstractResultEntry)match).getParent());
                                    matchToKeep.add(match);
                                    sourceList.add(((AbstractResultEntry)match).getSource());
                                }
                            } else if (value.equalsIgnoreCase(this.searchQuery.getSearchQueryText())) {
                                ((AbstractResultEntry)match).recursiveHierarchy((AbstractResultEntry)((AbstractResultEntry)match).getParent());
                                matchToKeep.add(match);
                                sourceList.add(((AbstractResultEntry)match).getSource());
                            }
                        }
                    } else if (this.getQuery().isRegularExpression() && this.getQuery().getSearchQueryText() != null && (m = (pattern = PatternHelper.getInstance().createPattern(this.getQuery().getSearchQueryText(), false, true)).matcher(value)).matches()) {
                        int start = m.start();
                        int end = m.end();
                        if (start == match.getOffset() && end == match.getOffset() + match.getLength()) {
                            matchToKeep.add(match);
                            sourceList.add(((AbstractResultEntry)match).getSource());
                        }
                    }
                } else if (match instanceof ModelElementMatch) {
                    ((AbstractResultEntry)match).recursiveHierarchy((AbstractResultEntry)match);
                    matchToKeep.add(match);
                    sourceList.add(((AbstractResultEntry)match).getSource());
                }
            }
            ++n2;
        }
        matchArray = matchList;
        n = matchList.length;
        n2 = 0;
        while (n2 < n) {
            Object source;
            match = matchArray[n2];
            if (match instanceof ViewerMatch && sourceList.contains(source = ((ViewerMatch)match).getSemanticElement())) {
                matchToKeep.add(match);
            }
            ++n2;
        }
        return matchToKeep.toArray(new Match[matchToKeep.size()]);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        HashSet<AbstractResultEntry> results = new HashSet<AbstractResultEntry>();
        Set allMatches = MatchUtils.getMatches((AbstractTextSearchResult)result, (boolean)true);
        for (AbstractResultEntry modelMatch : allMatches) {
            Object element = modelMatch.getElement();
            if (!(element instanceof ScopeEntry) || !((ScopeEntry)element).getResource().equals((Object)ResourceUtil.getResource((IEditorInput)editor.getEditorInput()))) continue;
            results.add(modelMatch);
        }
        Match[] arrayResult = new Match[results.size()];
        return results.toArray(arrayResult);
    }

    public int getMatchCount() {
        List<Object> elementList = Arrays.asList(this.getElements());
        int count = 0;
        for (Object element : elementList) {
            Match[] matchArray = this.getMatches(element);
            int n = matchArray.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (match instanceof ModelMatch || match instanceof ViewerMatch) {
                    ++count;
                }
                ++n2;
            }
        }
        return count;
    }
}

