/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.attributes;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.scoping.AbstractAttribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageAttribution
extends AbstractAttribution {
    public static final PackageAttribution INSTANCE = new PackageAttribution();

    @Override
    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        Package targetPackage = (Package)target;
        if (targetPackage.getImportedPackage().size() > 0) {
            HashSet<Package> allPackages = new HashSet<Package>();
            this.gatherAllPackages(allPackages, targetPackage);
            for (Package aPackage : allPackages) {
                environmentView.addAllPackages(aPackage);
                environmentView.addAllTypes(aPackage);
            }
        } else {
            environmentView.addAllPackages(targetPackage);
            environmentView.addAllTypes(targetPackage);
        }
        return scopeView.getParent();
    }

    private void gatherAllPackages(@NonNull Set<Package> allPackages, @NonNull Package targetPackage) {
        if (allPackages.add(targetPackage)) {
            for (Package importedPackage : targetPackage.getImportedPackage()) {
                this.gatherAllPackages(allPackages, importedPackage);
            }
        }
    }
}

