/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.context;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.context.AbstractParserContext;
import org.eclipse.ocl.examples.pivot.context.Base2PivotConversion;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

public class EObjectContext
extends AbstractParserContext {
    @Nullable
    protected final EObject eObject;
    private Type classContext = null;

    public EObjectContext(@NonNull MetaModelManager metaModelManager, @Nullable URI uri, @Nullable EObject eObject) {
        super(metaModelManager, uri);
        this.eObject = eObject;
    }

    @NonNull
    public Type getClassContext() {
        Type classContext2 = this.classContext;
        if (classContext2 == null) {
            try {
                if (this.eObject instanceof Type) {
                    classContext2 = this.metaModelManager.getMetaclass((Type)this.eObject);
                } else if (this.eObject != null) {
                    classContext2 = this.metaModelManager.getPivotOf(Type.class, (EObject)this.eObject.eClass());
                }
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            if (classContext2 == null) {
                classContext2 = this.metaModelManager.getOclVoidType();
            }
            this.classContext = classContext2;
        }
        return classContext2;
    }

    public void initialize(@NonNull Base2PivotConversion conversion, @NonNull ExpressionInOCL expression) {
        super.initialize(conversion, expression);
        Type classContext = this.getClassContext();
        conversion.setContextVariable(expression, "self", classContext);
    }
}

