/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainException;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Query;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.EInvocationContext;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLQueryDelegate
implements QueryDelegate {
    @NonNull
    protected OCLDelegateDomain delegateDomain;
    @NonNull
    protected final EInvocationContext parserContext;
    @NonNull
    protected final String expression;
    private ExpressionInOCL specification = null;

    public OCLQueryDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EClassifier context, @Nullable Map<String, EClassifier> parameters, @NonNull String expression) {
        this.delegateDomain = delegateDomain;
        MetaModelManager metaModelManager = delegateDomain.getMetaModelManager();
        this.parserContext = new EInvocationContext(metaModelManager, null, context, parameters);
        this.expression = expression;
    }

    public Object execute(@Nullable Object target, Map<String, ?> arguments) throws InvocationTargetException {
        Map<String, Object> nonNullArguments = arguments != null ? arguments : Collections.emptyMap();
        try {
            int argCount;
            if (this.specification == null) {
                this.prepare();
            }
            ExpressionInOCL nonNullSpecification = this.specification;
            OCL ocl = this.delegateDomain.getOCL();
            MetaModelManager metaModelManager = ocl.getMetaModelManager();
            PivotIdResolver idResolver = metaModelManager.getIdResolver();
            Object targetValue = idResolver.boxedValueOf(target);
            DomainType targetType = idResolver.getStaticTypeOf(targetValue);
            Type requiredType = nonNullSpecification.getContextVariable().getType();
            if (requiredType == null || !targetType.conformsTo((DomainStandardLibrary)metaModelManager, (DomainType)requiredType)) {
                String message = DomainUtil.bind((String)OCLMessages.WrongContextClassifier_ERROR_, (Object[])new Object[]{targetType, requiredType});
                throw new OCLDelegateException(message);
            }
            List<Variable> parameterVariables = nonNullSpecification.getParameterVariable();
            int n = argCount = arguments != null ? arguments.size() : 0;
            if (parameterVariables.size() != argCount) {
                String message = DomainUtil.bind((String)OCLMessages.MismatchedArgumentCount_ERROR_, (Object[])new Object[]{argCount, parameterVariables.size()});
                throw new OCLDelegateException(message);
            }
            Query query = ocl.createQuery(nonNullSpecification);
            EvaluationEnvironment env = query.getEvaluationEnvironment();
            for (Variable parameterVariable : parameterVariables) {
                String name = parameterVariable.getName();
                Object object = nonNullArguments.get(name);
                if (object == null && !nonNullArguments.containsKey(name)) {
                    String message = DomainUtil.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object[])new Object[]{PivotUtil.getBody(nonNullSpecification)});
                    throw new OCLDelegateException(message);
                }
                Object value = idResolver.boxedValueOf(object);
                targetType = idResolver.getStaticTypeOf(value);
                if (!targetType.conformsTo((DomainStandardLibrary)metaModelManager, (DomainType)(requiredType = (DomainType)DomainUtil.nonNullModel((Object)parameterVariable.getType())))) {
                    String message = DomainUtil.bind((String)OCLMessages.MismatchedArgumentType_ERROR_, (Object[])new Object[]{name, targetType, requiredType});
                    throw new OCLDelegateException(message);
                }
                env.add(parameterVariable, value);
            }
            Object result = query.evaluate(target);
            return idResolver.unboxedValueOf(result);
        }
        catch (InvalidValueException e) {
            String message = DomainUtil.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object[])new Object[]{PivotUtil.getBody(this.specification)});
            throw new InvocationTargetException(new OCLDelegateException(message));
        }
        catch (DomainException e) {
            String message = DomainUtil.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object[])new Object[]{PivotUtil.getBody(this.specification)});
            throw new InvocationTargetException(new OCLDelegateException(message));
        }
        catch (OCLDelegateException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void prepare() throws InvocationTargetException {
        try {
            this.specification = this.parserContext.parse(this.expression);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public String toString() {
        OCLExpression bodyExpression = this.specification.getBodyExpression();
        if (bodyExpression != null) {
            return "<" + this.delegateDomain.getURI() + ":query> " + bodyExpression;
        }
        return "<" + this.delegateDomain.getURI() + ":query> " + PivotUtil.getBody(this.specification);
    }
}

