/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluationEnvironment;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractPolyOperation;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.OperationContext;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class EObjectOperation
extends AbstractPolyOperation {
    @NonNull
    protected final Operation operation;
    @NonNull
    protected final EOperation eFeature;
    @NonNull
    protected OpaqueExpression specification;
    private ExpressionInOCL expressionInOCL = null;

    public EObjectOperation(@NonNull Operation operation, @NonNull EOperation eFeature, @NonNull OpaqueExpression specification) {
        this.operation = operation;
        this.eFeature = eFeature;
        this.specification = specification;
    }

    @Deprecated
    public EObjectOperation(@NonNull EOperation eFeature, @NonNull OpaqueExpression specification) {
        this.eFeature = eFeature;
        this.specification = specification;
        EObject constraint = specification.eContainer();
        EObject dynamicOperation = constraint.eContainer();
        assert (dynamicOperation instanceof Operation);
        this.operation = (Operation)dynamicOperation;
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue) {
        if (this.expressionInOCL == null) {
            this.resolveExpressionInOCL(evaluator, callExp, sourceValue);
        }
        return this.evaluate(evaluator, ((DomainType)DomainUtil.nonNullPivot((Object)callExp.getType())).getTypeId(), sourceValue);
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        DomainEvaluator nestedEvaluator = evaluator.createNestedEvaluator();
        DomainEvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluator.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)this.expressionInOCL.getContextVariable()), sourceValue);
        return nestedEvaluator.evaluate((DomainExpression)DomainUtil.nonNullPivot((Object)this.expressionInOCL.getBodyExpression()));
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue, @Nullable Object argumentValue) {
        if (this.expressionInOCL == null) {
            this.resolveExpressionInOCL(evaluator, callExp, sourceValue);
        }
        return this.evaluate(evaluator, ((DomainType)DomainUtil.nonNullPivot((Object)callExp.getType())).getTypeId(), sourceValue, argumentValue);
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object argumentValue) {
        DomainEvaluator nestedEvaluator = evaluator.createNestedEvaluator();
        DomainEvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluator.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)this.expressionInOCL.getContextVariable()), sourceValue);
        List<Variable> parameterVariables = this.expressionInOCL.getParameterVariable();
        nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)parameterVariables.get(0)), argumentValue);
        return nestedEvaluator.evaluate((DomainExpression)DomainUtil.nonNullPivot((Object)this.expressionInOCL.getBodyExpression()));
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        if (this.expressionInOCL == null) {
            this.resolveExpressionInOCL(evaluator, callExp, sourceValue);
        }
        return this.evaluate(evaluator, ((DomainType)DomainUtil.nonNullPivot((Object)callExp.getType())).getTypeId(), sourceValue, firstArgumentValue, secondArgumentValue);
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        DomainEvaluator nestedEvaluator = evaluator.createNestedEvaluator();
        DomainEvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluator.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)this.expressionInOCL.getContextVariable()), sourceValue);
        List<Variable> parameterVariables = this.expressionInOCL.getParameterVariable();
        nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)parameterVariables.get(0)), firstArgumentValue);
        nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)parameterVariables.get(1)), secondArgumentValue);
        return nestedEvaluator.evaluate((DomainExpression)DomainUtil.nonNullPivot((Object)this.expressionInOCL.getBodyExpression()));
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue, Object ... argumentValues) {
        if (this.expressionInOCL == null) {
            this.resolveExpressionInOCL(evaluator, callExp, sourceValue);
        }
        DomainEvaluator nestedEvaluator = evaluator.createNestedEvaluator();
        DomainEvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluator.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)this.expressionInOCL.getContextVariable()), sourceValue);
        List<Variable> parameterVariables = this.expressionInOCL.getParameterVariable();
        int iMax = Math.min(parameterVariables.size(), argumentValues.length);
        int i = 0;
        while (i < iMax) {
            nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)parameterVariables.get(i)), argumentValues[i]);
            ++i;
        }
        return nestedEvaluator.evaluate((DomainExpression)DomainUtil.nonNullPivot((Object)this.expressionInOCL.getBodyExpression()));
    }

    protected void resolveExpressionInOCL(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue) {
        if (this.specification instanceof ExpressionInOCL) {
            this.expressionInOCL = (ExpressionInOCL)this.specification;
        } else {
            String string = PivotUtil.getBody(this.specification);
            if (string != null) {
                try {
                    EvaluationVisitor evaluationVisitor = (EvaluationVisitor)evaluator;
                    MetaModelManager metaModelManager = evaluationVisitor.getMetaModelManager();
                    OperationContext operationContext = new OperationContext(metaModelManager, null, this.operation, null);
                    this.expressionInOCL = operationContext.parse(string);
                }
                catch (ParserException e) {
                    throw new InvalidValueException((Exception)e, "parse failure", new Object[]{evaluator.getEvaluationEnvironment(), sourceValue, callExp});
                }
            }
            if (this.expressionInOCL == null) {
                Operation operation = ((OperationCallExp)callExp).getReferredOperation();
                throw new InvalidValueException("No specification for '" + operation + "'", new Object[]{evaluator.getEvaluationEnvironment(), sourceValue, callExp});
            }
        }
    }
}

