/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.ecore.AbstractEcore2Pivot;
import org.eclipse.ocl.examples.pivot.ecore.EObjectOperation;
import org.eclipse.ocl.examples.pivot.ecore.EObjectProperty;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.AliasAdapter;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ecore2PivotDeclarationSwitch
extends EcoreSwitch<Object> {
    protected final AbstractEcore2Pivot converter;
    protected final MetaModelManager metaModelManager;

    public static boolean hasDocumentationKey(@Nullable String source, @NonNull EMap<String, String> details) {
        return "http://www.eclipse.org/emf/2002/GenModel".equals(source) && details.containsKey((Object)"documentation");
    }

    public static boolean hasImportKey(@Nullable String source, @NonNull EMap<String, String> details) {
        return "http://www.eclipse.org/OCL/Import".equals(source);
    }

    public static boolean isDocumentationKey(@Nullable String source, @Nullable String key) {
        return "http://www.eclipse.org/emf/2002/GenModel".equals(source) && "documentation".equals(key);
    }

    public Ecore2PivotDeclarationSwitch(AbstractEcore2Pivot converter) {
        this.converter = converter;
        this.metaModelManager = converter.getMetaModelManager();
    }

    public Object caseEAnnotation(EAnnotation eObject) {
        String source = eObject.getSource();
        EMap details = eObject.getDetails();
        Annotation pivotElement = PivotFactory.eINSTANCE.createAnnotation();
        pivotElement.setName(source);
        this.converter.addMapping((EObject)eObject, pivotElement);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eObject, null);
        this.doSwitchAll(pivotElement.getOwnedContent(), (List<? extends EObject>)eObject.getContents());
        for (Map.Entry entry : details) {
            String key = (String)entry.getKey();
            if (Ecore2PivotDeclarationSwitch.isDocumentationKey(source, key)) continue;
            Detail pivotDetail = PivotFactory.eINSTANCE.createDetail();
            pivotDetail.setName(key);
            pivotDetail.getValue().add((String)entry.getValue());
            pivotElement.getOwnedDetail().add(pivotDetail);
        }
        if (!eObject.getReferences().isEmpty()) {
            this.converter.queueReference((EObject)eObject);
        }
        return pivotElement;
    }

    public Object caseEAttribute(EAttribute eObject) {
        EAttribute eObject2 = eObject;
        Property pivotElement = this.converter.refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, (ENamedElement)eObject2);
        this.copyStructuralFeature(pivotElement, (EStructuralFeature)eObject2, null);
        pivotElement.setIsID(eObject2.isID());
        return pivotElement;
    }

    public Object caseEClass(EClass eObject) {
        Package parentPackage;
        String newName;
        boolean nameChange;
        EClass eObject2 = eObject;
        Class pivotElement = this.converter.refreshElement(Class.class, PivotPackage.Literals.CLASS, (EModelElement)eObject2);
        String oldName = pivotElement.getName();
        boolean bl = nameChange = oldName != (newName = eObject2.getName()) || oldName != null && !oldName.equals(newName);
        if (nameChange && (parentPackage = pivotElement.getPackage()) != null) {
            parentPackage.getOwnedType().remove(pivotElement);
        }
        pivotElement.setName(newName);
        this.copyClassifier(pivotElement, (EClassifier)eObject2);
        pivotElement.setIsAbstract(eObject2.isAbstract());
        pivotElement.setIsInterface(eObject2.isInterface());
        this.doSwitchAll((List<? extends EObject>)eObject2.getEGenericSuperTypes());
        List<Operation> pivotOperations = pivotElement.getOwnedOperation();
        List<Constraint> pivotInvariants = pivotElement.getOwnedInvariant();
        for (EOperation eOperation : eObject2.getEOperations()) {
            if (EcoreUtil.isInvariant((EOperation)eOperation)) {
                EAnnotation eAnnotation;
                Constraint constraint = PivotFactory.eINSTANCE.createConstraint();
                constraint.setName(eOperation.getName());
                constraint.setIsCallable(true);
                String value = null;
                String commentBody = EcoreUtil.getAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"documentation");
                if (commentBody != null) {
                    Comment pivotComment = PivotFactory.eINSTANCE.createComment();
                    pivotComment.setBody(commentBody.replaceAll("\\r", ""));
                    constraint.getOwnedComment().add(pivotComment);
                }
                if ((eAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation)) == null) {
                    eAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/2.2.0/GenModel");
                }
                if (eAnnotation == null) {
                    eAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
                }
                if (eAnnotation != null) {
                    value = (String)eAnnotation.getDetails().get((Object)"body");
                    this.copyAnnotationComment(constraint, eAnnotation, "body");
                }
                OpaqueExpression specification = PivotFactory.eINSTANCE.createOpaqueExpression();
                specification.getBody().add(value);
                specification.getLanguage().add("OCL");
                constraint.setSpecification(specification);
                pivotInvariants.add(constraint);
                this.converter.addMapping((EObject)eOperation, constraint);
                continue;
            }
            Object pivotObject = this.doSwitch((EObject)eOperation);
            pivotOperations.add((Operation)pivotObject);
        }
        this.doSwitchAll(pivotElement.getOwnedAttribute(), (List<? extends EObject>)eObject2.getEStructuralFeatures());
        this.converter.queueReference((EObject)eObject2);
        return pivotElement;
    }

    public Object caseEDataType(EDataType eObject) {
        Package parentPackage;
        String newName;
        boolean nameChange;
        EDataType eObject2 = eObject;
        DataType pivotElement = this.converter.refreshElement(DataType.class, PivotPackage.Literals.DATA_TYPE, (EModelElement)eObject2);
        String oldName = pivotElement.getName();
        boolean bl = nameChange = oldName != (newName = eObject2.getName()) || oldName != null && !oldName.equals(newName);
        if (nameChange && (parentPackage = pivotElement.getPackage()) != null) {
            parentPackage.getOwnedType().remove(pivotElement);
        }
        pivotElement.setName(newName);
        this.copyDataTypeOrEnum(pivotElement, eObject2);
        java.lang.Class instanceClass = eObject2.getInstanceClass();
        if (instanceClass != null) {
            try {
                MetaModelManager metaModelManager = this.converter.getMetaModelManager();
                if (instanceClass == Boolean.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getBooleanType());
                } else if (instanceClass == Byte.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Character.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Double.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getRealType());
                } else if (instanceClass == Float.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getRealType());
                } else if (instanceClass == Integer.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Long.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Short.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == BigDecimal.class) {
                    pivotElement.setBehavioralType(metaModelManager.getRealType());
                } else if (instanceClass == BigInteger.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Boolean.class) {
                    pivotElement.setBehavioralType(metaModelManager.getBooleanType());
                } else if (instanceClass == Byte.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Character.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Double.class) {
                    pivotElement.setBehavioralType(metaModelManager.getRealType());
                } else if (instanceClass == Float.class) {
                    pivotElement.setBehavioralType(metaModelManager.getRealType());
                } else if (instanceClass == Integer.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Long.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Short.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == String.class) {
                    pivotElement.setBehavioralType(metaModelManager.getStringType());
                } else {
                    instanceClass.getDeclaredMethod("compareTo", instanceClass);
                    this.converter.queueReference((EObject)eObject2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pivotElement.getSuperClass().add(this.metaModelManager.getOclAnyType());
        return pivotElement;
    }

    public Object caseEEnum(EEnum eObject) {
        Package parentPackage;
        String newName;
        boolean nameChange;
        EEnum eObject2 = eObject;
        Enumeration pivotElement = this.converter.refreshElement(Enumeration.class, PivotPackage.Literals.ENUMERATION, (EModelElement)eObject2);
        String oldName = pivotElement.getName();
        boolean bl = nameChange = oldName != (newName = eObject2.getName()) || oldName != null && !oldName.equals(newName);
        if (nameChange && (parentPackage = pivotElement.getPackage()) != null) {
            parentPackage.getOwnedType().remove(pivotElement);
        }
        pivotElement.setName(newName);
        this.copyDataTypeOrEnum(pivotElement, (EDataType)eObject2);
        this.doSwitchAll(pivotElement.getOwnedLiteral(), (List<? extends EObject>)eObject2.getELiterals());
        pivotElement.getSuperClass().add(this.metaModelManager.getEnumerationType());
        return pivotElement;
    }

    public Object caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
        EEnumLiteral eEnumLiteral2 = eEnumLiteral;
        EnumerationLiteral pivotElement = this.converter.refreshNamedElement(EnumerationLiteral.class, PivotPackage.Literals.ENUMERATION_LITERAL, (ENamedElement)eEnumLiteral2);
        this.copyNamedElement(pivotElement, (ENamedElement)eEnumLiteral2);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eEnumLiteral2, null);
        if (eEnumLiteral2.eIsSet((EStructuralFeature)EcorePackage.Literals.EENUM_LITERAL__VALUE)) {
            pivotElement.setValue(BigInteger.valueOf(eEnumLiteral2.getValue()));
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.ENUMERATION_LITERAL__VALUE);
        }
        return pivotElement;
    }

    public Object caseEGenericType(EGenericType eObject) {
        this.doSwitchAll((List<? extends EObject>)eObject.getETypeArguments());
        this.converter.addGenericType(eObject);
        return true;
    }

    public Object caseEOperation(EOperation eObject) {
        EOperation eObject2 = eObject;
        Operation pivotElement = this.converter.refreshNamedElement(Operation.class, PivotPackage.Literals.OPERATION, (ENamedElement)eObject2);
        ArrayList<EAnnotation> excludedAnnotations = null;
        EAnnotation oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eObject2);
        if (oclAnnotation == null) {
            oclAnnotation = eObject2.getEAnnotation("http://www.eclipse.org/uml2/2.2.0/GenModel");
        }
        if (oclAnnotation == null) {
            oclAnnotation = eObject2.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
        }
        if (oclAnnotation != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(oclAnnotation);
            ListIterator it = oclAnnotation.getDetails().listIterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String bodyName = null;
                String preName = null;
                String postName = null;
                String key = (String)entry.getKey();
                if (key.equals("body")) {
                    bodyName = "";
                } else if (key.startsWith("body_")) {
                    bodyName = key.substring(5);
                } else if (key.equals("pre")) {
                    preName = "";
                } else if (key.startsWith("pre_")) {
                    preName = key.substring(4);
                } else if (key.equals("post")) {
                    postName = "";
                } else if (key.startsWith("post_")) {
                    postName = key.substring(5);
                } else {
                    this.converter.error("Unsupported operation constraint " + key);
                    continue;
                }
                String value = (String)entry.getValue();
                OpaqueExpression specification = PivotFactory.eINSTANCE.createOpaqueExpression();
                specification.getBody().add(value);
                specification.getLanguage().add("OCL");
                if (bodyName != null) {
                    pivotElement.setBodyExpression(specification);
                    pivotElement.setImplementation((LibraryFeature)new EObjectOperation(pivotElement, eObject2, specification));
                    continue;
                }
                Constraint constraint = PivotFactory.eINSTANCE.createConstraint();
                constraint.setSpecification(specification);
                if (preName != null) {
                    pivotElement.getPrecondition().add(constraint);
                    constraint.setName(preName);
                } else {
                    pivotElement.getPostcondition().add(constraint);
                    constraint.setName(postName);
                }
                this.copyAnnotationComment(constraint, oclAnnotation, key);
            }
        }
        this.copyTypedMultiplicityElement(pivotElement, (ETypedElement)eObject2, excludedAnnotations);
        this.doSwitchAll(pivotElement.getOwnedParameter(), (List<? extends EObject>)eObject2.getEParameters());
        EList eTypeParameters = eObject2.getETypeParameters();
        this.copyTemplateSignature(pivotElement, (List<ETypeParameter>)eTypeParameters);
        this.doSwitchAll((List<? extends EObject>)eObject2.getEGenericExceptions());
        this.converter.queueReference((EObject)eObject2);
        return pivotElement;
    }

    public Object caseEPackage(EPackage eObject) {
        EAnnotation eAnnotation;
        boolean nsURIChange;
        EPackage eObject2 = eObject;
        Package pivotElement = this.converter.refreshElement(Package.class, PivotPackage.Literals.PACKAGE, (EModelElement)eObject2);
        String oldName = pivotElement.getName();
        String newName = eObject2.getName();
        String oldNsURI = pivotElement.getNsURI();
        String newNsURI = eObject2.getNsURI();
        boolean nameChange = oldName != newName || oldName != null && !oldName.equals(newName);
        boolean bl = nsURIChange = oldNsURI != newNsURI || oldNsURI != null && !oldNsURI.equals(newNsURI);
        if (nameChange || nsURIChange) {
            EObject eContainer = pivotElement.eContainer();
            if (eContainer instanceof Root) {
                ((Root)eContainer).getNestedPackage().remove(pivotElement);
            } else if (eContainer instanceof Package) {
                ((Package)eContainer).getNestedPackage().remove(pivotElement);
            }
        }
        pivotElement.setName(newName);
        if (eObject2.eIsSet((EStructuralFeature)EcorePackage.Literals.EPACKAGE__NS_URI)) {
            pivotElement.setNsURI(eObject2.getNsURI());
        } else {
            pivotElement.setNsURI(null);
        }
        if (eObject2.eIsSet((EStructuralFeature)EcorePackage.Literals.EPACKAGE__NS_PREFIX)) {
            pivotElement.setNsPrefix(eObject2.getNsPrefix());
        } else {
            pivotElement.setNsPrefix(null);
        }
        if (!(eObject2.eContainer() instanceof EAnnotation)) {
            String moniker = Pivot2Moniker.toString(pivotElement);
            AliasAdapter adapter = AliasAdapter.getAdapter(eObject2.eResource());
            if (adapter != null) {
                adapter.getAliasMap().put((EObject)eObject2, moniker);
            }
        }
        List<EAnnotation> exclusions = (eAnnotation = eObject2.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore")) == null ? Collections.emptyList() : Collections.singletonList(eAnnotation);
        this.copyNamedElement(pivotElement, (ENamedElement)eObject2);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eObject2, exclusions);
        this.doSwitchAll(pivotElement.getNestedPackage(), (List<? extends EObject>)eObject2.getESubpackages());
        this.doSwitchAll(pivotElement.getOwnedType(), (List<? extends EObject>)eObject2.getEClassifiers());
        return pivotElement;
    }

    public Object caseEParameter(EParameter eObject) {
        EParameter eObject2 = eObject;
        Parameter pivotElement = this.converter.refreshNamedElement(Parameter.class, PivotPackage.Literals.PARAMETER, (ENamedElement)eObject2);
        this.copyTypedMultiplicityElement(pivotElement, (ETypedElement)eObject2, null);
        return pivotElement;
    }

    public Object caseEReference(EReference eObject) {
        EReference eObject2 = eObject;
        Property pivotElement = this.converter.refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, (ENamedElement)eObject2);
        ArrayList<Object> excludedAnnotations = null;
        EAnnotation oppositeRole = eObject2.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
        if (oppositeRole != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(oppositeRole);
        }
        if ((oppositeRole = eObject2.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName")) != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList();
            }
            excludedAnnotations.add(oppositeRole);
        }
        this.copyStructuralFeature(pivotElement, (EStructuralFeature)eObject2, excludedAnnotations);
        pivotElement.setIsComposite(eObject2.isContainment());
        pivotElement.setIsResolveProxies(eObject2.isResolveProxies());
        if (eObject2.getEOpposite() != null || excludedAnnotations != null || !eObject2.getEKeys().isEmpty()) {
            this.converter.queueReference((EObject)eObject2);
        }
        return pivotElement;
    }

    public Object caseETypeParameter(ETypeParameter eObject) {
        EList eBounds;
        ETypeParameter eObject2 = eObject;
        Class pivotElement = this.converter.refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, (ENamedElement)eObject2);
        this.converter.addMapping((EObject)eObject2, pivotElement);
        String name = eObject2.getName();
        pivotElement.setName(name);
        TypeTemplateParameter typeTemplateParameter = (TypeTemplateParameter)pivotElement.getTemplateParameter();
        if (typeTemplateParameter == null) {
            typeTemplateParameter = PivotFactory.eINSTANCE.createTypeTemplateParameter();
            typeTemplateParameter.setOwnedParameteredElement(pivotElement);
        }
        if (!(eBounds = eObject2.getEBounds()).isEmpty()) {
            this.doSwitchAll((List<? extends EObject>)eBounds);
            this.converter.queueReference((EObject)eObject2);
        }
        return typeTemplateParameter;
    }

    protected void copyClassifier(@NonNull Class pivotElement, @NonNull EClassifier eClassifier) {
        List<EAnnotation> excludedAnnotations = this.refreshTypeConstraints(pivotElement, eClassifier);
        this.copyNamedElement(pivotElement, (ENamedElement)eClassifier);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eClassifier, excludedAnnotations);
        if (eClassifier.eIsSet((EStructuralFeature)EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME)) {
            pivotElement.setInstanceClassName(eClassifier.getInstanceClassName());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.TYPE__INSTANCE_CLASS_NAME);
        }
        EList eTypeParameters = eClassifier.getETypeParameters();
        this.copyTemplateSignature(pivotElement, (List<ETypeParameter>)eTypeParameters);
    }

    protected void copyDataTypeOrEnum(@NonNull DataType pivotElement, @NonNull EDataType eDataType) {
        this.copyClassifier(pivotElement, (EClassifier)eDataType);
        pivotElement.setIsSerializable(eDataType.isSerializable());
    }

    protected void copyTemplateSignature(@NonNull TemplateableElement pivotElement, @NonNull List<ETypeParameter> eTypeParameters) {
        if (!eTypeParameters.isEmpty()) {
            TemplateSignature pivotTemplateSignature = PivotFactory.eINSTANCE.createTemplateSignature();
            pivotElement.setOwnedTemplateSignature(pivotTemplateSignature);
            this.doSwitchAll(pivotTemplateSignature.getOwnedParameter(), eTypeParameters);
        }
    }

    protected void copyAnnotatedElement(@NonNull NamedElement pivotElement, @NonNull EModelElement eModelElement, List<EAnnotation> excludedAnnotations) {
        List<Annotation> pivotAnnotations = pivotElement.getOwnedAnnotation();
        for (EAnnotation eAnnotation : eModelElement.getEAnnotations()) {
            EMap details;
            if (excludedAnnotations != null && excludedAnnotations.contains(eAnnotation)) continue;
            String source = eAnnotation.getSource();
            if (Ecore2PivotDeclarationSwitch.hasDocumentationKey(source, (EMap<String, String>)(details = eAnnotation.getDetails()))) {
                Comment pivotComment = PivotFactory.eINSTANCE.createComment();
                pivotComment.setBody((String)details.get((Object)"documentation"));
                pivotElement.getOwnedComment().add(pivotComment);
                continue;
            }
            if (Ecore2PivotDeclarationSwitch.hasImportKey(source, (EMap<String, String>)details) || eAnnotation.getContents().isEmpty() && eAnnotation.getReferences().isEmpty() && details.size() <= 1 && (details.size() != 1 || Ecore2PivotDeclarationSwitch.hasDocumentationKey(source, (EMap<String, String>)details))) continue;
            Annotation pivotAnnotation = (Annotation)this.doSwitch((EObject)eAnnotation);
            pivotAnnotations.add(pivotAnnotation);
        }
    }

    protected void copyAnnotationComment(@NonNull Constraint pivotElement, @NonNull EAnnotation eModelElement, @NonNull String key) {
        pivotElement.getOwnedComment().clear();
        String comment = EcoreUtil.getAnnotation((EModelElement)eModelElement, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)key);
        if (comment != null) {
            Comment pivotComment = PivotFactory.eINSTANCE.createComment();
            pivotComment.setBody(comment);
            pivotElement.getOwnedComment().add(pivotComment);
        }
    }

    protected void copyNamedElement(@NonNull NamedElement pivotElement, @NonNull ENamedElement eNamedElement) {
        this.converter.addMapping((EObject)eNamedElement, pivotElement);
        String name = eNamedElement.getName();
        pivotElement.setName(name);
    }

    protected void copyStructuralFeature(@NonNull Property pivotElement, @NonNull EStructuralFeature eObject, List<EAnnotation> excludedAnnotations) {
        EAnnotation oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eObject);
        if (oclAnnotation != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(oclAnnotation);
            Map.Entry bestEntry = null;
            for (Map.Entry entry : oclAnnotation.getDetails().entrySet()) {
                String key = (String)entry.getKey();
                if (key.equals("derivation")) {
                    bestEntry = entry;
                    continue;
                }
                if (key.equals("initial")) {
                    if (bestEntry != null) continue;
                    bestEntry = entry;
                    continue;
                }
                if (key.equals("get")) {
                    if (bestEntry != null) continue;
                    bestEntry = entry;
                    continue;
                }
                this.converter.error("Unsupported feature constraint " + key);
            }
            if (bestEntry != null) {
                String value = (String)bestEntry.getValue();
                OpaqueExpression specification = PivotFactory.eINSTANCE.createOpaqueExpression();
                specification.getBody().add(value);
                specification.getLanguage().add("OCL");
                pivotElement.setDefaultExpression(specification);
                pivotElement.setImplementation((LibraryFeature)new EObjectProperty(eObject, specification));
            } else {
                pivotElement.setImplementation((LibraryFeature)new EObjectProperty(eObject, null));
            }
        }
        this.copyTypedMultiplicityElement(pivotElement, (ETypedElement)eObject, excludedAnnotations);
        pivotElement.setIsReadOnly(!eObject.isChangeable());
        pivotElement.setIsDerived(eObject.isDerived());
        pivotElement.setIsTransient(eObject.isTransient());
        pivotElement.setIsUnsettable(eObject.isUnsettable());
        pivotElement.setIsVolatile(eObject.isVolatile());
        if (eObject.eIsSet((EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL)) {
            pivotElement.setDefault(eObject.getDefaultValueLiteral());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.PROPERTY__DEFAULT);
        }
    }

    protected void copyTypedMultiplicityElement(@NonNull TypedMultiplicityElement pivotElement, @NonNull ETypedElement eTypedElement, List<EAnnotation> excludedAnnotations) {
        this.copyNamedElement(pivotElement, (ENamedElement)eTypedElement);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eTypedElement, excludedAnnotations);
        int lower = eTypedElement.getLowerBound();
        int upper = eTypedElement.getUpperBound();
        pivotElement.setIsRequired(upper == 1 && lower == 1);
        EGenericType eGenericType = eTypedElement.getEGenericType();
        if (eGenericType != null) {
            this.doInPackageSwitch((EObject)eGenericType);
            this.converter.queueReference((EObject)eTypedElement);
        }
    }

    public Element defaultCase(EObject object) {
        this.converter.error("Unsupported " + object.eClass().getName() + " for Ecore2PivotDeclarationSwitch");
        return null;
    }

    public Object doInPackageSwitch(EObject eObject) {
        EClass eClass = eObject.eClass();
        if (eClass.getEPackage() != EcorePackage.eINSTANCE) {
            this.converter.error("Non Ecore " + eClass.getName() + " for Ecore2PivotDeclarationSwitch");
            return null;
        }
        int classifierID = eClass.getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(List<T> pivotObjects, List<? extends EObject> eObjects) {
        ArrayList<Element> newList = new ArrayList<Element>();
        for (EObject eObject : eObjects) {
            Element pivotObject = (Element)this.doSwitch(eObject);
            newList.add(pivotObject);
        }
        PivotUtil.refreshList(pivotObjects, newList);
    }

    public <T extends Element> void doSwitchAll(List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            this.doSwitch(eObject);
        }
    }

    protected List<EAnnotation> refreshTypeConstraints(@NonNull Class pivotElement, @NonNull EClassifier eClassifier) {
        EAnnotation ecoreAnnotation;
        EAnnotation oclAnnotation;
        ArrayList<EAnnotation> excludedAnnotations = null;
        EMap oclAnnotationDetails = null;
        HashMap<String, Constraint> newConstraintMap = null;
        HashMap<String, Constraint> oldInvariantMap = null;
        ArrayList<Constraint> newInvariants = null;
        List<Constraint> oldInvariants = pivotElement.getOwnedInvariant();
        if (oldInvariants.size() > 0) {
            oldInvariantMap = new HashMap<String, Constraint>();
            for (Constraint oldInvariant : oldInvariants) {
                oldInvariantMap.put(oldInvariant.getName(), oldInvariant);
            }
        }
        if ((oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier)) != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(oclAnnotation);
            oclAnnotationDetails = oclAnnotation.getDetails();
            ListIterator it = oclAnnotationDetails.listIterator();
            while (it.hasNext()) {
                OpaqueExpression expression;
                Map.Entry entry = (Map.Entry)it.next();
                String invariantName = (String)entry.getKey();
                if (invariantName == null) {
                    invariantName = "";
                }
                if (invariantName.endsWith("$message")) continue;
                Constraint invariant = null;
                OpaqueExpression specification = null;
                if (oldInvariantMap != null) {
                    invariant = (Constraint)oldInvariantMap.get(invariantName);
                }
                if (invariant == null) {
                    invariant = PivotFactory.eINSTANCE.createConstraint();
                    invariant.setName(invariantName);
                } else {
                    specification = invariant.getSpecification();
                }
                if (specification != null) {
                    expression = specification;
                } else {
                    expression = PivotFactory.eINSTANCE.createOpaqueExpression();
                    invariant.setSpecification(expression);
                }
                String value = (String)entry.getValue();
                expression.getBody().add(value);
                expression.getLanguage().add("OCL");
                String message = (String)oclAnnotationDetails.get((Object)(String.valueOf(invariantName) + "$message"));
                expression.getMessage().add(message != null ? message : "");
                if (newInvariants == null) {
                    newInvariants = new ArrayList();
                }
                newInvariants.add(invariant);
                if (newConstraintMap == null) {
                    newConstraintMap = new HashMap();
                }
                newConstraintMap.put(invariantName, invariant);
                this.copyAnnotationComment(invariant, oclAnnotation, "documentation");
            }
        }
        if ((ecoreAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore")) != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList();
            }
            excludedAnnotations.add(ecoreAnnotation);
            String invariantNameList = (String)ecoreAnnotation.getDetails().get((Object)"constraints");
            if (invariantNameList != null) {
                String[] invariantNames;
                String[] stringArray = invariantNames = invariantNameList.split(" ");
                int n = invariantNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String invariantName = stringArray[n2];
                    if (oclAnnotationDetails == null || !oclAnnotationDetails.containsKey((Object)invariantName)) {
                        Constraint invariant = null;
                        if (newConstraintMap != null) {
                            invariant = (Constraint)newConstraintMap.get(invariantName);
                        }
                        if (invariant == null) {
                            invariant = PivotFactory.eINSTANCE.createConstraint();
                            invariant.setName(invariantName);
                        }
                        OpaqueExpression specification = PivotFactory.eINSTANCE.createOpaqueExpression();
                        invariant.setSpecification(specification);
                        if (newInvariants == null) {
                            newInvariants = new ArrayList<Constraint>();
                        }
                        newInvariants.add(invariant);
                        if (newConstraintMap == null) {
                            newConstraintMap = new HashMap<String, Constraint>();
                        }
                        newConstraintMap.put(invariantName, invariant);
                    }
                    ++n2;
                }
            }
        }
        if (newInvariants != null) {
            this.converter.refreshList(oldInvariants, newInvariants);
        } else {
            oldInvariants.clear();
        }
        return excludedAnnotations;
    }
}

