/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorManager;
import org.eclipse.ocl.examples.library.logical.BooleanImpliesOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyEqualOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyNotEqualOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyOclIsKindOfOperation;
import org.eclipse.ocl.examples.pivot.CollectionKind;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.internal.impl.LiteralExpImpl;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionLiteralExpImpl
extends LiteralExpImpl
implements CollectionLiteralExp {
    protected static final CollectionKind KIND_EDEFAULT = CollectionKind.COLLECTION;
    protected static final int KIND_EFLAG_OFFSET = 10;
    protected static final int KIND_EFLAG_DEFAULT = KIND_EDEFAULT.ordinal() << 10;
    private static final CollectionKind[] KIND_EFLAG_VALUES = CollectionKind.values();
    protected static final int KIND_EFLAG = 7168;
    protected EList<CollectionLiteralPart> part;

    protected CollectionLiteralExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.COLLECTION_LITERAL_EXP;
    }

    @Override
    public CollectionKind getKind() {
        return KIND_EFLAG_VALUES[(this.eFlags & 0x1C00) >>> 10];
    }

    @Override
    public void setKind(CollectionKind newKind) {
        CollectionKind oldKind = KIND_EFLAG_VALUES[(this.eFlags & 0x1C00) >>> 10];
        if (newKind == null) {
            newKind = KIND_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFE3FF | newKind.ordinal() << 10;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldKind, (Object)newKind));
        }
    }

    @Override
    public List<CollectionLiteralPart> getPart() {
        if (this.part == null) {
            this.part = new EObjectContainmentEList(CollectionLiteralPart.class, (InternalEObject)this, 8);
        }
        return this.part;
    }

    @Override
    public CollectionLiteralPart createPart(EClass eClass) {
        CollectionLiteralPart newPart = (CollectionLiteralPart)this.create(eClass);
        this.getPart().add(newPart);
        return newPart;
    }

    @Override
    public boolean validateCollectionKindIsConcrete(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_ne;
        CollectionLiteralExpImpl self = this;
        try {
            CollectionKind kind = self.getKind();
            EnumerationLiteralId BOXED_kind = PivotTables.ENUMid_CollectionKind.getEnumerationLiteralId(kind.getName());
            Boolean ne = OclAnyNotEqualOperation.INSTANCE.evaluate((Object)BOXED_kind, (Object)PivotTables.ELITid_Collection);
            CAUGHT_ne = ne;
        }
        catch (Exception e) {
            CAUGHT_ne = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_ne == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"CollectionLiteralExp", "CollectionKindIsConcrete", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 3, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateSetKindIsSet(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        CollectionLiteralExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_SetType = idResolver.getType((TypeId)PivotTables.CLSSid_SetType, null);
        try {
            Object CAUGHT_oclIsKindOf;
            Object CAUGHT_eq;
            try {
                CollectionKind kind = self.getKind();
                EnumerationLiteralId BOXED_kind = PivotTables.ENUMid_CollectionKind.getEnumerationLiteralId(kind.getName());
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)BOXED_kind, (Object)PivotTables.ELITid_Set);
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                Boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_SetType);
                CAUGHT_oclIsKindOf = oclIsKindOf;
            }
            catch (Exception e) {
                CAUGHT_oclIsKindOf = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_oclIsKindOf);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"CollectionLiteralExp", "SetKindIsSet", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 4, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateOrderedSetKindIsOrderedSet(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        CollectionLiteralExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_OrderedSetType = idResolver.getType((TypeId)PivotTables.CLSSid_OrderedSetType, null);
        try {
            Object CAUGHT_oclIsKindOf;
            Object CAUGHT_eq;
            try {
                CollectionKind kind = self.getKind();
                EnumerationLiteralId BOXED_kind = PivotTables.ENUMid_CollectionKind.getEnumerationLiteralId(kind.getName());
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)BOXED_kind, (Object)PivotTables.ELITid_OrderedSet);
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                Boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_OrderedSetType);
                CAUGHT_oclIsKindOf = oclIsKindOf;
            }
            catch (Exception e) {
                CAUGHT_oclIsKindOf = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_oclIsKindOf);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"CollectionLiteralExp", "OrderedSetKindIsOrderedSet", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 5, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateSequenceKindIsSequence(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        CollectionLiteralExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_SequenceType = idResolver.getType((TypeId)PivotTables.CLSSid_SequenceType, null);
        try {
            Object CAUGHT_oclIsKindOf;
            Object CAUGHT_eq;
            try {
                CollectionKind kind = self.getKind();
                EnumerationLiteralId BOXED_kind = PivotTables.ENUMid_CollectionKind.getEnumerationLiteralId(kind.getName());
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)BOXED_kind, (Object)PivotTables.ELITid_Sequence);
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                Boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_SequenceType);
                CAUGHT_oclIsKindOf = oclIsKindOf;
            }
            catch (Exception e) {
                CAUGHT_oclIsKindOf = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_oclIsKindOf);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"CollectionLiteralExp", "SequenceKindIsSequence", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 6, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateBagKindIsBag(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        CollectionLiteralExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_BagType = idResolver.getType((TypeId)PivotTables.CLSSid_BagType, null);
        try {
            Object CAUGHT_oclIsKindOf;
            Object CAUGHT_eq;
            try {
                CollectionKind kind = self.getKind();
                EnumerationLiteralId BOXED_kind = PivotTables.ENUMid_CollectionKind.getEnumerationLiteralId(kind.getName());
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)BOXED_kind, (Object)PivotTables.ELITid_Bag);
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                Boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_BagType);
                CAUGHT_oclIsKindOf = oclIsKindOf;
            }
            catch (Exception e) {
                CAUGHT_oclIsKindOf = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_oclIsKindOf);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"CollectionLiteralExp", "BagKindIsBag", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 7, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getOwnedComment()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getExtension()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getOwnedAnnotation()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getPart()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getOwnedComment();
            }
            case 1: {
                return this.getExtension();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.isStatic();
            }
            case 4: {
                return this.getOwnedAnnotation();
            }
            case 5: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 6: {
                return this.isRequired();
            }
            case 7: {
                return this.getKind();
            }
            case 8: {
                return this.getPart();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getOwnedComment().clear();
                this.getOwnedComment().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getExtension().clear();
                this.getExtension().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setIsStatic((Boolean)newValue);
                return;
            }
            case 4: {
                this.getOwnedAnnotation().clear();
                this.getOwnedAnnotation().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setType((Type)newValue);
                return;
            }
            case 6: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 7: {
                this.setKind((CollectionKind)((Object)newValue));
                return;
            }
            case 8: {
                this.getPart().clear();
                this.getPart().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getOwnedComment().clear();
                return;
            }
            case 1: {
                this.getExtension().clear();
                return;
            }
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setIsStatic(false);
                return;
            }
            case 4: {
                this.getOwnedAnnotation().clear();
                return;
            }
            case 5: {
                this.setType(null);
                return;
            }
            case 6: {
                this.setIsRequired(true);
                return;
            }
            case 7: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 8: {
                this.getPart().clear();
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.ownedComment != null && !this.ownedComment.isEmpty();
            }
            case 1: {
                return this.extension != null && !this.extension.isEmpty();
            }
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return (this.eFlags & 0x100) != 0;
            }
            case 4: {
                return this.ownedAnnotation != null && !this.ownedAnnotation.isEmpty();
            }
            case 5: {
                return this.type != null;
            }
            case 6: {
                return (this.eFlags & 0x200) == 0;
            }
            case 7: {
                return (this.eFlags & 0x1C00) != KIND_EFLAG_DEFAULT;
            }
            case 8: {
                return this.part != null && !this.part.isEmpty();
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.validateCollectionKindIsConcrete((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 3: {
                return this.validateSetKindIsSet((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 4: {
                return this.validateOrderedSetKindIsOrderedSet((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 5: {
                return this.validateSequenceKindIsSequence((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 6: {
                return this.validateBagKindIsBag((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitCollectionLiteralExp(this);
    }
}

