/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainMetaclass;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorManager;
import org.eclipse.ocl.examples.library.logical.BooleanImpliesOperation;
import org.eclipse.ocl.examples.library.logical.BooleanNotOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyEqualOperation;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.ReferringElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.internal.impl.NavigationCallExpImpl;
import org.eclipse.ocl.examples.pivot.manager.TemplateSpecialisation;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCallExpImpl
extends NavigationCallExpImpl
implements PropertyCallExp {
    protected Property referredProperty;

    protected PropertyCallExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.PROPERTY_CALL_EXP;
    }

    @Override
    public Property getReferredProperty() {
        if (this.referredProperty != null && this.referredProperty.eIsProxy()) {
            InternalEObject oldReferredProperty = (InternalEObject)this.referredProperty;
            this.referredProperty = (Property)this.eResolveProxy(oldReferredProperty);
            if (this.referredProperty != oldReferredProperty && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 12, (Object)oldReferredProperty, (Object)this.referredProperty));
            }
        }
        return this.referredProperty;
    }

    public Property basicGetReferredProperty() {
        return this.referredProperty;
    }

    @Override
    public void setReferredProperty(Property newReferredProperty) {
        Property oldReferredProperty = this.referredProperty;
        this.referredProperty = newReferredProperty;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldReferredProperty, (Object)this.referredProperty));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getOwnedComment();
            }
            case 1: {
                return this.getExtension();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.isStatic();
            }
            case 4: {
                return this.getOwnedAnnotation();
            }
            case 5: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 6: {
                return this.isRequired();
            }
            case 7: {
                return this.getSource();
            }
            case 8: {
                return this.isImplicit();
            }
            case 9: {
                return this.isPre();
            }
            case 10: {
                return this.getQualifier();
            }
            case 11: {
                if (resolve) {
                    return this.getNavigationSource();
                }
                return this.basicGetNavigationSource();
            }
            case 12: {
                if (resolve) {
                    return this.getReferredProperty();
                }
                return this.basicGetReferredProperty();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getOwnedComment().clear();
                this.getOwnedComment().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getExtension().clear();
                this.getExtension().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setIsStatic((Boolean)newValue);
                return;
            }
            case 4: {
                this.getOwnedAnnotation().clear();
                this.getOwnedAnnotation().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setType((Type)newValue);
                return;
            }
            case 6: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 7: {
                this.setSource((OCLExpression)newValue);
                return;
            }
            case 8: {
                this.setImplicit((Boolean)newValue);
                return;
            }
            case 9: {
                this.setIsPre((Boolean)newValue);
                return;
            }
            case 10: {
                this.getQualifier().clear();
                this.getQualifier().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setNavigationSource((Property)newValue);
                return;
            }
            case 12: {
                this.setReferredProperty((Property)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getOwnedComment().clear();
                return;
            }
            case 1: {
                this.getExtension().clear();
                return;
            }
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setIsStatic(false);
                return;
            }
            case 4: {
                this.getOwnedAnnotation().clear();
                return;
            }
            case 5: {
                this.setType(null);
                return;
            }
            case 6: {
                this.setIsRequired(true);
                return;
            }
            case 7: {
                this.setSource(null);
                return;
            }
            case 8: {
                this.setImplicit(false);
                return;
            }
            case 9: {
                this.setIsPre(false);
                return;
            }
            case 10: {
                this.getQualifier().clear();
                return;
            }
            case 11: {
                this.setNavigationSource(null);
                return;
            }
            case 12: {
                this.setReferredProperty(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.ownedComment != null && !this.ownedComment.isEmpty();
            }
            case 1: {
                return this.extension != null && !this.extension.isEmpty();
            }
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return (this.eFlags & 0x100) != 0;
            }
            case 4: {
                return this.ownedAnnotation != null && !this.ownedAnnotation.isEmpty();
            }
            case 5: {
                return this.type != null;
            }
            case 6: {
                return (this.eFlags & 0x200) == 0;
            }
            case 7: {
                return this.source != null;
            }
            case 8: {
                return (this.eFlags & 0x400) != 0;
            }
            case 9: {
                return (this.eFlags & 0x800) != 0;
            }
            case 10: {
                return this.qualifier != null && !this.qualifier.isEmpty();
            }
            case 11: {
                return this.navigationSource != null;
            }
            case 12: {
                return this.referredProperty != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.getReferredElement();
            }
            case 3: {
                return this.getSpecializedReferredPropertyOwningType();
            }
            case 4: {
                return this.getSpecializedReferredPropertyType();
            }
            case 5: {
                return this.validateNonStaticSourceTypeIsConformant((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 6: {
                return this.validateCompatibleResultType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitPropertyCallExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredProperty();
    }

    @Override
    public DomainType getSpecializedReferredPropertyOwningType() {
        Property referredProperty = this.getReferredProperty();
        Type referencedType = referredProperty.getOwningType();
        if (!TemplateSpecialisation.needsSpecialisation(referencedType)) {
            return referencedType;
        }
        TemplateSpecialisation templateSpecialization = new TemplateSpecialisation((DomainStandardLibrary)PivotTables.LIBRARY);
        Type resultType = this.getType();
        if (resultType instanceof DomainMetaclass) {
            resultType = ((DomainMetaclass)resultType).getInstanceType();
        }
        templateSpecialization.installEquivalence(resultType, referredProperty.getType());
        return templateSpecialization.getSpecialisation(referencedType);
    }

    @Override
    public DomainType getSpecializedReferredPropertyType() {
        Property referredProperty = this.getReferredProperty();
        Type referencedType = referredProperty.getType();
        if (!TemplateSpecialisation.needsSpecialisation(referencedType)) {
            return referencedType;
        }
        TemplateSpecialisation templateSpecialization = new TemplateSpecialisation((DomainStandardLibrary)PivotTables.LIBRARY);
        Type resultType = this.getType();
        boolean isMetaclass = resultType instanceof DomainMetaclass;
        if (isMetaclass) {
            resultType = ((DomainMetaclass)resultType).getInstanceType();
        }
        templateSpecialization.installEquivalence(resultType, referredProperty.getType());
        DomainType specializedType = templateSpecialization.getSpecialisation(referencedType);
        if (isMetaclass) {
            specializedType = PivotTables.LIBRARY.getMetaclass(specializedType);
        }
        return specializedType;
    }

    @Override
    public boolean validateNonStaticSourceTypeIsConformant(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        PropertyCallExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        try {
            Object CAUGHT_conformsTo;
            Object CAUGHT_not;
            try {
                Property referredProperty = self.getReferredProperty();
                if (referredProperty == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                Boolean isStatic = referredProperty.isStatic();
                Boolean not = BooleanNotOperation.INSTANCE.evaluate((Object)isStatic);
                CAUGHT_not = not;
            }
            catch (Exception e) {
                CAUGHT_not = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                OCLExpression source = self.getSource();
                if (source == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                DomainType type = source.getType();
                DomainType getSpecializedReferredPropertyOwningType = self.getSpecializedReferredPropertyOwningType();
                Boolean conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)getSpecializedReferredPropertyOwningType);
                CAUGHT_conformsTo = conformsTo;
            }
            catch (Exception e) {
                CAUGHT_conformsTo = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_not, CAUGHT_conformsTo);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"PropertyCallExp", "NonStaticSourceTypeIsConformant", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 58, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateCompatibleResultType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_eq;
        PropertyCallExpImpl self = this;
        try {
            Type type = self.getType();
            DomainType getSpecializedReferredPropertyType = self.getSpecializedReferredPropertyType();
            Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)getSpecializedReferredPropertyType);
            CAUGHT_eq = eq;
        }
        catch (Exception e) {
            CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_eq == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"PropertyCallExp", "CompatibleResultType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 59, message, new Object[]{this}));
        }
        return false;
    }
}

