/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractPolyOperation;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class EInvokeOperation
extends AbstractPolyOperation {
    @NonNull
    protected final EOperation eOperation;

    public EInvokeOperation(@NonNull EOperation eOperation) {
        this.eOperation = eOperation;
        EClassifier eType = eOperation.getEType();
        if (eType == null) {
            throw new IllegalArgumentException("Non-query EOperation");
        }
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue, Object ... argumentValues) {
        EObject eObject = EInvokeOperation.asNavigableObject((Object)sourceValue);
        Object[] data = new Object[argumentValues.length];
        int i = 0;
        Object[] objectArray = argumentValues;
        int n = argumentValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object argumentValue = objectArray[n2];
            assert (argumentValue != null);
            data[i++] = EInvokeOperation.asObject((Object)argumentValue);
            ++n2;
        }
        EcoreEList.UnmodifiableEList arguments = new EcoreEList.UnmodifiableEList(null, null, data.length, data);
        try {
            Object eResult = eObject.eInvoke(this.eOperation, (EList)arguments);
            DomainType returnType = callExp.getType();
            assert (returnType != null);
            return this.getResultValue(evaluator, returnType.getTypeId(), eResult);
        }
        catch (InvocationTargetException e) {
            return EInvokeOperation.createInvalidValue((Exception)e);
        }
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        EObject eObject = EInvokeOperation.asNavigableObject((Object)sourceValue);
        EcoreEList.UnmodifiableEList arguments = new EcoreEList.UnmodifiableEList(null, null, 0, new Object[0]);
        try {
            Object eResult = eObject.eInvoke(this.eOperation, (EList)arguments);
            return this.getResultValue(evaluator, returnTypeId, eResult);
        }
        catch (InvocationTargetException e) {
            return EInvokeOperation.createInvalidValue((Exception)e);
        }
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object argumentValue) {
        EObject eObject = EInvokeOperation.asNavigableObject((Object)sourceValue);
        EcoreEList.UnmodifiableEList arguments = new EcoreEList.UnmodifiableEList(null, null, 1, new Object[]{EInvokeOperation.asObject((Object)argumentValue)});
        try {
            Object eResult = eObject.eInvoke(this.eOperation, (EList)arguments);
            return this.getResultValue(evaluator, returnTypeId, eResult);
        }
        catch (InvocationTargetException e) {
            return EInvokeOperation.createInvalidValue((Exception)e);
        }
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        EObject eObject = EInvokeOperation.asNavigableObject((Object)sourceValue);
        EcoreEList.UnmodifiableEList arguments = new EcoreEList.UnmodifiableEList(null, null, 2, new Object[]{EInvokeOperation.asObject((Object)firstArgumentValue), EInvokeOperation.asObject((Object)secondArgumentValue)});
        try {
            Object eResult = eObject.eInvoke(this.eOperation, (EList)arguments);
            return this.getResultValue(evaluator, returnTypeId, eResult);
        }
        catch (InvocationTargetException e) {
            return EInvokeOperation.createInvalidValue((Exception)e);
        }
    }

    @Nullable
    protected Object getResultValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object eResult) {
        if (returnTypeId instanceof CollectionTypeId) {
            if (eResult instanceof Iterable) {
                return evaluator.getIdResolver().createCollectionOfAll((CollectionTypeId)returnTypeId, (Iterable)eResult);
            }
            throw new InvalidValueException("Non-iterable result", new Object[0]);
        }
        if (eResult != null) {
            EClassifier eType = this.eOperation.getEType();
            return evaluator.getIdResolver().boxedValueOf(eResult, eType);
        }
        return null;
    }
}

