/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractProperty;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;

public class ImplicitNonCompositionProperty
extends AbstractProperty {
    @NonNull
    protected DomainProperty property;

    public ImplicitNonCompositionProperty(@NonNull DomainProperty property) {
        this.property = property;
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        DomainModelManager modelManager = evaluator.getModelManager();
        DomainProperty thatProperty = this.property.getOpposite();
        DomainType thatType = (DomainType)DomainUtil.nonNullModel((Object)this.property.getType());
        if (thatType instanceof DomainCollectionType) {
            thatType = ((DomainCollectionType)thatType).getElementType();
        }
        ArrayList<EObject> results = new ArrayList<EObject>();
        if (thatType != null) {
            for (EObject eObject : modelManager.get(thatType)) {
                EClass eClass;
                EStructuralFeature eFeature;
                Object eGet = eObject.eGet(eFeature = (eClass = eObject.eClass()).getEStructuralFeature(thatProperty.getName()));
                if (eGet != sourceValue) continue;
                results.add(eObject);
            }
        }
        return evaluator.getIdResolver().createSetOfAll((CollectionTypeId)returnTypeId, results);
    }
}

