/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainEnumeration;
import org.eclipse.ocl.examples.domain.elements.DomainEnumerationLiteral;
import org.eclipse.ocl.examples.domain.ids.EnumerationId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorEnumerationLiteral;
import org.eclipse.ocl.examples.library.executor.ExecutorEnumerationLiteral;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.manager.ExtensibleTypeServer;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationTypeServer
extends ExtensibleTypeServer
implements DomainEnumeration {
    private Map<String, DomainEnumerationLiteral> literals = new HashMap<String, DomainEnumerationLiteral>();

    public EnumerationTypeServer(@NonNull PackageServer packageServer, @NonNull Enumeration type) {
        super(packageServer, type);
        int index = 0;
        EObject eTarget = type.getETarget();
        if (eTarget instanceof EEnum) {
            for (EEnumLiteral eLiteral : ((EEnum)eTarget).getELiterals()) {
                String enumerationLiteralName = (String)DomainUtil.nonNullModel((Object)eLiteral.getName());
                this.literals.put(enumerationLiteralName, (DomainEnumerationLiteral)new EcoreExecutorEnumerationLiteral(eLiteral, (DomainEnumeration)this, index++));
            }
        } else {
            for (EnumerationLiteral enumerationLiteral : type.getOwnedLiteral()) {
                String enumerationLiteralName = (String)DomainUtil.nonNullModel((Object)enumerationLiteral.getName());
                this.literals.put(enumerationLiteralName, (DomainEnumerationLiteral)new ExecutorEnumerationLiteral(enumerationLiteralName, (DomainEnumeration)this, index++));
            }
        }
    }

    @NonNull
    public EnumerationId getEnumerationId() {
        return (EnumerationId)this.getTypeId();
    }

    @Nullable
    public DomainEnumerationLiteral getEnumerationLiteral(@NonNull String name) {
        return this.literals.get(name);
    }

    @NonNull
    public Iterable<? extends DomainEnumerationLiteral> getEnumerationLiterals() {
        Collection<DomainEnumerationLiteral> result = this.literals.values();
        return result;
    }
}

