/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.DomainInvalidTypeImpl;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.library.executor.AbstractIdResolver;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.TupleTypeManager;

public class PivotIdResolver
extends AbstractIdResolver {
    private static final Logger logger = Logger.getLogger(PivotIdResolver.class);
    @NonNull
    protected final MetaModelManager metaModelManager;

    public PivotIdResolver(@NonNull MetaModelManager metaModelManager) {
        super((DomainStandardLibrary)metaModelManager);
        this.metaModelManager = metaModelManager;
    }

    @NonNull
    public TupleType getTupleType(@NonNull TupleTypeId typeId) {
        TupleTypeManager tupleManager = this.metaModelManager.getTupleManager();
        return tupleManager.getTupleType((IdResolver)this, typeId);
    }

    @NonNull
    public DomainType getType(@NonNull EClassifier eClassifier) {
        try {
            Type pivotType = this.metaModelManager.getPivotOf(Type.class, (EObject)eClassifier);
            if (pivotType != null) {
                return this.metaModelManager.getPrimaryType(pivotType);
            }
        }
        catch (ParserException e) {
            logger.error((Object)("Failed to convert '" + eClassifier + "'"), (Throwable)e);
        }
        return new DomainInvalidTypeImpl(this.standardLibrary, "No object created by Ecore2Pivot");
    }

    @NonNull
    public Type getType(@NonNull TypeId typeId, @Nullable Object context) {
        DomainElement type = (DomainElement)typeId.accept((IdVisitor)this);
        if (type instanceof TemplateParameter) {
            type = ((TemplateParameter)type).getParameteredElement();
        }
        assert (type != null);
        return (Type)type;
    }
}

