/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainLambdaType;
import org.eclipse.ocl.examples.domain.elements.DomainMetaclass;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTemplateParameter;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.TemplateParameter;

public class TemplateSpecialisation {
    @NonNull
    protected final DomainStandardLibrary standardLibrary;
    protected Map<DomainTemplateParameter, DomainType> bindings = null;

    public static boolean needsSpecialisation(@Nullable DomainType referencedType) {
        TemplateParameter templateParameter;
        if (referencedType == null) {
            return true;
        }
        if (referencedType instanceof DomainTemplateParameter) {
            return true;
        }
        if (referencedType instanceof ParameterableElement && (templateParameter = ((ParameterableElement)referencedType).getOwningTemplateParameter()) != null) {
            return true;
        }
        if (referencedType instanceof DomainCollectionType) {
            DomainType elementType = ((DomainCollectionType)referencedType).getElementType();
            return TemplateSpecialisation.needsSpecialisation(elementType);
        }
        if (referencedType instanceof DomainTupleType) {
            DomainTupleType tupleType = (DomainTupleType)referencedType;
            for (DomainProperty tuplePart : tupleType.getLocalProperties()) {
                DomainType tuplePartType = tuplePart.getType();
                if (!TemplateSpecialisation.needsSpecialisation(tuplePartType)) continue;
                return true;
            }
            return false;
        }
        if (referencedType instanceof DomainLambdaType) {
            DomainLambdaType lambdaType = (DomainLambdaType)referencedType;
            DomainType contextType = lambdaType.getContextType();
            if (TemplateSpecialisation.needsSpecialisation(contextType)) {
                return true;
            }
            DomainType resultType = lambdaType.getResultType();
            if (TemplateSpecialisation.needsSpecialisation(resultType)) {
                return true;
            }
            for (DomainType parameterType : lambdaType.getParameterTypes()) {
                if (!TemplateSpecialisation.needsSpecialisation(parameterType)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public TemplateSpecialisation(@NonNull DomainStandardLibrary standardLibrary) {
        this.standardLibrary = standardLibrary;
    }

    @Nullable
    private DomainType getResolution(@Nullable DomainType referencedType) {
        TemplateParameter templateParameter;
        if (referencedType instanceof DomainTemplateParameter) {
            return this.bindings != null ? this.bindings.get(referencedType) : null;
        }
        if (referencedType instanceof ParameterableElement && (templateParameter = ((ParameterableElement)referencedType).getOwningTemplateParameter()) != null) {
            return this.bindings != null ? this.bindings.get(templateParameter) : null;
        }
        if (referencedType instanceof DomainCollectionType) {
            DomainCollectionType collectionType = (DomainCollectionType)referencedType;
            DomainType elementType = this.getResolution(collectionType.getElementType());
            if (elementType == null) {
                elementType = this.standardLibrary.getOclAnyType();
            }
            DomainType containerType = (DomainType)DomainUtil.nonNullState((Object)collectionType.getContainerType());
            return this.standardLibrary.getCollectionType(containerType, elementType, collectionType.getLowerValue(), collectionType.getUpperValue());
        }
        if (referencedType instanceof DomainTupleType) {
            throw new UnsupportedOperationException();
        }
        if (referencedType instanceof DomainLambdaType) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public DomainType getSpecialisation(@NonNull DomainType referredType) {
        DomainType specialisation = this.getResolution(referredType);
        return specialisation != null ? specialisation : referredType;
    }

    public void installEquivalence(@Nullable DomainType resolvedType, @Nullable DomainType referencedType) {
        TemplateParameter templateParameter;
        if (resolvedType == null) {
            return;
        }
        if (referencedType == null) {
            return;
        }
        if (referencedType instanceof DomainMetaclass) {
            referencedType = (DomainType)DomainUtil.nonNullState((Object)((DomainMetaclass)referencedType).getInstanceType());
        }
        if (referencedType instanceof DomainTemplateParameter) {
            DomainTemplateParameter templateParameter2 = (DomainTemplateParameter)referencedType;
            if (this.bindings == null) {
                this.bindings = new HashMap<DomainTemplateParameter, DomainType>();
            }
            if (this.bindings.put(templateParameter2, resolvedType) != null) {
                this.bindings.put(templateParameter2, null);
            }
            return;
        }
        if (referencedType instanceof ParameterableElement && (templateParameter = ((ParameterableElement)referencedType).getOwningTemplateParameter()) != null) {
            if (this.bindings == null) {
                this.bindings = new HashMap<DomainTemplateParameter, DomainType>();
            }
            if (this.bindings.put(templateParameter, resolvedType) != null) {
                this.bindings.put(templateParameter, null);
            }
            return;
        }
        if (referencedType instanceof DomainCollectionType) {
            if (resolvedType instanceof DomainCollectionType) {
                DomainType resolvedElementType = ((DomainCollectionType)resolvedType).getElementType();
                DomainType referencedElementType = ((DomainCollectionType)referencedType).getElementType();
                this.installEquivalence(resolvedElementType, referencedElementType);
            }
            return;
        }
        if (referencedType instanceof DomainTupleType) {
            if (resolvedType instanceof DomainTupleType) {
                DomainTupleType referencedTupleType = (DomainTupleType)referencedType;
                DomainTupleType resolvedTupleType = (DomainTupleType)resolvedType;
                List referencedTupleParts = referencedTupleType.getLocalProperties();
                for (DomainProperty resolvedTuplePart : resolvedTupleType.getLocalProperties()) {
                    DomainProperty referencedTuplePart = (DomainProperty)DomainUtil.getNamedElement((Iterable)referencedTupleParts, (String)resolvedTuplePart.getName());
                    if (referencedTuplePart == null) continue;
                    DomainType resolvedTuplePartType = resolvedTuplePart.getType();
                    DomainType referencedTuplePartType = referencedTuplePart.getType();
                    this.installEquivalence(resolvedTuplePartType, referencedTuplePartType);
                }
            }
            return;
        }
        if (referencedType instanceof DomainLambdaType) {
            if (resolvedType instanceof DomainLambdaType) {
                DomainLambdaType referencedLambdaType = (DomainLambdaType)referencedType;
                DomainLambdaType resolvedLambdaType = (DomainLambdaType)resolvedType;
                this.installEquivalence(resolvedLambdaType.getContextType(), referencedLambdaType.getContextType());
                this.installEquivalence(resolvedLambdaType.getResultType(), referencedLambdaType.getResultType());
                List resolvedParameterTypes = resolvedLambdaType.getParameterTypes();
                List referencedParameterTypes = referencedLambdaType.getParameterTypes();
                int i = 0;
                while (i < Math.min(resolvedParameterTypes.size(), referencedParameterTypes.size())) {
                    DomainType resolvedParameterType = (DomainType)resolvedParameterTypes.get(i);
                    DomainType referencedParameterType = (DomainType)referencedParameterTypes.get(i);
                    this.installEquivalence(resolvedParameterType, referencedParameterType);
                    ++i;
                }
            }
            return;
        }
    }
}

