/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.model;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.AssociativityKind;
import org.eclipse.ocl.examples.pivot.BagType;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OrderedSetType;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.SequenceType;
import org.eclipse.ocl.examples.pivot.SetType;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;

public class AbstractContents {
    @NonNull
    protected AnyType createAnyType(@NonNull String name) {
        AnyType pivotType = PivotFactory.eINSTANCE.createAnyType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    protected BagType createBagType(@NonNull String name, @Nullable String lower, @Nullable String upper) {
        BagType pivotType = PivotFactory.eINSTANCE.createBagType();
        pivotType.setName(name);
        pivotType.setLower(lower != null ? (Number)DomainUtil.createNumberFromString((String)lower) : (Number)0);
        pivotType.setUpper(upper != null ? DomainUtil.createNumberFromString((String)upper) : Unlimited.INSTANCE);
        return pivotType;
    }

    @NonNull
    protected Class createClass(EClass eClass) {
        Class pivotType = PivotFactory.eINSTANCE.createClass();
        pivotType.setName(eClass.getName());
        ((PivotObjectImpl)((Object)pivotType)).setTarget((Notifier)eClass);
        return pivotType;
    }

    @NonNull
    protected Class createClass(@NonNull String name) {
        Class pivotType = PivotFactory.eINSTANCE.createClass();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    protected CollectionType createCollectionType(@NonNull String name, @Nullable String lower, @Nullable String upper) {
        CollectionType pivotType = PivotFactory.eINSTANCE.createCollectionType();
        pivotType.setName(name);
        pivotType.setLower(lower != null ? (Number)DomainUtil.createNumberFromString((String)lower) : (Number)0);
        pivotType.setUpper(upper != null ? DomainUtil.createNumberFromString((String)upper) : Unlimited.INSTANCE);
        return pivotType;
    }

    @NonNull
    protected DataType createDataType(EDataType eDataType) {
        DataType pivotType = PivotFactory.eINSTANCE.createDataType();
        pivotType.setName(eDataType.getName());
        ((PivotObjectImpl)((Object)pivotType)).setTarget((Notifier)eDataType);
        return pivotType;
    }

    @NonNull
    protected DataType createDataType(@NonNull String name) {
        DataType pivotType = PivotFactory.eINSTANCE.createDataType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    protected Enumeration createEnumeration(EEnum eEnum) {
        Enumeration pivotType = PivotFactory.eINSTANCE.createEnumeration();
        pivotType.setName(eEnum.getName());
        ((PivotObjectImpl)((Object)pivotType)).setTarget((Notifier)eEnum);
        return pivotType;
    }

    @NonNull
    protected Enumeration createEnumeration(@NonNull String name) {
        Enumeration pivotType = PivotFactory.eINSTANCE.createEnumeration();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    protected EnumerationLiteral createEnumerationLiteral(EEnumLiteral eEnumLiteral) {
        EnumerationLiteral pivotEnumerationLiteral = PivotFactory.eINSTANCE.createEnumerationLiteral();
        pivotEnumerationLiteral.setName(eEnumLiteral.getName());
        ((PivotObjectImpl)((Object)pivotEnumerationLiteral)).setTarget((Notifier)eEnumLiteral);
        return pivotEnumerationLiteral;
    }

    @NonNull
    protected EnumerationLiteral createEnumerationLiteral(@NonNull String name) {
        EnumerationLiteral pivotEnumerationLiteral = PivotFactory.eINSTANCE.createEnumerationLiteral();
        pivotEnumerationLiteral.setName(name);
        return pivotEnumerationLiteral;
    }

    @NonNull
    protected Iteration createIteration(@NonNull String name, @NonNull Type type, @Nullable String implementationClass, @NonNull LibraryFeature implementation) {
        Iteration pivotIteration = PivotFactory.eINSTANCE.createIteration();
        pivotIteration.setName(name);
        pivotIteration.setType(type);
        pivotIteration.setImplementationClass(implementationClass);
        pivotIteration.setImplementation(implementation);
        return pivotIteration;
    }

    @NonNull
    protected InvalidType createInvalidType(@NonNull String name) {
        InvalidType pivotType = PivotFactory.eINSTANCE.createInvalidType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    protected LambdaType createLambdaType(@NonNull String name) {
        LambdaType pivotType = PivotFactory.eINSTANCE.createLambdaType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    protected Library createLibrary(@NonNull String name, @NonNull String nsPrefix, @NonNull String nsURI) {
        Library pivotLibrary = PivotFactory.eINSTANCE.createLibrary();
        pivotLibrary.setName(name);
        pivotLibrary.setNsPrefix(nsPrefix);
        pivotLibrary.setNsURI(nsURI);
        return pivotLibrary;
    }

    @NonNull
    protected Metaclass createMetaclass(@NonNull String name) {
        Metaclass pivotType = PivotFactory.eINSTANCE.createMetaclass();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    protected OpaqueExpression createOpaqueExpression(@NonNull Type type, @NonNull String exprString) {
        OpaqueExpression pivotExpression = PivotFactory.eINSTANCE.createOpaqueExpression();
        pivotExpression.setType(type);
        pivotExpression.getBody().add(exprString);
        pivotExpression.getLanguage().add("OCL");
        return pivotExpression;
    }

    @NonNull
    protected Operation createOperation(EOperation eOperation, @NonNull Type type, @Nullable String implementationClass, @Nullable LibraryFeature implementation) {
        Operation pivotOperation = PivotFactory.eINSTANCE.createOperation();
        pivotOperation.setName(eOperation.getName());
        pivotOperation.setType(type);
        pivotOperation.setImplementationClass(implementationClass);
        pivotOperation.setImplementation(implementation);
        ((PivotObjectImpl)((Object)pivotOperation)).setTarget((Notifier)eOperation);
        return pivotOperation;
    }

    @NonNull
    protected Operation createOperation(@NonNull String name, @NonNull Type type, @Nullable String implementationClass, @Nullable LibraryFeature implementation) {
        Operation pivotOperation = PivotFactory.eINSTANCE.createOperation();
        pivotOperation.setName(name);
        pivotOperation.setType(type);
        pivotOperation.setImplementationClass(implementationClass);
        pivotOperation.setImplementation(implementation);
        return pivotOperation;
    }

    @NonNull
    protected OrderedSetType createOrderedSetType(@NonNull String name, @Nullable String lower, @Nullable String upper) {
        OrderedSetType pivotType = PivotFactory.eINSTANCE.createOrderedSetType();
        pivotType.setName(name);
        pivotType.setLower(lower != null ? (Number)DomainUtil.createNumberFromString((String)lower) : (Number)0);
        pivotType.setUpper(upper != null ? DomainUtil.createNumberFromString((String)upper) : Unlimited.INSTANCE);
        return pivotType;
    }

    @NonNull
    protected Package createPackage(EPackage ePackage, @Nullable String nsPrefix, @NonNull String nsURI) {
        Package pivotPackage = PivotFactory.eINSTANCE.createPackage();
        pivotPackage.setName(ePackage.getName());
        pivotPackage.setNsPrefix(nsPrefix);
        pivotPackage.setNsURI(nsURI);
        ((PivotObjectImpl)((Object)pivotPackage)).setTarget((Notifier)ePackage);
        return pivotPackage;
    }

    @NonNull
    protected Package createPackage(@NonNull String name, @Nullable String nsPrefix, @NonNull String nsURI) {
        Package pivotPackage = PivotFactory.eINSTANCE.createPackage();
        pivotPackage.setName(name);
        pivotPackage.setNsPrefix(nsPrefix);
        pivotPackage.setNsURI(nsURI);
        return pivotPackage;
    }

    @NonNull
    protected Parameter createParameter(@NonNull String name, @NonNull Type type, boolean isRequired) {
        Parameter pivotParameter = PivotFactory.eINSTANCE.createParameter();
        pivotParameter.setName(name);
        pivotParameter.setType(type);
        pivotParameter.setIsRequired(isRequired);
        return pivotParameter;
    }

    @NonNull
    protected Precedence createPrecedence(@NonNull String name, AssociativityKind kind) {
        assert (kind != null);
        Precedence pivotPrecedence = PivotFactory.eINSTANCE.createPrecedence();
        pivotPrecedence.setName(name);
        pivotPrecedence.setAssociativity(kind);
        return pivotPrecedence;
    }

    @NonNull
    protected PrimitiveType createPrimitiveType(@NonNull String name) {
        PrimitiveType pivotType = PivotFactory.eINSTANCE.createPrimitiveType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    protected Property createProperty(EStructuralFeature eFeature, @NonNull Type type) {
        Property pivotProperty = PivotFactory.eINSTANCE.createProperty();
        pivotProperty.setName(eFeature.getName());
        pivotProperty.setType(type);
        ((PivotObjectImpl)((Object)pivotProperty)).setTarget((Notifier)eFeature);
        return pivotProperty;
    }

    @NonNull
    protected Property createProperty(@NonNull String name, @NonNull Type type) {
        Property pivotProperty = PivotFactory.eINSTANCE.createProperty();
        pivotProperty.setName(name);
        pivotProperty.setType(type);
        return pivotProperty;
    }

    @NonNull
    protected Root createRoot(@NonNull String name, @NonNull String externalURI) {
        Root pivotRoot = PivotFactory.eINSTANCE.createRoot();
        pivotRoot.setName(name);
        pivotRoot.setExternalURI(externalURI);
        return pivotRoot;
    }

    @NonNull
    protected SelfType createSelfType(@NonNull String name) {
        SelfType pivotType = PivotFactory.eINSTANCE.createSelfType();
        pivotType.setName(name);
        return pivotType;
    }

    @NonNull
    protected SequenceType createSequenceType(@NonNull String name, @Nullable String lower, @Nullable String upper) {
        SequenceType pivotType = PivotFactory.eINSTANCE.createSequenceType();
        pivotType.setName(name);
        pivotType.setLower(lower != null ? (Number)DomainUtil.createNumberFromString((String)lower) : (Number)0);
        pivotType.setUpper(upper != null ? DomainUtil.createNumberFromString((String)upper) : Unlimited.INSTANCE);
        return pivotType;
    }

    @NonNull
    protected SetType createSetType(@NonNull String name, @Nullable String lower, @Nullable String upper) {
        SetType pivotType = PivotFactory.eINSTANCE.createSetType();
        pivotType.setName(name);
        pivotType.setLower(lower != null ? (Number)DomainUtil.createNumberFromString((String)lower) : (Number)0);
        pivotType.setUpper(upper != null ? DomainUtil.createNumberFromString((String)upper) : Unlimited.INSTANCE);
        return pivotType;
    }

    @NonNull
    protected TemplateBinding createTemplateBinding(@NonNull TemplateSignature templateSignature, TemplateParameterSubstitution ... templateParameterSubstitutions) {
        TemplateBinding pivotTemplateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        List<TemplateParameterSubstitution> parameterSubstitutions = pivotTemplateBinding.getParameterSubstitution();
        TemplateParameterSubstitution[] templateParameterSubstitutionArray = templateParameterSubstitutions;
        int n = templateParameterSubstitutions.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateParameterSubstitution templateParameterSubstitution = templateParameterSubstitutionArray[n2];
            parameterSubstitutions.add(templateParameterSubstitution);
            ++n2;
        }
        pivotTemplateBinding.setSignature(templateSignature);
        return pivotTemplateBinding;
    }

    @NonNull
    protected TemplateParameterSubstitution createTemplateParameterSubstitution(@NonNull TemplateParameter formal, ParameterableElement actual) {
        TemplateParameterSubstitution pivotTemplateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
        pivotTemplateParameterSubstitution.setFormal(formal);
        pivotTemplateParameterSubstitution.setActual(actual);
        return pivotTemplateParameterSubstitution;
    }

    @NonNull
    protected TemplateSignature createTemplateSignature(@NonNull TemplateableElement templateableElement, TemplateParameter ... templateParameters) {
        TemplateSignature pivotTemplateSignature = PivotFactory.eINSTANCE.createTemplateSignature();
        List<TemplateParameter> parameters = pivotTemplateSignature.getOwnedParameter();
        TemplateParameter[] templateParameterArray = templateParameters;
        int n = templateParameters.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateParameter templateParameter = templateParameterArray[n2];
            parameters.add(templateParameter);
            ++n2;
        }
        pivotTemplateSignature.setTemplate(templateableElement);
        return pivotTemplateSignature;
    }

    @NonNull
    protected TupleType createTupleType(@NonNull String name, Property ... properties) {
        TupleType pivotType = PivotFactory.eINSTANCE.createTupleType();
        pivotType.setName(name);
        List<Property> ownedProperties = pivotType.getOwnedAttribute();
        Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            ownedProperties.add(property);
            ++n2;
        }
        return pivotType;
    }

    @NonNull
    protected TypeTemplateParameter createTypeTemplateParameter(@NonNull Type type) {
        TypeTemplateParameter pivotTypeTemplateParameter = PivotFactory.eINSTANCE.createTypeTemplateParameter();
        pivotTypeTemplateParameter.setOwnedParameteredElement(type);
        return pivotTypeTemplateParameter;
    }

    @NonNull
    protected VoidType createVoidType(@NonNull String name) {
        VoidType pivotType = PivotFactory.eINSTANCE.createVoidType();
        pivotType.setName(name);
        return pivotType;
    }

    protected void installComment(Element element, @NonNull String body) {
        Comment pivotComment = PivotFactory.eINSTANCE.createComment();
        pivotComment.setBody(body);
        element.getOwnedComment().add(pivotComment);
    }
}

