/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Transition;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.Vertex;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.uml.UML2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UML2PivotReferenceSwitch
extends UMLSwitch<Object> {
    @NonNull
    protected final UML2Pivot converter;
    @NonNull
    protected final MetaModelManager metaModelManager;

    public UML2PivotReferenceSwitch(@NonNull UML2Pivot converter) {
        this.converter = converter;
        this.metaModelManager = converter.getMetaModelManager();
    }

    public Class caseClass(org.eclipse.uml2.uml.Class umlClass) {
        assert (umlClass != null);
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)umlClass);
        if (pivotElement != null) {
            this.doSwitchAll(Type.class, pivotElement.getSuperClass(), (List<? extends EObject>)umlClass.getSuperClasses());
            if (pivotElement.getSuperClass().isEmpty()) {
                Class oclElementType = this.metaModelManager.getOclElementType();
                pivotElement.getSuperClass().add(oclElementType);
            }
        }
        return pivotElement;
    }

    public Constraint caseConstraint(org.eclipse.uml2.uml.Constraint umlConstraint) {
        assert (umlConstraint != null);
        Constraint pivotElement = this.converter.getCreated(Constraint.class, (EObject)umlConstraint);
        if (pivotElement != null) {
            this.doSwitchAll(Element.class, pivotElement.getConstrainedElement(), (List<? extends EObject>)umlConstraint.getConstrainedElements());
        }
        return pivotElement;
    }

    public Class caseInterface(Interface umlInterface) {
        assert (umlInterface != null);
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)umlInterface);
        if (pivotElement != null) {
            EList umlGeneralizations = umlInterface.getGeneralizations();
            ArrayList<Type> newSuperTypes = new ArrayList<Type>(Math.max(1, umlGeneralizations.size()));
            for (Generalization umlGeneralization : umlGeneralizations) {
                Type pivotGeneral;
                Classifier umlGeneral = umlGeneralization.getGeneral();
                if (umlGeneral == null || newSuperTypes.contains(pivotGeneral = this.converter.getCreated(Type.class, (EObject)umlGeneral))) continue;
                newSuperTypes.add(pivotGeneral);
            }
            if (newSuperTypes.isEmpty()) {
                Class oclElementType = this.metaModelManager.getOclElementType();
                newSuperTypes.add(oclElementType);
            }
            PivotUtil.refreshList(pivotElement.getSuperClass(), newSuperTypes);
        }
        return pivotElement;
    }

    public Operation caseOperation(org.eclipse.uml2.uml.Operation umlOperation) {
        assert (umlOperation != null);
        Operation pivotElement = this.converter.getCreated(Operation.class, (EObject)umlOperation);
        if (pivotElement != null) {
            this.doSwitchAll(Type.class, pivotElement.getRaisedException(), (List<? extends EObject>)umlOperation.getRaisedExceptions());
            this.doSwitchAll(Operation.class, pivotElement.getRedefinedOperation(), (List<? extends EObject>)umlOperation.getRedefinedOperations());
            for (Parameter umlParameter : umlOperation.getOwnedParameters()) {
                ParameterDirectionKind direction = umlParameter.getDirection();
                if (direction != ParameterDirectionKind.RETURN_LITERAL) continue;
                this.resolveMultiplicity(pivotElement, (org.eclipse.uml2.uml.TypedElement)umlParameter);
            }
        }
        return pivotElement;
    }

    public Package casePackage(org.eclipse.uml2.uml.Package umlPackage) {
        assert (umlPackage != null);
        Package pivotElement = this.converter.getCreated(Package.class, (EObject)umlPackage);
        if (pivotElement != null) {
            this.doSwitchAll(Package.class, pivotElement.getImportedPackage(), (List<? extends EObject>)umlPackage.getImportedPackages());
        }
        return pivotElement;
    }

    public Property caseProperty(org.eclipse.uml2.uml.Property umlProperty) {
        assert (umlProperty != null);
        Property pivotElement = this.converter.getCreated(Property.class, (EObject)umlProperty);
        if (pivotElement != null) {
            this.resolveMultiplicity(pivotElement, (org.eclipse.uml2.uml.TypedElement)umlProperty);
            this.doSwitchAll(Property.class, pivotElement.getRedefinedProperty(), (List<? extends EObject>)umlProperty.getRedefinedProperties());
        }
        return pivotElement;
    }

    public Transition caseTransition(org.eclipse.uml2.uml.Transition umlTransition) {
        assert (umlTransition != null);
        Transition pivotElement = this.converter.getCreated(Transition.class, (EObject)umlTransition);
        if (pivotElement != null) {
            org.eclipse.uml2.uml.Vertex umlSource = umlTransition.getSource();
            org.eclipse.uml2.uml.Vertex umlTarget = umlTransition.getTarget();
            Vertex pivotSource = umlSource != null ? this.converter.getCreated(Vertex.class, (EObject)umlSource) : null;
            Vertex pivotTarget = umlTarget != null ? this.converter.getCreated(Vertex.class, (EObject)umlTarget) : null;
            pivotElement.setSource(pivotSource);
            pivotElement.setTarget(pivotTarget);
        }
        return pivotElement;
    }

    public EObject caseTypedElement(org.eclipse.uml2.uml.TypedElement umlTypedElement) {
        assert (umlTypedElement != null);
        TypedElement pivotElement = this.converter.getCreated(TypedElement.class, (EObject)umlTypedElement);
        if (pivotElement != null) {
            this.resolveMultiplicity(pivotElement, umlTypedElement);
        }
        return pivotElement;
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(@NonNull java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        assert (pivotElements != null);
        assert (eObjects != null);
        for (EObject eObject : eObjects) {
            UML2Pivot adapter;
            Resource eResource;
            if (eObject == null) continue;
            T pivotElement = this.converter.getCreated(pivotClass, eObject);
            if (pivotElement == null && (eResource = eObject.eResource()) != null && (adapter = UML2Pivot.findAdapter(eResource, this.metaModelManager)) != null) {
                pivotElement = adapter.getCreated(pivotClass, eObject);
            }
            if (pivotElement == null) continue;
            pivotElements.add(pivotElement);
        }
    }

    @Nullable
    public org.eclipse.uml2.uml.Property getOtherEnd(@NonNull List<org.eclipse.uml2.uml.Property> umlMemberEnds, @NonNull org.eclipse.uml2.uml.Property umlProperty) {
        for (org.eclipse.uml2.uml.Property umlMemberEnd : umlMemberEnds) {
            if (umlMemberEnd == umlProperty) continue;
            return umlMemberEnd;
        }
        return null;
    }

    protected void resolveMultiplicity(@NonNull TypedElement pivotElement, @NonNull org.eclipse.uml2.uml.TypedElement umlTypedElement) {
        boolean isRequired = false;
        org.eclipse.uml2.uml.Type umlType = umlTypedElement.getType();
        if (umlType != null) {
            Type pivotType = this.converter.resolveType(umlType);
            if (umlTypedElement instanceof MultiplicityElement && pivotType != null) {
                MultiplicityElement umlMultiplicity = (MultiplicityElement)umlTypedElement;
                int lower = umlMultiplicity.getLower();
                int upper = umlMultiplicity.getUpper();
                if (upper == 1) {
                    isRequired = lower == 1;
                } else {
                    isRequired = true;
                    boolean isOrdered = umlMultiplicity.isOrdered();
                    boolean isUnique = umlMultiplicity.isUnique();
                    IntegerValue lowerValue = ValuesUtil.integerValueOf((int)lower);
                    UnlimitedValue upperValue = upper == -1 ? ValuesUtil.UNLIMITED_VALUE : ValuesUtil.integerValueOf((int)upper);
                    pivotType = this.metaModelManager.getCollectionType(isOrdered, isUnique, pivotType, lowerValue, (IntegerValue)upperValue);
                }
            }
            pivotElement.setType(pivotType);
        } else {
            pivotElement.setType(this.metaModelManager.getOclVoidType());
        }
        pivotElement.setIsRequired(isRequired);
    }
}

