/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.validation.LoadableConstraintProvider;
import org.eclipse.uml2.uml.resource.UMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLProfileConstraintProvider
extends LoadableConstraintProvider {
    private static final Logger logger = Logger.getLogger(UMLProfileConstraintProvider.class);

    @Override
    protected boolean load(@NonNull MetaModelManager metaModelManager, @NonNull URI uri, @NonNull Set<Category> categories) {
        PivotResource pivotResource;
        ResourceSet resourceSet = metaModelManager.getExternalResourceSet();
        UMLResource umlResource = null;
        try {
            umlResource = (UMLResource)resourceSet.getResource(uri, true);
        }
        catch (WrappedException e) {
            logger.error((Object)("Failed to load '" + uri), (Throwable)e);
            throw e;
        }
        EList errors = umlResource.getErrors();
        assert (errors != null);
        String message = PivotUtil.formatResourceDiagnostics((List<Resource.Diagnostic>)errors, "", "\n");
        if (message != null) {
            logger.error((Object)("Failed to load '" + uri + message));
            return false;
        }
        try {
            pivotResource = UMLProfileConstraintProvider.getOCL().uml2pivot((Resource)umlResource);
        }
        catch (ParserException e) {
            logger.error((Object)("Failed to load Pivot from '" + uri + "': "), (Throwable)e);
            return false;
        }
        return this.installResource((Resource)pivotResource, categories);
    }
}

