/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.AbstractEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.PivotEvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;

public class PivotEnvironmentFactory
extends AbstractEnvironmentFactory {
    private static PivotEnvironmentFactory globalRegistryInstance = null;
    protected final MetaModelManager metaModelManager;
    private final EPackage.Registry registry;

    public static void disposeGlobalRegistryInstance() {
        if (globalRegistryInstance != null) {
            globalRegistryInstance.getMetaModelManager().dispose();
            globalRegistryInstance = null;
        }
    }

    @NonNull
    public static PivotEnvironmentFactory getGlobalRegistryInstance() {
        if (globalRegistryInstance == null) {
            globalRegistryInstance = new PivotEnvironmentFactory();
        }
        return globalRegistryInstance;
    }

    public PivotEnvironmentFactory() {
        this(EPackage.Registry.INSTANCE, null);
    }

    public PivotEnvironmentFactory(EPackage.Registry reg, @Nullable MetaModelManager metaModelManager) {
        this.registry = reg;
        this.metaModelManager = metaModelManager != null ? metaModelManager : new MetaModelManager();
    }

    @NonNull
    public PivotEnvironment createEnvironment() {
        PivotEnvironment result = new PivotEnvironment(this, null);
        return result;
    }

    @NonNull
    public PivotEnvironment loadEnvironment(@NonNull Resource resource) {
        PivotEnvironment result = new PivotEnvironment(this, resource);
        return result;
    }

    public final EPackage.Registry getEPackageRegistry() {
        return this.registry;
    }

    @NonNull
    public PivotEnvironment createEnvironment(@NonNull Environment parent) {
        if (!(parent instanceof PivotEnvironment)) {
            throw new IllegalArgumentException("Parent environment must be a Pivot environment: " + parent);
        }
        PivotEnvironment result = new PivotEnvironment((PivotEnvironment)parent);
        return result;
    }

    @NonNull
    public PivotEvaluationEnvironment createEvaluationEnvironment() {
        return new PivotEvaluationEnvironment(this.getMetaModelManager());
    }

    @NonNull
    public PivotEvaluationEnvironment createEvaluationEnvironment(@NonNull EvaluationEnvironment parent) {
        return new PivotEvaluationEnvironment(parent);
    }

    @NonNull
    protected Type getClassifier(@NonNull Object context) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }
}

