/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.AbstractPivotSaver;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotSaver
extends AbstractPivotSaver {
    public static AbstractPivotSaver.Factory FACTORY = new Factory();
    protected final Resource resource;
    private Map<String, Operation> operations = new HashMap<String, Operation>();
    private List<Element> specializingElements = new ArrayList<Element>();
    private Package orphanage = null;
    private Map<Type, Type> specializations = new HashMap<Type, Type>();
    private Class orphanageClass = null;

    public PivotSaver(Resource resource) {
        this.resource = resource;
    }

    @Override
    public void addSpecializingElement(@NonNull Element object) {
        this.specializingElements.add(object);
    }

    @Override
    public boolean addSpecializingElement(@NonNull Element object, @NonNull Operation referredOperation) {
        if (!this.isOrphanOperation(referredOperation)) {
            return false;
        }
        this.specializingElements.add(object);
        return true;
    }

    @Override
    public boolean addSpecializingElement(@NonNull Element object, @NonNull Type referredType) {
        if (PivotUtil.isLibraryType(referredType)) {
            return false;
        }
        this.specializingElements.add(object);
        return true;
    }

    protected Package getOrphanPackage(Resource resource) {
        if (this.orphanage == null) {
            this.orphanage = PivotFactory.eINSTANCE.createPackage();
            this.orphanage.setName("$$");
            this.orphanage.setNsURI("http://www.eclipse.org/ocl/3.1.0/orphanage");
            resource.getContents().add((Object)this.orphanage);
            this.orphanageClass = PivotFactory.eINSTANCE.createAnyType();
            this.orphanageClass.setName("$$");
            this.orphanage.getOwnedType().add(this.orphanageClass);
        }
        return this.orphanage;
    }

    protected boolean isOrphanOperation(Operation operation) {
        return operation.getTemplateBinding().size() > 0;
    }

    public Package localizeSpecializations() {
        this.locateSpecializations((List<? extends EObject>)this.resource.getContents());
        if (this.specializingElements.size() > 0) {
            this.orphanage = this.getOrphanPackage(this.resource);
            int i = 0;
            while (i < this.specializingElements.size()) {
                Element element = this.specializingElements.get(i);
                if (element != null) {
                    AbstractPivotSaver.ResolveVisitor resolveVisitor = this.getResolveVisitor(element);
                    resolveVisitor.safeVisit(element);
                }
                ++i;
            }
        }
        return this.orphanage;
    }

    protected void locateSpecializations(List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            if (eObject instanceof Visitable) {
                AbstractPivotSaver.LocateVisitor locateVisitor = this.getLocateVisitor(eObject);
                locateVisitor.safeVisit((Visitable)eObject);
            }
            this.locateSpecializations((List<? extends EObject>)eObject.eContents());
        }
    }

    @Override
    @NonNull
    public <T extends Operation> T resolveOperation(@NonNull T referredOperation) {
        if (!this.isOrphanOperation(referredOperation)) {
            return referredOperation;
        }
        String moniker = Pivot2Moniker.toString(referredOperation);
        Operation operation = this.operations.get(moniker);
        if (operation != null) {
            Operation castOperation = operation;
            return (T)castOperation;
        }
        Operation resolvedOperation = (Operation)DomainUtil.nonNullEMF((Object)((Operation)EcoreUtil.copy(referredOperation)));
        this.orphanageClass.getOwnedOperation().add(resolvedOperation);
        this.operations.put(moniker, resolvedOperation);
        String newMoniker = Pivot2Moniker.toString(resolvedOperation);
        assert (moniker.equals(newMoniker));
        this.locateSpecializations(Collections.singletonList(resolvedOperation));
        return (T)resolvedOperation;
    }

    @Override
    @NonNull
    public <T extends Type> T resolveType(@NonNull T referredType) {
        if (PivotUtil.isLibraryType(referredType)) {
            return referredType;
        }
        Type resolvedType = this.specializations.get(referredType);
        if (resolvedType == null) {
            resolvedType = (Type)DomainUtil.nonNullEMF((Object)((Type)EcoreUtil.copy(referredType)));
            this.specializations.put(referredType, resolvedType);
            this.specializations.put(resolvedType, resolvedType);
            this.orphanage.getOwnedType().add(resolvedType);
        }
        this.locateSpecializations(Collections.singletonList(resolvedType));
        return (T)resolvedType;
    }

    private static final class Factory
    implements AbstractPivotSaver.Factory {
        private Factory() {
            PivotSaver.addFactory(this);
        }

        @NonNull
        public LocateVisitor createLocateVisitor(@NonNull AbstractPivotSaver saver) {
            return new LocateVisitor(saver);
        }

        @NonNull
        public ResolveVisitor createResolveVisitor(@NonNull AbstractPivotSaver saver) {
            return new ResolveVisitor(saver);
        }

        @NonNull
        public EPackage getEPackage() {
            return (EPackage)DomainUtil.nonNullEMF((Object)PivotPackage.eINSTANCE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocateVisitor
    extends AbstractExtendingVisitor<Object, AbstractPivotSaver>
    implements AbstractPivotSaver.LocateVisitor {
        protected LocateVisitor(@NonNull AbstractPivotSaver context) {
            super(context);
        }

        @Override
        public Object visitClass(@NonNull Class object) {
            for (Type superClass : object.getSuperClass()) {
                if (superClass.getTemplateBinding().size() <= 0) continue;
                ((AbstractPivotSaver)this.context).addSpecializingElement(object);
                break;
            }
            return null;
        }

        @Override
        public Object visitCollectionType(@NonNull CollectionType object) {
            Type referredType = object.getElementType();
            if (referredType != null) {
                ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredType);
            }
            return super.visitCollectionType(object);
        }

        @Override
        public Object visitLambdaType(@NonNull LambdaType object) {
            boolean doneIt = false;
            Type referredType = object.getContextType();
            if (referredType != null && ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredType)) {
                doneIt = true;
            }
            if (!doneIt) {
                referredType = object.getResultType();
                if (referredType != null && ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredType)) {
                    doneIt = true;
                }
                if (!doneIt) {
                    for (Type parameterType : object.getParameterType()) {
                        if (parameterType != null && ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, parameterType)) break;
                    }
                }
            }
            return super.visitLambdaType(object);
        }

        @Override
        public Object visitLoopExp(@NonNull LoopExp object) {
            Iteration referredIteration = object.getReferredIteration();
            if (referredIteration != null) {
                ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredIteration);
            }
            return super.visitLoopExp(object);
        }

        @Override
        public Object visitOperationCallExp(@NonNull OperationCallExp object) {
            Operation referredOperation = object.getReferredOperation();
            if (referredOperation != null) {
                ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredOperation);
            }
            return super.visitOperationCallExp(object);
        }

        @Override
        public Object visitProperty(@NonNull Property object) {
            Property opposite = object.getOpposite();
            if (opposite != null) {
                Resource eResource = opposite.eResource();
                assert (eResource != null);
            }
            return super.visitProperty(object);
        }

        @Override
        public Object visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution object) {
            ParameterableElement actual = object.getActual();
            if (actual instanceof Type) {
                ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, (Type)actual);
            }
            return null;
        }

        @Override
        public Object visitTypedElement(@NonNull TypedElement object) {
            Type referredType = object.getType();
            if (referredType != null) {
                ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredType);
            }
            return null;
        }

        @Override
        public Object visitTypeTemplateParameter(@NonNull TypeTemplateParameter object) {
            for (Type constrainingType : object.getConstrainingType()) {
                if (constrainingType != null && ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, constrainingType)) break;
            }
            return null;
        }

        @Override
        public Object visiting(@NonNull Visitable visitable) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResolveVisitor
    extends AbstractExtendingVisitor<Object, AbstractPivotSaver>
    implements AbstractPivotSaver.ResolveVisitor {
        protected ResolveVisitor(@NonNull AbstractPivotSaver saver) {
            super(saver);
        }

        @Override
        public Object visitClass(@NonNull Class object) {
            List<Type> superClasses = object.getSuperClass();
            int i = 0;
            while (i < superClasses.size()) {
                Type referredClass = superClasses.get(i);
                if (referredClass != null) {
                    Type resolvedClass = ((AbstractPivotSaver)this.context).resolveType(referredClass);
                    superClasses.set(i, resolvedClass);
                }
                ++i;
            }
            return null;
        }

        @Override
        public Object visitCollectionType(@NonNull CollectionType object) {
            Type referredType = (Type)DomainUtil.nonNullModel((Object)object.getElementType());
            Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            if (resolvedType != referredType) {
                object.setElementType(resolvedType);
            }
            return super.visitCollectionType(object);
        }

        @Override
        public Object visitLambdaType(@NonNull LambdaType object) {
            Type referredType = (Type)DomainUtil.nonNullModel((Object)object.getContextType());
            Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            object.setContextType(resolvedType);
            referredType = (Type)DomainUtil.nonNullModel((Object)object.getResultType());
            resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            object.setResultType(resolvedType);
            List<Type> parameterTypes = object.getParameterType();
            int i = 0;
            while (i < parameterTypes.size()) {
                referredType = parameterTypes.get(i);
                if (referredType != null) {
                    resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
                    parameterTypes.set(i, resolvedType);
                }
                ++i;
            }
            return super.visitLambdaType(object);
        }

        @Override
        public Object visitLoopExp(@NonNull LoopExp object) {
            Iteration referredIteration = (Iteration)DomainUtil.nonNullModel((Object)object.getReferredIteration());
            Iteration resolvedIteration = ((AbstractPivotSaver)this.context).resolveOperation(referredIteration);
            object.setReferredIteration(resolvedIteration);
            return null;
        }

        @Override
        public Object visitMetaclass(@NonNull Metaclass object) {
            Type referredType = (Type)DomainUtil.nonNullModel((Object)object.getInstanceType());
            Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            object.setInstanceType(resolvedType);
            return super.visitMetaclass(object);
        }

        @Override
        public Object visitOperationCallExp(@NonNull OperationCallExp object) {
            Operation referredOperation = (Operation)DomainUtil.nonNullModel((Object)object.getReferredOperation());
            Operation resolvedOperation = ((AbstractPivotSaver)this.context).resolveOperation(referredOperation);
            object.setReferredOperation(resolvedOperation);
            return null;
        }

        @Override
        public Object visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution object) {
            Type referredType = (Type)DomainUtil.nonNullModel((Object)((Type)object.getActual()));
            Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            object.setActual(resolvedType);
            return null;
        }

        @Override
        public Object visitTypeTemplateParameter(@NonNull TypeTemplateParameter object) {
            List<Type> constrainingTypes = object.getConstrainingType();
            int i = 0;
            while (i < constrainingTypes.size()) {
                Type referredType = constrainingTypes.get(i);
                if (referredType != null) {
                    Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
                    constrainingTypes.set(i, resolvedType);
                }
                ++i;
            }
            return null;
        }

        @Override
        public Object visitTypedElement(@NonNull TypedElement object) {
            Type referredType = (Type)DomainUtil.nonNullEMF((Object)object.getType());
            Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            object.setType(resolvedType);
            return null;
        }

        @Override
        public Object visiting(@NonNull Visitable visitable) {
            throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for PivotSaver Resolve pass");
        }
    }
}

