/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.evaluation.DomainException;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.ProblemAware;
import org.eclipse.ocl.examples.pivot.Query;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.helper.HelperUtil;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.PivotPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl
implements Query,
ProblemAware {
    private final OCL ocl;
    private final Environment environment;
    private final ExpressionInOCL specification;
    private final OCLExpression expression;
    private DomainModelManager modelManager = null;
    private EvaluationEnvironment evalEnv;
    private Diagnostic evalProblems;
    private BasicDiagnostic batchEvalProblems;

    public QueryImpl(@NonNull OCL ocl, @NonNull ExpressionInOCL specification) {
        this.ocl = ocl;
        this.environment = ocl.getEnvironment();
        this.specification = specification;
        this.expression = specification.getBodyExpression();
        this.modelManager = ocl.getModelManager();
    }

    @Override
    public boolean check(Object obj) {
        if (this.resultType() != this.environment.getOCLStandardLibrary().getBooleanType()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.BooleanQuery_ERROR_);
            PivotPlugin.throwing(this.getClass(), "check", error);
            throw error;
        }
        Object result = obj == null ? this.evaluate() : this.evaluate(obj);
        return result == ValuesUtil.TRUE_VALUE;
    }

    @Override
    public boolean check(List<?> objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            PivotPlugin.throwing(this.getClass(), "check", error);
            throw error;
        }
        if (this.resultType() != this.environment.getOCLStandardLibrary().getBooleanType()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.BooleanQuery_ERROR_);
            PivotPlugin.throwing(this.getClass(), "check", error);
            throw error;
        }
        Iterator<?> iter = objList.iterator();
        while (iter.hasNext()) {
            if (this.check(iter.next())) continue;
            return false;
        }
        return true;
    }

    private void commitBatchEvaluateProblems() {
        this.evalProblems = this.batchEvalProblems;
        this.batchEvalProblems = null;
    }

    @Override
    public Object evaluate() throws DomainException {
        Object result;
        this.evalProblems = null;
        Environment nonNullEnvironment = this.environment;
        EvaluationVisitor ev = nonNullEnvironment.getFactory().createEvaluationVisitor(nonNullEnvironment, this.getEvaluationEnvironment(), this.getModelManager());
        try {
            result = this.expression.accept(ev);
        }
        catch (EvaluationHaltedException e) {
            this.evalProblems = e.getDiagnostic();
            throw e;
        }
        return result;
    }

    @Override
    public Object evaluate(Object obj) throws DomainException {
        Object result;
        this.evalProblems = null;
        if (obj == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectEObj_ERROR_);
            PivotPlugin.throwing(this.getClass(), "evaluate", error);
            throw error;
        }
        obj = HelperUtil.getConstraintContext(this.environment, obj, this.expression);
        EvaluationEnvironment myEnv = this.getEvaluationEnvironment();
        Variable contextVariable = (Variable)DomainUtil.nonNullState((Object)this.specification.getContextVariable());
        myEnv.add(contextVariable, myEnv.getMetaModelManager().getIdResolver().boxedValueOf(obj));
        Environment nonNullEnvironment = this.environment;
        EvaluationVisitor ev = nonNullEnvironment.getFactory().createEvaluationVisitor(nonNullEnvironment, myEnv, this.getModelManager());
        try {
            result = this.expression.accept(ev);
        }
        catch (EvaluationHaltedException e) {
            this.evalProblems = e.getDiagnostic();
            throw e;
        }
        return result;
    }

    @Override
    public List<?> evaluate(List<?> objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            PivotPlugin.throwing(this.getClass(), "evaluate", error);
            throw error;
        }
        BasicEList result = new BasicEList();
        Iterator<?> iter = objList.iterator();
        try {
            while (iter.hasNext()) {
                result.add(this.evaluate(iter.next()));
                this.handleNextEvaluateProblems();
            }
        }
        finally {
            this.commitBatchEvaluateProblems();
        }
        return result;
    }

    @Override
    @NonNull
    public EvaluationEnvironment getEvaluationEnvironment() {
        if (this.evalEnv == null) {
            this.evalEnv = this.environment.getFactory().createEvaluationEnvironment();
        }
        return this.evalEnv;
    }

    @Override
    public OCLExpression getExpression() {
        return this.expression;
    }

    @Override
    @NonNull
    public DomainModelManager getModelManager() {
        if (this.modelManager == null) {
            EvaluationEnvironment myEnv = this.getEvaluationEnvironment();
            Object context = myEnv.getValueOf(this.specification.getContextVariable());
            this.modelManager = myEnv.createModelManager(context);
        }
        return this.modelManager;
    }

    @Override
    @NonNull
    public OCL getOCL() {
        return this.ocl;
    }

    @Override
    public Diagnostic getProblems() {
        return this.evalProblems;
    }

    private void handleNextEvaluateProblems() {
        Diagnostic nextEvalProblems = this.getProblems();
        if (nextEvalProblems != null) {
            if (this.batchEvalProblems == null) {
                BasicDiagnostic rootDiagnostic;
                this.batchEvalProblems = rootDiagnostic = new BasicDiagnostic(nextEvalProblems.getSeverity(), PivotPlugin.getPluginId(), nextEvalProblems.getCode(), nextEvalProblems.getMessage(), null);
            }
            this.batchEvalProblems.add(nextEvalProblems);
        }
    }

    @Override
    public String queryText() {
        return this.expression.toString();
    }

    @Override
    public <T> List<T> reject(List<T> objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            PivotPlugin.throwing(this.getClass(), "reject", error);
            throw error;
        }
        BasicEList result = new BasicEList();
        try {
            for (T obj : objList) {
                if (!this.check(obj)) {
                    result.add(obj);
                }
                this.handleNextEvaluateProblems();
            }
        }
        finally {
            this.commitBatchEvaluateProblems();
        }
        return result;
    }

    @Override
    public Type resultType() {
        return this.expression.getType();
    }

    @Override
    public <T> List<T> select(List<T> objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            PivotPlugin.throwing(this.getClass(), "select", error);
            throw error;
        }
        BasicEList result = new BasicEList();
        try {
            for (T obj : objList) {
                if (this.check(obj)) {
                    result.add(obj);
                }
                this.handleNextEvaluateProblems();
            }
        }
        finally {
            this.commitBatchEvaluateProblems();
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Query[");
        result.append(this.queryText());
        result.append(']');
        return result.toString();
    }
}

