/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotEObjectValidator
extends EObjectValidator {
    @NonNull
    private static final PivotEObjectValidator INSTANCE = new PivotEObjectValidator();
    @NonNull
    private static final Map<EPackage, EValidator> eValidators = new HashMap<EPackage, EValidator>();

    @NonNull
    public static ValidationAdapter install(@NonNull ResourceSet resourceSet, @NonNull MetaModelManager metaModelManager) {
        ValidationAdapter validationAdapter = ValidationAdapter.findAdapter(resourceSet);
        if (validationAdapter != null) {
            if (validationAdapter.getMetaModelManager() != metaModelManager) {
                throw new IllegalArgumentException("Inconsistent metaModelManager");
            }
        } else {
            validationAdapter = new ValidationAdapter(metaModelManager);
            resourceSet.eAdapters().add((Object)validationAdapter);
        }
        return validationAdapter;
    }

    public static synchronized void install(@NonNull EPackage ePackage) {
        if (!eValidators.containsKey(ePackage)) {
            Object oldEntry = EValidator.Registry.INSTANCE.put((Object)ePackage, (Object)INSTANCE);
            if (oldEntry instanceof EValidator.Descriptor) {
                oldEntry = ((EValidator.Descriptor)oldEntry).getEValidator();
            }
            EValidator eValidator = (EValidator)oldEntry;
            eValidators.put(ePackage, eValidator);
        }
    }

    public static ResourceSet getResourceSet(@NonNull EClassifier eClassifier, @NonNull Object object, @Nullable DiagnosticChain diagnostics) {
        ResourceSet resourceSet = null;
        if (diagnostics instanceof BasicDiagnostic) {
            for (Object dataObject : ((BasicDiagnostic)diagnostics).getData()) {
                Resource resource;
                if (dataObject instanceof EObject && (resource = EcoreUtil.getRootContainer((EObject)((EObject)dataObject)).eResource()) != null && (resourceSet = resource.getResourceSet()) != null) break;
            }
        }
        if (resourceSet == null) {
            Resource resource;
            if (object instanceof EObject && (resource = EcoreUtil.getRootContainer((EObject)((EObject)object)).eResource()) != null) {
                resourceSet = resource.getResourceSet();
            }
            if (resourceSet == null && (resource = EcoreUtil.getRootContainer((EObject)eClassifier).eResource()) != null) {
                resourceSet = resource.getResourceSet();
            }
        }
        return resourceSet;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        if (eClass != null && !eObject.eIsProxy()) {
            allOk &= this.validatePivot((EClassifier)eClass, eObject, diagnostics, context);
        }
        return allOk;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (value != null);
        boolean allOk = true;
        EPackage ePackage = eDataType.getEPackage();
        EValidator eValidator = eValidators.get(ePackage);
        if (eValidator != null) {
            allOk &= eValidator.validate(eDataType, value, diagnostics, context);
        }
        if ((allOk || diagnostics != null) && eDataType.isInstance(value)) {
            allOk &= this.validatePivot((EClassifier)eDataType, value, diagnostics, context);
        }
        return allOk;
    }

    protected boolean validatePivot(@NonNull EClassifier eClassifier, @NonNull Object object, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context) {
        ValidationAdapter validationAdapter;
        ResourceSet resourceSet = PivotEObjectValidator.getResourceSet(eClassifier, object, diagnostics);
        if (resourceSet != null && (validationAdapter = ValidationAdapter.findAdapter(resourceSet)) != null) {
            boolean allOk = validationAdapter.validate(eClassifier, object, diagnostics, context);
            return allOk || diagnostics != null;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidationAdapter
    extends AdapterImpl {
        @NonNull
        protected final MetaModelManager metaModelManager;
        @NonNull
        protected final EnvironmentFactory environmentFactory;
        @NonNull
        protected final Environment rootEnvironment;

        public static ValidationAdapter findAdapter(@NonNull ResourceSet resourceSet) {
            ResourceSet externalResourceSet;
            for (Adapter adapter : resourceSet.eAdapters()) {
                if (!(adapter instanceof ValidationAdapter)) continue;
                return (ValidationAdapter)adapter;
            }
            MetaModelManager metaModelManager = PivotUtil.findMetaModelManager(resourceSet);
            if (metaModelManager != null && (externalResourceSet = metaModelManager.getExternalResourceSet()) != null) {
                for (Adapter adapter : externalResourceSet.eAdapters()) {
                    if (!(adapter instanceof ValidationAdapter)) continue;
                    return (ValidationAdapter)adapter;
                }
            }
            return null;
        }

        public ValidationAdapter(@NonNull MetaModelManager metaModelManager) {
            this.metaModelManager = metaModelManager;
            this.environmentFactory = new PivotEnvironmentFactory(null, metaModelManager);
            this.rootEnvironment = this.environmentFactory.createEnvironment();
        }

        @NonNull
        public MetaModelManager getMetaModelManager() {
            return this.metaModelManager;
        }

        public boolean validate(@NonNull EClassifier eClassifier, @NonNull Object object, DiagnosticChain diagnostics, Map<Object, Object> context) {
            boolean allOk = true;
            Type type = this.metaModelManager.getPivotOfEcore(Type.class, (EObject)eClassifier);
            if (type != null) {
                for (Constraint constraint : this.metaModelManager.getAllInvariants(type)) {
                    String message;
                    int severity;
                    block13: {
                        String constraintName = constraint.getName();
                        OpaqueExpression specification = constraint.getSpecification();
                        if (specification == null) continue;
                        ExpressionInOCL query = null;
                        query = specification instanceof ExpressionInOCL ? (ExpressionInOCL)specification : PivotUtil.getExpressionInOCL((NamedElement)type, specification);
                        if (query == null) continue;
                        Variable contextVariable = query.getContextVariable();
                        OCLExpression bodyExpression = query.getBodyExpression();
                        if (contextVariable == null || bodyExpression == null) continue;
                        EvaluationEnvironment evaluationEnvironment = this.environmentFactory.createEvaluationEnvironment();
                        Object value = this.metaModelManager.getIdResolver().boxedValueOf(object);
                        evaluationEnvironment.add(contextVariable, value);
                        DomainModelManager extents = evaluationEnvironment.createModelManager(object);
                        EvaluationVisitor evaluationVisitor = this.environmentFactory.createEvaluationVisitor(this.rootEnvironment, evaluationEnvironment, extents);
                        severity = 4;
                        message = null;
                        if (query.getType() != evaluationVisitor.getMetaModelManager().getBooleanType()) {
                            String objectLabel = DomainUtil.getLabel((EClassifier)eClassifier, (Object)object, context);
                            message = DomainUtil.bind((String)OCLMessages.ValidationConstraintIsNotBoolean_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(specification), constraintName, objectLabel});
                        }
                        try {
                            Object expressionResult = query.accept(evaluationVisitor);
                            boolean isOk = false;
                            if (expressionResult != null) {
                                isOk = ValuesUtil.asBoolean((Object)expressionResult);
                                severity = 2;
                            }
                            if (isOk) break block13;
                            String objectLabel = DomainUtil.getLabel((EClassifier)eClassifier, (Object)object, context);
                            OCLExpression messageExpression = query.getMessageExpression();
                            if (messageExpression != null) {
                                try {
                                    Object messageResult = messageExpression.accept(evaluationVisitor);
                                    if (messageResult != null) {
                                        message = ValuesUtil.asString((Object)messageResult);
                                    }
                                }
                                catch (InvalidValueException e) {
                                    message = DomainUtil.bind((String)OCLMessages.ValidationMessageIsNotString_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(specification), constraintName, objectLabel});
                                    severity = 4;
                                }
                                catch (Exception e) {
                                    message = DomainUtil.bind((String)OCLMessages.ValidationMessageException_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(specification), constraintName, objectLabel, e.getMessage()});
                                    severity = 4;
                                }
                            }
                            if (message == null) {
                                message = DomainUtil.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(specification), constraintName, objectLabel});
                            }
                        }
                        catch (InvalidValueException e) {
                            String objectLabel = DomainUtil.getLabel((EClassifier)eClassifier, (Object)object, context);
                            message = DomainUtil.bind((String)OCLMessages.ValidationResultIsNotBoolean_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(specification), constraintName, objectLabel});
                        }
                        catch (Throwable e) {
                            String objectLabel = DomainUtil.getLabel((EClassifier)eClassifier, (Object)object, context);
                            message = DomainUtil.bind((String)OCLMessages.ValidationConstraintException_ERROR_, (Object[])new Object[]{PivotUtil.getConstraintTypeName(specification), constraintName, objectLabel, e.getMessage()});
                        }
                    }
                    if (message == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore", 0, message, new Object[]{object}));
                    allOk = false;
                    if (severity == 4) break;
                }
            }
            return allOk;
        }
    }
}

