/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkTab;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHyperLinkTab
extends AbstractHyperLinkTab {
    protected TableViewer availableHyperLinkViewer;
    protected Button defaultHRight;
    protected Button defaultHleft;
    protected Button defaultHup;
    protected Button defaultHdown;
    protected TableViewer defaultHyperLinkViewer;
    protected List<HyperLinkObject> defaultHyperLinkObject = new ArrayList<HyperLinkObject>();
    protected List<HyperLinkObject> availableHyperLinkObject = new ArrayList<HyperLinkObject>();
    protected Composite defaultHyperlinkComposite;

    public DefaultHyperLinkTab() {
    }

    public DefaultHyperLinkTab(String tabId, AbstractHyperLinkHelper helper) {
        super(tabId, helper);
    }

    public List<HyperLinkObject> getDefaultHyperLinkObject() {
        return this.defaultHyperLinkObject;
    }

    @Override
    public void init(CTabFolder cTabFolder, List<HyperLinkObject> hyperlinkObjects, EObject element) {
        super.init(cTabFolder, hyperlinkObjects, element);
        CTabItem tbtmDefaultsHyperlinks = new CTabItem(cTabFolder, 0);
        tbtmDefaultsHyperlinks.setText(Messages.DefaultHyperLinkTab_DefaultHyperlinks);
        this.defaultHyperlinkComposite = new Composite((Composite)cTabFolder, 0);
        this.defaultHyperlinkComposite.setBackgroundMode(1);
        this.defaultHyperlinkComposite.setBackground(this.defaultHyperlinkComposite.getDisplay().getSystemColor(1));
        this.defaultHyperlinkComposite.setLayoutData((Object)new GridData(1808));
        this.defaultHyperlinkComposite.setLayout((Layout)new GridLayout(4, false));
        Composite availableHyperlinks = new Composite(this.defaultHyperlinkComposite, 0);
        availableHyperlinks.setLayout((Layout)new GridLayout(1, true));
        availableHyperlinks.setLayoutData((Object)new GridData(1808));
        Composite addRemoveButtonsComposite = new Composite(this.defaultHyperlinkComposite, 0);
        addRemoveButtonsComposite.setLayout((Layout)new GridLayout(1, true));
        addRemoveButtonsComposite.setLayoutData((Object)new GridData(4));
        Composite defaultHyperlinks = new Composite(this.defaultHyperlinkComposite, 0);
        defaultHyperlinks.setLayout((Layout)new GridLayout(1, true));
        defaultHyperlinks.setLayoutData((Object)new GridData(1808));
        Composite upDownButtonsComposite = new Composite(this.defaultHyperlinkComposite, 0);
        upDownButtonsComposite.setLayout((Layout)new GridLayout(1, true));
        upDownButtonsComposite.setLayoutData((Object)new GridData(4));
        tbtmDefaultsHyperlinks.setControl((Control)this.defaultHyperlinkComposite);
        Label lblHyperlinks = new Label(availableHyperlinks, 0);
        lblHyperlinks.setText(Messages.DefaultHyperLinkTab_HyperLinks);
        Label lblDefaultHyperlinksby = new Label(defaultHyperlinks, 0);
        lblDefaultHyperlinksby.setText(Messages.DefaultHyperLinkTab_DefaultHyperLinks);
        Table availableHyperLink = new Table(availableHyperlinks, 67584);
        availableHyperLink.setLayoutData((Object)new GridData(1808));
        this.defaultHRight = new Button(addRemoveButtonsComposite, 0);
        this.defaultHRight.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (DefaultHyperLinkTab.this.availableHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.availableHyperLinkViewer.getSelection() instanceof IStructuredSelection) {
                    HyperLinkObject hyperlinkObjectToMove = (HyperLinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.availableHyperLinkViewer.getSelection()).getFirstElement();
                    hyperlinkObjectToMove.setIsDefault(true);
                    DefaultHyperLinkTab.this.availableHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.add(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.defaultHRight.setToolTipText("Set default hyperlink");
        this.defaultHleft = new Button(addRemoveButtonsComposite, 0);
        this.defaultHleft.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() instanceof IStructuredSelection) {
                    HyperLinkObject hyperlinkObjectToMove = (HyperLinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection()).getFirstElement();
                    hyperlinkObjectToMove.setIsDefault(false);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.availableHyperLinkObject.add(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.defaultHleft.setToolTipText("Remove default hyperlink");
        Table defaultHyperLink = new Table(defaultHyperlinks, 67584);
        defaultHyperLink.setLayoutData((Object)new GridData(1808));
        this.defaultHup = new Button(upDownButtonsComposite, 0);
        this.defaultHup.setToolTipText("Move default hyperlink up");
        this.defaultHup.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                HyperLinkObject hyperlinkObjectToMove;
                int index;
                if (DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() instanceof IStructuredSelection && (index = DefaultHyperLinkTab.this.defaultHyperLinkObject.indexOf(hyperlinkObjectToMove = (HyperLinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection()).getFirstElement())) > 0) {
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.add(index - 1, hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.defaultHdown = new Button(upDownButtonsComposite, 0);
        this.defaultHdown.setToolTipText("Move default hyperlink down");
        this.defaultHdown.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                HyperLinkObject hyperlinkObjectToMove;
                int index;
                if (DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() != null && DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection() instanceof IStructuredSelection && (index = DefaultHyperLinkTab.this.defaultHyperLinkObject.indexOf(hyperlinkObjectToMove = (HyperLinkObject)((IStructuredSelection)DefaultHyperLinkTab.this.defaultHyperLinkViewer.getSelection()).getFirstElement())) < DefaultHyperLinkTab.this.defaultHyperLinkObject.size() - 1) {
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.remove(hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.defaultHyperLinkObject.add(index + 1, hyperlinkObjectToMove);
                    DefaultHyperLinkTab.this.refresh();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.defaultHdown.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/ArrowDown_16x16.gif").createImage());
        this.defaultHup.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/ArrowUp_16x16.gif").createImage());
        this.defaultHleft.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/ArrowLeft_16x16.gif").createImage());
        this.defaultHRight.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/ArrowRight_16x16.gif").createImage());
        EObject contextElement = EMFHelper.getEObject((Object)element);
        LabelProvider provider = null;
        if (contextElement != null) {
            try {
                provider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)contextElement)).getLabelProvider();
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        if (provider == null) {
            provider = new LabelProvider();
        }
        this.availableHyperLinkViewer = new TableViewer(availableHyperLink);
        this.availableHyperLinkViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.availableHyperLinkViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.availableHyperLinkViewer.setInput(hyperlinkObjects);
        this.defaultHyperLinkViewer = new TableViewer(defaultHyperLink);
        this.defaultHyperLinkViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.defaultHyperLinkViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
    }

    protected Composite getMainComposite() {
        return this.defaultHyperlinkComposite;
    }

    protected void refresh() {
        this.availableHyperLinkViewer.setInput(this.availableHyperLinkObject);
        this.defaultHyperLinkViewer.setInput(this.defaultHyperLinkObject);
    }

    @Override
    public void setInput(List<HyperLinkObject> hyperLinkObjectList) {
        this.defaultHyperLinkObject.clear();
        this.availableHyperLinkObject.clear();
        for (HyperLinkObject hyperlinkObject : hyperLinkObjectList) {
            if (hyperlinkObject.getIsDefault()) {
                this.defaultHyperLinkObject.add(hyperlinkObject);
                continue;
            }
            this.availableHyperLinkObject.add(hyperlinkObject);
        }
        this.refresh();
    }
}

