/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IModelGenerator;
import org.eclipse.papyrus.extensionpoints.editors.ui.ErrorAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingContext;

public class AntlrReconcileStrategy
implements IReconcilingStrategy {
    private static final IContentType TEXT_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    private ISourceViewer viewer;
    private IDocument document;
    private IProgressMonitor progressMonitor;
    private SpellingContext fSpellingContext;
    private ProblemCollector problemCollector;
    private IModelGenerator modelGenerator;

    public AntlrReconcileStrategy(ISourceViewer viewer, IModelGenerator modelGenerator) {
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
        this.modelGenerator = modelGenerator;
        this.fSpellingContext = new SpellingContext();
        this.fSpellingContext.setContentType(this.getContentType());
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.document.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile((IRegion)new Region(0, this.document.getLength()));
    }

    public void reconcile(final IRegion region) {
        if (this.getAnnotationModel() == null) {
            return;
        }
        try {
            this.problemCollector.beginCollecting();
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    String text = AntlrReconcileStrategy.this.document.get(region.getOffset(), region.getLength());
                    IStatus status = AntlrReconcileStrategy.this.modelGenerator.validate(text);
                    if (!status.isOK()) {
                        if (!status.isMultiStatus()) {
                            AntlrReconcileStrategy.this.problemCollector.accept(status);
                        } else {
                            IStatus[] children;
                            IStatus[] iStatusArray = children = ((MultiStatus)status).getChildren();
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IStatus child = iStatusArray[n2];
                                AntlrReconcileStrategy.this.problemCollector.accept(child);
                                ++n2;
                            }
                        }
                    }
                }

                public void handleException(Throwable x) {
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        finally {
            this.problemCollector.endCollecting();
        }
    }

    protected IContentType getContentType() {
        return TEXT_CONTENT_TYPE;
    }

    protected final IDocument getDocument() {
        return this.document;
    }

    public void setDocument(IDocument document) {
        this.document = document;
        this.problemCollector = this.createProblemCollector();
    }

    protected ProblemCollector createProblemCollector() {
        IAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return null;
        }
        return new ProblemCollector(model);
    }

    public final void setProgressMonitor(IProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    protected IAnnotationModel getAnnotationModel() {
        return this.viewer.getAnnotationModel();
    }

    private class ProblemCollector {
        private IAnnotationModel fAnnotationModel;
        private Map fAddAnnotations;
        private Object fLockObject;

        public ProblemCollector(IAnnotationModel annotationModel) {
            Assert.isLegal((annotationModel != null ? 1 : 0) != 0);
            this.fAnnotationModel = annotationModel;
            this.fLockObject = this.fAnnotationModel instanceof ISynchronizable ? ((ISynchronizable)this.fAnnotationModel).getLockObject() : this.fAnnotationModel;
        }

        public void accept(Throwable exception) {
            if (exception instanceof RecognitionException) {
                this.fAddAnnotations.put(new ErrorAnnotation(false, exception.getLocalizedMessage()), new Position(((RecognitionException)exception).token.getCharPositionInLine(), ((RecognitionException)exception).token.getText().length()));
            }
        }

        public void accept(IStatus status) {
            Throwable exception = status.getException();
            if (exception instanceof MismatchedTokenException) {
                this.addErrorAnnotation((MismatchedTokenException)exception);
            } else if (exception instanceof NoViableAltException) {
                this.addErrorAnnotation((NoViableAltException)exception);
            } else if (exception instanceof RecognitionException) {
                this.addErrorAnnotation((RecognitionException)exception);
            }
        }

        protected Object addErrorAnnotation(RecognitionException exception) {
            int offset = exception.token.getCharPositionInLine();
            String value = exception.token.getText();
            int length = value != null ? value.length() : 0;
            StringBuffer buffer = new StringBuffer();
            buffer.append('[');
            buffer.append(offset);
            buffer.append(',');
            buffer.append(offset + length);
            buffer.append("] ");
            return this.fAddAnnotations.put(new ErrorAnnotation(true, String.valueOf(buffer.toString()) + exception), new Position(offset, length));
        }

        protected Object addErrorAnnotation(MismatchedTokenException exception) {
            int offset = exception.token.getCharPositionInLine();
            String value = exception.token.getText();
            int length = value != null ? value.length() : 0;
            StringBuffer buffer = new StringBuffer();
            buffer.append('[');
            buffer.append(offset);
            buffer.append(',');
            buffer.append(offset + length);
            buffer.append("] ");
            buffer.append("Found '");
            buffer.append(value);
            buffer.append("' ");
            buffer.append("excepting ");
            buffer.append(exception.expecting);
            return this.fAddAnnotations.put(new ErrorAnnotation(true, buffer.toString()), new Position(offset, length));
        }

        protected Object addErrorAnnotation(NoViableAltException exception) {
            int offset = exception.token.getCharPositionInLine();
            String value = exception.token.getText();
            int length = value != null ? value.length() : 0;
            StringBuffer buffer = new StringBuffer();
            buffer.append('[');
            buffer.append(offset);
            buffer.append(',');
            buffer.append(offset + length);
            buffer.append("] ");
            buffer.append("Found '");
            buffer.append(value);
            buffer.append("' ");
            buffer.append("Excepting ");
            buffer.append(exception.grammarDecisionDescription);
            return this.fAddAnnotations.put(new ErrorAnnotation(true, buffer.toString()), new Position(offset, length));
        }

        public void beginCollecting() {
            this.fAddAnnotations = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endCollecting() {
            ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
            Object object = this.fLockObject;
            synchronized (object) {
                Iterator iter = this.fAnnotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Annotation annotation = (Annotation)iter.next();
                    if (!"org.eclipse.ui.workbench.texteditor.error".equals(annotation.getType())) continue;
                    toRemove.add(annotation);
                }
                Annotation[] annotationsToRemove = toRemove.toArray(new Annotation[toRemove.size()]);
                if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(annotationsToRemove, this.fAddAnnotations);
                } else {
                    int i = 0;
                    while (i < annotationsToRemove.length) {
                        this.fAnnotationModel.removeAnnotation(annotationsToRemove[i]);
                        ++i;
                    }
                    for (Annotation annotation : this.fAddAnnotations.keySet()) {
                        this.fAnnotationModel.addAnnotation(annotation, (Position)this.fAddAnnotations.get(annotation));
                    }
                }
            }
            this.fAddAnnotations = null;
        }
    }
}

