/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.search.results;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.views.search.results.ResultEntry;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;

public abstract class AbstractResultEntry
extends Match {
    protected Object source;
    protected Object parent;
    protected URI uriSource;
    protected java.net.URI uriResource;
    protected static final int UNSPECIFIED = -1;

    public abstract Object elementToDisplay();

    public abstract Object openElement(OpenElementService var1) throws ServiceException, PartInitException;

    public abstract Object elementToCheckFilterFor();

    public void recursiveHierarchy(AbstractResultEntry child) {
        if (child.getSource() instanceof EObject) {
            EObject potentialParent = ((EObject)child.getSource()).eContainer();
            if (potentialParent != null) {
                ResultEntry theParent = new ResultEntry(potentialParent, (ScopeEntry)this.getElement());
                child.setParent((Object)theParent);
                this.recursiveHierarchy(theParent);
            } else {
                ResultEntry theParent = new ResultEntry(((ScopeEntry)this.getElement()).getResource(), (ScopeEntry)this.getElement());
                child.setParent((Object)theParent);
            }
        }
    }

    protected AbstractResultEntry getLastParent(AbstractResultEntry child, ScopeEntry scopeEntry) {
        if (child.getSource() instanceof EObject) {
            EObject potentialParent = ((EObject)child.getSource()).eContainer();
            ResultEntry theParent = null;
            while (potentialParent != null) {
                theParent = new ResultEntry(potentialParent, scopeEntry);
                theParent.setParent((Object)new ResultEntry(scopeEntry.getResource(), scopeEntry));
                potentialParent = potentialParent.eContainer();
            }
            if (theParent == null) {
                theParent = new ResultEntry(scopeEntry.getResource(), scopeEntry);
            }
            return theParent;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractResultEntry) {
            return obj instanceof EObject && this.getSource() instanceof EObject ? EcoreUtil.equals((EObject)((EObject)this.getSource()), (EObject)((EObject)obj)) && ((AbstractResultEntry)((Object)obj)).getOffset() == this.getOffset() && ((AbstractResultEntry)((Object)obj)).getLength() == this.getLength() : ((AbstractResultEntry)((Object)obj)).getSource() != null && ((AbstractResultEntry)((Object)obj)).getSource().equals(this.getSource()) && ((AbstractResultEntry)((Object)obj)).getOffset() == this.getOffset() && ((AbstractResultEntry)((Object)obj)).getLength() == this.getLength();
        }
        return super.equals(obj);
    }

    public AbstractResultEntry(int offset, int lenght, Object source, ScopeEntry scopeEntry) {
        super((Object)scopeEntry, offset, lenght);
        if (source instanceof EObject) {
            this.uriSource = EcoreUtil.getURI((EObject)((EObject)source));
        } else if (source instanceof IResource) {
            this.uriResource = ((IResource)source).getLocationURI();
        }
    }

    public Object getSource() {
        if (this.uriSource != null) {
            ModelSet resSet = ((ScopeEntry)this.getElement()).getModelSet();
            return resSet.getEObject(this.uriSource, true);
        }
        if (this.uriResource != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path path = new Path(this.uriResource.getPath());
            return root.getFile((IPath)path);
        }
        return null;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "(" + super.hashCode() + ") : source -> " + this.source;
    }
}

