/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.internal.ui.actions.EditingDomainAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;

public class ReloadObjectsAction
extends EditingDomainAction {
    public static final String ID = "reload-objects";
    private static final String TITLE = Messages.getString("ReloadObjectsAction.1");
    private List<InternalCDOObject> objects = new ArrayList<InternalCDOObject>();

    public ReloadObjectsAction() {
        super(TITLE);
        this.setId(ID);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.objects.clear();
        if (selection != null) {
            for (Object object : selection) {
                if (!(object instanceof InternalCDOObject)) continue;
                this.objects.add((InternalCDOObject)object);
            }
        }
        this.update();
    }

    public void update() {
        this.setEnabled(!this.objects.isEmpty());
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        if (!this.objects.isEmpty()) {
            InternalCDOObject[] array = this.objects.toArray(new InternalCDOObject[this.objects.size()]);
            CDOStateMachine.INSTANCE.reload(array);
            IWorkbenchPage page = this.getPage();
            if (page != null) {
                InternalCDOView view = array[0].cdoView();
                CDOEditorUtil.refreshEditors(page, (CDOView)view);
            }
        }
    }
}

