/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageTypeRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.internal.ui.actions.CloseSessionAction;
import org.eclipse.emf.cdo.internal.ui.actions.CloseViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.CommitTransactionAction;
import org.eclipse.emf.cdo.internal.ui.actions.CreateBranchAction;
import org.eclipse.emf.cdo.internal.ui.actions.DisableViewDurabilityAction;
import org.eclipse.emf.cdo.internal.ui.actions.EnableViewDurabilityAction;
import org.eclipse.emf.cdo.internal.ui.actions.ExportResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.ImportResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.LoadResourceAction;
import org.eclipse.emf.cdo.internal.ui.actions.ManagePackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.NewResourceNodeAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenAuditAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenDurableViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenTransactionAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterSinglePackageAction;
import org.eclipse.emf.cdo.internal.ui.actions.ReloadViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.RollbackTransactionAction;
import org.eclipse.emf.cdo.internal.ui.actions.SwitchTargetAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOItemProvider
extends ContainerItemProvider<IContainer<Object>> {
    private static final IEditorRegistry EDITOR_REGISTRY = PlatformUI.getWorkbench().getEditorRegistry();
    private IPropertyListener editorRegistryListener;
    private ResourceManager resourceManager;
    private IWorkbenchPage page;
    private boolean mergeMainBranchWithSession;

    public CDOItemProvider(IWorkbenchPage page, IElementFilter rootElementFilter) {
        super(rootElementFilter);
        this.page = page;
    }

    public CDOItemProvider(IWorkbenchPage page) {
        this(page, null);
    }

    public void dispose() {
        if (this.editorRegistryListener != null) {
            EDITOR_REGISTRY.removePropertyListener(this.editorRegistryListener);
            this.resourceManager = null;
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.dispose();
    }

    public boolean isMergeMainBranchWithSession() {
        return this.mergeMainBranchWithSession;
    }

    public void setMergeMainBranchWithSession(boolean mergeMainBranchWithSession) {
        if (this.mergeMainBranchWithSession != mergeMainBranchWithSession) {
            this.mergeMainBranchWithSession = mergeMainBranchWithSession;
            this.refreshViewer(true);
        }
    }

    public Object[] getChildren(Object element) {
        if (element instanceof CDOBranchManager) {
            return new Object[]{((CDOBranchManager)element).getMainBranch()};
        }
        if (element instanceof CDOBranch) {
            return this.getChildren((CDOBranch)element);
        }
        if (this.mergeMainBranchWithSession && element instanceof CDOSession) {
            return this.getChildren(((CDOSession)element).getBranchManager().getMainBranch());
        }
        if (element instanceof CDOResourceFolder) {
            return ((CDOResourceFolder)element).getNodes().toArray();
        }
        return super.getChildren(element);
    }

    protected Object[] getChildren(CDOBranch branch) {
        Object[] branches = branch.getBranches();
        if (!this.mergeMainBranchWithSession) {
            return branch.getBranches();
        }
        Object[] views = this.getViews(branch);
        if (views.length == 0) {
            return branches;
        }
        if (branches.length == 0) {
            return views;
        }
        Object[] children = new Object[branches.length + views.length];
        System.arraycopy(branches, 0, children, 0, branches.length);
        System.arraycopy(views, 0, children, branches.length, views.length);
        return children;
    }

    private Object[] getViews(CDOBranch branch) {
        CDOSession session = CDOUtil.getSession((Object)branch);
        if (session != null) {
            return session.getViews(branch);
        }
        return NO_ELEMENTS;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof CDOBranchManager) {
            return true;
        }
        if (element instanceof CDOBranch) {
            return this.hasChildren((CDOBranch)element);
        }
        if (element instanceof CDOSession && this.mergeMainBranchWithSession) {
            return this.hasChildren(((CDOSession)element).getBranchManager().getMainBranch());
        }
        if (element instanceof CDOResourceFolder) {
            return !((CDOResourceFolder)element).getNodes().isEmpty();
        }
        return super.hasChildren(element);
    }

    protected boolean hasChildren(CDOBranch branch) {
        if (!branch.isEmpty()) {
            return true;
        }
        Object[] views = this.getViews(branch);
        return views.length != 0;
    }

    public Object getParent(Object element) {
        if (element instanceof CDOBranch) {
            CDOBranch branch = (CDOBranch)element;
            if (branch.isMainBranch()) {
                if (this.mergeMainBranchWithSession) {
                    return CDOUtil.getSession((Object)branch);
                }
                return branch.getBranchManager();
            }
            return branch.getBase().getBranch();
        }
        if (element instanceof CDOResourceNode) {
            CDOResourceNode node = (CDOResourceNode)element;
            CDOResourceNode parent = (CDOResourceNode)node.eContainer();
            if (parent == null || parent.isRoot()) {
                return node.cdoView();
            }
            return parent;
        }
        if (element instanceof CDOView) {
            CDOView view = (CDOView)element;
            CDOBranch branch = view.getBranch();
            if (branch.isMainBranch() || !this.mergeMainBranchWithSession) {
                return view.getSession();
            }
            return branch;
        }
        return super.getParent(element);
    }

    public String getText(Object obj) {
        if (obj instanceof CDOBranch) {
            return ((CDOBranch)obj).getName();
        }
        if (obj instanceof CDOResourceNode) {
            return ((CDOResourceNode)obj).getName();
        }
        return super.getText(obj);
    }

    public Image getImage(Object obj) {
        if (obj instanceof CDOSession) {
            CDOSession session = (CDOSession)obj;
            CDOCommonRepository.State state = session.getRepositoryInfo().getState();
            switch (state) {
                case ONLINE: {
                    return SharedIcons.getImage((String)"obj16/cdo_session.gif");
                }
                case SYNCING: {
                    return SharedIcons.getImage((String)"obj16/cdo_session_syncing.gif");
                }
                case OFFLINE: {
                    return SharedIcons.getImage((String)"obj16/cdo_session_offline.gif");
                }
            }
        }
        if (obj instanceof CDOView) {
            CDOView view = (CDOView)obj;
            return CDOItemProvider.getViewImage(view);
        }
        if (obj instanceof CDOBranch) {
            return SharedIcons.getImage((String)"obj16/branch.png");
        }
        if (obj instanceof CDOResourceFolder) {
            return SharedIcons.getImage((String)"obj16/CDOResourceFolder.gif");
        }
        if (obj instanceof CDOResourceLeaf) {
            String name = ((CDOResourceLeaf)obj).getName();
            Image image = this.getWorkbenchImage(name);
            if (image != null) {
                return image;
            }
            if (obj instanceof CDOResource) {
                return SharedIcons.getImage((String)"obj16/CDOResource.gif");
            }
            if (obj instanceof CDOTextResource) {
                return SharedIcons.getImage((String)"obj16/CDOTextResource.gif");
            }
            if (obj instanceof CDOBinaryResource) {
                return SharedIcons.getImage((String)"obj16/CDOBinaryResource.gif");
            }
        }
        return super.getImage(obj);
    }

    protected Image getWorkbenchImage(String name) {
        ImageDescriptor imageDescriptor = EDITOR_REGISTRY.getImageDescriptor(name);
        if (imageDescriptor != null) {
            if (this.editorRegistryListener == null) {
                this.editorRegistryListener = new EditorRegistryListener(this);
                EDITOR_REGISTRY.addPropertyListener(this.editorRegistryListener);
            }
            ResourceManager resourceManager = this.getResourceManager();
            return (Image)resourceManager.get((DeviceResourceDescriptor)imageDescriptor);
        }
        return null;
    }

    protected ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    public Font getFont(Object obj) {
        CDOTransaction transaction;
        if (obj instanceof CDOTransaction && (transaction = (CDOTransaction)obj).isDirty()) {
            return this.getBoldFont();
        }
        return super.getFont(obj);
    }

    public void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        if (selection.size() == 1) {
            Object object = selection.getFirstElement();
            if (object instanceof CDOSession) {
                this.fillSession(manager, (CDOSession)object);
            } else if (object instanceof CDOView) {
                this.fillView(manager, (CDOView)object);
            } else if (object instanceof CDOBranch) {
                this.fillBranch(manager, (CDOBranch)object);
            } else if (object instanceof CDOResourceFolder) {
                this.fillResourceFolder(manager, (CDOResourceFolder)object);
            } else if (object instanceof CDOResourceLeaf) {
                this.fillResourceLeaf(manager, object);
            }
        }
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager, selection);
    }

    public void fillSession(IMenuManager manager, CDOSession session) {
        manager.add((IAction)new OpenTransactionAction(this.page, session));
        manager.add((IAction)new OpenViewAction(this.page, session));
        manager.add((IAction)new OpenAuditAction(this.page, session));
        manager.add((IAction)new OpenDurableViewAction(this.page, session));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ManagePackagesAction(this.page, session));
        MenuManager generatedManager = new MenuManager(Messages.getString("CDOItemProvider.8"));
        if (this.fillGenerated(generatedManager, session)) {
            manager.add((IContributionItem)generatedManager);
        }
        if (session.getRepositoryInfo().isSupportingBranches()) {
            manager.add((IContributionItem)new Separator());
            this.fillBranch(manager, session.getBranchManager().getMainBranch());
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new CloseSessionAction(this.page, session));
    }

    public boolean fillGenerated(MenuManager manager, CDOSession session) {
        ArrayList registeredURIs = new ArrayList(EPackage.Registry.INSTANCE.keySet());
        Collections.sort(registeredURIs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        boolean added = false;
        CDOPackageRegistry packageRegistry = session.getPackageRegistry();
        for (String packageURI : registeredURIs) {
            CDOPackageUnit.Type type;
            if (packageRegistry.containsKey((Object)packageURI) || (type = CDOPackageTypeRegistry.INSTANCE.lookup(packageURI)) != CDOPackageUnit.Type.NATIVE) continue;
            EPackage ePackage = packageRegistry.getEPackage(packageURI);
            if (ePackage == null) {
                ePackage = EPackage.Registry.INSTANCE.getEPackage(packageURI);
            }
            if (ePackage == null) continue;
            manager.add((IAction)new RegisterSinglePackageAction(this.page, session, packageURI));
            added = true;
        }
        return added;
    }

    public void fillView(IMenuManager manager, CDOView view) {
        if (!view.isReadOnly()) {
            CDOResource rootResource = view.getRootResource();
            manager.add((IAction)new NewResourceNodeAction(this, this.page, view, (CDOResourceNode)rootResource, NewResourceNodeAction.Type.FOLDER));
            manager.add((IAction)new NewResourceNodeAction(this, this.page, view, (CDOResourceNode)rootResource, NewResourceNodeAction.Type.MODEL));
            manager.add((IAction)new NewResourceNodeAction(this, this.page, view, (CDOResourceNode)rootResource, NewResourceNodeAction.Type.TEXT));
            manager.add((IAction)new NewResourceNodeAction(this, this.page, view, (CDOResourceNode)rootResource, NewResourceNodeAction.Type.BINARY));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new LoadResourceAction(this.page, view));
        manager.add((IAction)new ExportResourceAction(this.page, view));
        if (!view.isReadOnly()) {
            manager.add((IAction)new ImportResourceAction(this.page, view));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new CommitTransactionAction(this.page, view));
            manager.add((IAction)new RollbackTransactionAction(this.page, view));
        }
        manager.add((IContributionItem)new Separator());
        CDORepositoryInfo repositoryInfo = view.getSession().getRepositoryInfo();
        if (view.isReadOnly() && repositoryInfo.isSupportingAudits() || repositoryInfo.isSupportingBranches()) {
            manager.add((IAction)new SwitchTargetAction(this.page, view));
        }
        manager.add((IAction)new ReloadViewAction(this.page, view));
        if (view.getDurableLockingID() == null) {
            manager.add((IAction)new EnableViewDurabilityAction(this.page, view));
        } else {
            manager.add((IAction)new DisableViewDurabilityAction(this.page, view));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new CloseViewAction(this.page, view));
    }

    public void fillBranch(IMenuManager manager, CDOBranch branch) {
        CDOSession session = CDOUtil.getSession((Object)branch);
        manager.add((IAction)new CreateBranchAction(this.page, session));
    }

    public void fillResourceFolder(IMenuManager manager, CDOResourceFolder folder) {
    }

    public void fillResourceLeaf(IMenuManager manager, Object object) {
        CDOEditorUtil.populateMenu(manager, (CDOResourceLeaf)object, this.page);
        if (object instanceof CDOResource) {
            this.fillResource(manager, (CDOResource)object);
        } else if (object instanceof CDOTextResource) {
            this.fillTextResource(manager, (CDOTextResource)object);
        } else if (object instanceof CDOBinaryResource) {
            this.fillBinaryResource(manager, (CDOBinaryResource)object);
        }
    }

    public void fillResource(IMenuManager manager, CDOResource resource) {
    }

    public void fillTextResource(IMenuManager manager, CDOTextResource resource) {
    }

    public void fillBinaryResource(IMenuManager manager, CDOBinaryResource resource) {
    }

    protected void elementAdded(Object element, Object parent) {
        super.elementAdded(element, parent);
        if (element instanceof CDOSession) {
            ((CDOSession)element).addListener(new IListener(){

                public void notifyEvent(IEvent event) {
                    if (event instanceof CDOSessionInvalidationEvent) {
                        CDOItemProvider.this.refreshViewer(true);
                    }
                }
            });
        }
        if (element instanceof CDOView) {
            ((CDOView)element).addListener(new IListener(){

                public void notifyEvent(IEvent event) {
                    if (event instanceof CDOViewTargetChangedEvent) {
                        CDOItemProvider.this.refreshViewer(true);
                    }
                }
            });
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof CDOResourceFolder && e2 instanceof CDOResourceLeaf) {
            return -1;
        }
        if (e1 instanceof CDOResourceLeaf && e2 instanceof CDOResourceFolder) {
            return 1;
        }
        return super.compare(viewer, e1, e2);
    }

    public static ImageDescriptor getViewImageDescriptor(CDOView view) {
        if (view.isReadOnly()) {
            if (view.getTimeStamp() != 0L) {
                return SharedIcons.getDescriptor((String)"obj16/cdo_editor_historical.gif");
            }
            return SharedIcons.getDescriptor((String)"obj16/cdo_editor_readonly.gif");
        }
        return SharedIcons.getDescriptor((String)"obj16/cdo_editor.gif");
    }

    public static Image getViewImage(CDOView view) {
        if (view.isReadOnly()) {
            if (view.getTimeStamp() != 0L) {
                return SharedIcons.getImage((String)"obj16/cdo_editor_historical.gif");
            }
            return SharedIcons.getImage((String)"obj16/cdo_editor_readonly.gif");
        }
        return SharedIcons.getImage((String)"obj16/cdo_editor.gif");
    }

    protected static class EditorRegistryListener
    implements IPropertyListener {
        private final CDOItemProvider itemProvider;

        public EditorRegistryListener(CDOItemProvider itemProvider) {
            this.itemProvider = itemProvider;
        }

        public CDOItemProvider getItemProvider() {
            return this.itemProvider;
        }

        public void propertyChanged(Object source, int propId) {
            if (propId == 1) {
                this.itemProvider.fireLabelProviderChanged();
            }
        }
    }
}

