/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.pref.OMPreferencesChangeEvent;
import org.eclipse.swt.graphics.Image;

public class CDOLabelDecorator
implements ILabelDecorator {
    public static final String[] DECORATION_PROPOSALS = new String[]{"${element}", "${id}", "${state}", "${created}", "${revised}"};
    public static final String DEFAULT_DECORATION = String.valueOf(DECORATION_PROPOSALS[0]) + " [" + DECORATION_PROPOSALS[2] + "]";
    public static final String NO_DECORATION = DECORATION_PROPOSALS[0];
    private static final String[] DECORATION_ARGS = new String[]{"{0}", "{1}", "{2}", "{3,date} {3,time,HH:mm:ss:SSS}", "{4,date} {4,time,HH:mm:ss:SSS}"};
    public static final String DECORATOR_ID = "org.eclipse.emf.cdo.ui.CDOLabelDecorator";
    private String pattern;
    private IListener preferenceListener = new IListener(){

        public void notifyEvent(IEvent event) {
            OMPreferencesChangeEvent preferenceChangeEvent = (OMPreferencesChangeEvent)event;
            if (OM.PREF_LABEL_DECORATION.getName().equals(preferenceChangeEvent.getPreference().getName())) {
                CDOLabelDecorator.this.pattern = CDOLabelDecorator.this.parsePattern((String)preferenceChangeEvent.getNewValue());
            }
        }
    };

    public CDOLabelDecorator() {
        this.pattern = this.parsePattern((String)OM.PREF_LABEL_DECORATION.getValue());
        OM.PREFS.addListener(this.preferenceListener);
    }

    public void dispose() {
        OM.PREFS.removeListener(this.preferenceListener);
    }

    public String parsePattern(String unparsedPattern) {
        if (ObjectUtil.equals((Object)unparsedPattern, (Object)NO_DECORATION)) {
            return null;
        }
        return StringUtil.replace((String)unparsedPattern, (String[])DECORATION_PROPOSALS, (String[])DECORATION_ARGS);
    }

    public CDOLabelDecorator(String pattern) {
        this.pattern = pattern;
    }

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        try {
            if (this.pattern != null && element instanceof InternalCDOObject) {
                InternalCDOView view = ((InternalCDOObject)element).cdoView();
                InternalCDOObject obj = FSMUtil.adapt((Object)element, (CDOView)view);
                InternalCDORevision rev = obj.cdoRevision();
                long created = rev == null ? 0L : rev.getTimeStamp();
                long revised = rev == null ? 0L : rev.getRevised();
                text = MessageFormat.format(this.pattern, text, obj.cdoID(), obj.cdoState(), created, revised);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return text;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

