/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.widgets;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitHistory;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.ui.history.NetRenderer;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.ui.StructuredContentProvider;
import org.eclipse.net4j.util.ui.TableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CommitHistoryComposite
extends Composite {
    private CDOCommitHistory history;
    private IListener historyListener = new ContainerEventAdapter<CDOCommitInfo>(){

        protected void onAdded(IContainer<CDOCommitInfo> history, CDOCommitInfo commitInfo) {
            CommitHistoryComposite.this.netRenderer.addCommit(commitInfo);
        }
    };
    private TableViewer tableViewer;
    private LabelProvider labelProvider;
    private NetRenderer netRenderer;
    private Input input;

    public CommitHistoryComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        this.tableViewer = this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.tableViewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CommitHistoryComposite.this.tableViewer.getSelection();
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof CDOCommitInfo) {
                    CommitHistoryComposite.this.commitInfoChanged((CDOCommitInfo)selectedElement);
                }
            }
        });
        this.labelProvider = this.createLabelProvider();
        this.labelProvider.support(this.tableViewer);
        this.netRenderer = new NetRenderer(this.tableViewer);
    }

    public final TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public final LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public final Input getInput() {
        return this.input;
    }

    public final void setInput(Input input) {
        if (!ObjectUtil.equals((Object)((Object)this.input), (Object)((Object)input))) {
            this.input = input;
            CDOCommitHistory oldHistory = this.history;
            if (input == null) {
                this.history = CDOCommitHistory.EMPTY;
            } else {
                CDOSession session = input.getSession();
                CDOBranch branch = input.getBranch();
                CDOObject object = input.getObject();
                this.labelProvider.setLocalUserID(session.getUserID());
                this.labelProvider.setInputBranch(branch);
                this.history = this.createHistory(session, branch, object);
                this.history.setAppendingTriggerLoadElement(true);
            }
            this.history.addListener(this.historyListener);
            this.refreshLayout();
            if (oldHistory != null && oldHistory != this.history) {
                oldHistory.removeListener(this.historyListener);
                LifecycleUtil.deactivate((Object)oldHistory);
            }
        }
    }

    public void refreshLayout() {
        this.netRenderer.setInput(this.input);
        CDOCommitInfo[] elements = (CDOCommitInfo[])this.history.getElements();
        int i = 0;
        while (i < elements.length) {
            CDOCommitInfo commitInfo = elements[i];
            this.netRenderer.addCommit(commitInfo);
            ++i;
        }
        Table table = this.tableViewer.getTable();
        table.setTopIndex(0);
        this.tableViewer.setInput((Object)this.history);
        table.setTopIndex(0);
    }

    public final CDOCommitHistory getHistory() {
        return this.history;
    }

    public boolean setFocus() {
        return this.tableViewer.getTable().setFocus();
    }

    public void dispose() {
        this.input = null;
        this.history = null;
        super.dispose();
    }

    protected TableViewer createTableViewer() {
        return new TableViewer((Composite)this, 67586);
    }

    protected ContentProvider createContentProvider() {
        return new ContentProvider();
    }

    protected LabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    protected CDOCommitHistory createHistory(CDOSession session, CDOBranch branch, CDOObject object) {
        if (object == null) {
            CDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
            return commitInfoManager.getHistory((Object)branch);
        }
        return object.cdoHistory();
    }

    protected void commitInfoChanged(CDOCommitInfo newCommitInfo) {
    }

    protected void doubleClicked(CDOCommitInfo commitInfo) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContentProvider
    extends StructuredContentProvider<CDOCommitHistory> {
        public Object[] getElements(Object inputElement) {
            return ((CDOCommitHistory)inputElement).getElements();
        }

        protected void connectInput(CDOCommitHistory history) {
            history.addListener((IListener)this);
        }

        protected void disconnectInput(CDOCommitHistory history) {
            history.removeListener((IListener)this);
        }
    }

    private final class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)CommitHistoryComposite.this.tableViewer.getSelection();
            CDOCommitInfo commitInfo = (CDOCommitInfo)selection.getFirstElement();
            if (commitInfo != null) {
                if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                    CommitHistoryComposite.this.history.triggerLoad((CDOCommitInfoHandler)new RevealElementHandler());
                } else {
                    CommitHistoryComposite.this.doubleClicked(commitInfo);
                }
            }
        }
    }

    public static class Input
    extends Notifier
    implements ILifecycle {
        private IListener lifecycleListener = new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof ILifecycleEvent) {
                    ILifecycleEvent.Kind kind = ((ILifecycleEvent)event).getKind();
                    if (kind == ILifecycleEvent.Kind.DEACTIVATED) {
                        Input.this.deactivate();
                    }
                    Input.this.fireEvent((IEvent)new LifecycleEvent((ILifecycle)Input.this, kind));
                }
            }
        };
        private final CDOSession session;
        private final CDOBranch branch;
        private final CDOObject object;

        public Input(Object delegate) {
            CDOView view;
            EObject eObject;
            CDOObject cdoObject;
            if (delegate instanceof CDOSession) {
                this.session = (CDOSession)delegate;
                this.branch = null;
                this.object = null;
                this.session.addListener(this.lifecycleListener);
                return;
            }
            if (delegate instanceof CDOView) {
                CDOView view2 = (CDOView)delegate;
                this.session = view2.getSession();
                this.branch = view2.getBranch();
                this.object = null;
                view2.addListener(this.lifecycleListener);
                return;
            }
            if (delegate instanceof EObject && (cdoObject = CDOUtil.getCDOObject((EObject)(eObject = (EObject)delegate))) != null && (view = cdoObject.cdoView()) != null && cdoObject.cdoState() != CDOState.NEW) {
                this.session = view.getSession();
                this.branch = view.getBranch();
                this.object = cdoObject;
                view.addListener(this.lifecycleListener);
                return;
            }
            throw new IllegalStateException("Illegal input: " + delegate);
        }

        public Input(CDOSession session, CDOBranch branch, CDOObject object) {
            this.session = session;
            this.branch = branch;
            this.object = object;
            EventUtil.addListener((Object)this.getLifecycle(), (IListener)this.lifecycleListener);
        }

        public final CDOSession getSession() {
            return this.session;
        }

        public final CDOBranch getBranch() {
            return this.branch;
        }

        public final CDOObject getObject() {
            return this.object;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
            result = 31 * result + (this.branch == null ? 0 : this.branch.hashCode());
            result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Input)) {
                return false;
            }
            Input other = (Input)((Object)obj);
            if (this.session == null ? other.session != null : !this.session.equals(other.session)) {
                return false;
            }
            if (this.branch == null ? other.branch != null : !this.branch.equals(other.branch)) {
                return false;
            }
            return this.object == other.object;
        }

        public String toString() {
            String str = "Repostory: " + this.session.getRepositoryInfo().getName();
            if (this.branch != null) {
                str = String.valueOf(str) + ", Branch: " + this.branch.getPathName();
            }
            if (this.object != null) {
                str = String.valueOf(str) + ", Object: " + this.object;
            }
            return str;
        }

        public void activate() throws LifecycleException {
        }

        public Exception deactivate() {
            EventUtil.removeListener((Object)this.getLifecycle(), (IListener)this.lifecycleListener);
            return null;
        }

        public LifecycleState getLifecycleState() {
            Object object = this.getLifecycle();
            return LifecycleUtil.getLifecycleState((Object)object);
        }

        public boolean isActive() {
            Object object = this.getLifecycle();
            return LifecycleUtil.isActive((Object)object);
        }

        protected final Object getLifecycle() {
            if (this.object != null) {
                return this.object.cdoView();
            }
            return this.session;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LabelProvider
    extends TableLabelProvider<CDOCommitInfo> {
        private static final ImageDescriptor COMMIT = SharedIcons.getDescriptor((String)"obj16/commit.gif");
        private static final ImageDescriptor PERSON = SharedIcons.getDescriptor((String)"obj16/person.gif");
        private static final ImageDescriptor PERSON_ME = SharedIcons.getDescriptor((String)"obj16/person-me.gif");
        private static final ImageDescriptor BRANCH = SharedIcons.getDescriptor((String)"obj16/branch.png");
        private static final ImageDescriptor BRANCH_GRAY = SharedIcons.getDescriptor((String)"obj16/branch-gray.png");
        private String localUserID;
        private CDOBranch inputBranch;
        private boolean formatTimeStamps = true;

        public LabelProvider() {
            this.addColumn((TableLabelProvider.Column)new TableLabelProvider.Column<CDOCommitInfo>("Time", 160){

                public String getText(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return "";
                    }
                    if (LabelProvider.this.formatTimeStamps) {
                        return CDOCommonUtil.formatTimeStamp((long)commitInfo.getTimeStamp());
                    }
                    return "" + commitInfo.getTimeStamp();
                }

                public Image getImage(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return null;
                    }
                    return (Image)LabelProvider.this.getResource((DeviceResourceDescriptor)COMMIT);
                }
            });
            this.addColumn((TableLabelProvider.Column)new TableLabelProvider.Column<CDOCommitInfo>("Comment", 250){

                public String getText(CDOCommitInfo commitInfo) {
                    return commitInfo.getComment();
                }
            });
            this.addColumn((TableLabelProvider.Column)new TableLabelProvider.Column<CDOCommitInfo>("User", 120){

                public String getText(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return "";
                    }
                    return commitInfo.getUserID();
                }

                public Image getImage(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return null;
                    }
                    String userID = commitInfo.getUserID();
                    if (userID != null) {
                        if (userID.equals(LabelProvider.this.localUserID)) {
                            return (Image)LabelProvider.this.getResource((DeviceResourceDescriptor)PERSON_ME);
                        }
                        return (Image)LabelProvider.this.getResource((DeviceResourceDescriptor)PERSON);
                    }
                    return null;
                }
            });
            this.addColumn((TableLabelProvider.Column)new TableLabelProvider.Column<CDOCommitInfo>("Branch", 160){

                public String getText(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return "";
                    }
                    return commitInfo.getBranch().getPathName();
                }

                public Image getImage(CDOCommitInfo commitInfo) {
                    if (commitInfo instanceof CDOCommitHistory.TriggerLoadElement) {
                        return null;
                    }
                    if (LabelProvider.this.inputBranch == null || LabelProvider.this.inputBranch == commitInfo.getBranch()) {
                        return (Image)LabelProvider.this.getResource((DeviceResourceDescriptor)BRANCH);
                    }
                    return (Image)LabelProvider.this.getResource((DeviceResourceDescriptor)BRANCH_GRAY);
                }
            });
        }

        public String getLocalUserID() {
            return this.localUserID;
        }

        public void setLocalUserID(String localUserID) {
            this.localUserID = localUserID;
        }

        public CDOBranch getInputBranch() {
            return this.inputBranch;
        }

        public void setInputBranch(CDOBranch inputBranch) {
            this.inputBranch = inputBranch;
        }

        public boolean isFormatTimeStamps() {
            return this.formatTimeStamps;
        }

        public void setFormatTimeStamps(boolean formatTimeStamps) {
            this.formatTimeStamps = formatTimeStamps;
        }
    }

    private final class RevealElementHandler
    implements CDOCommitInfoHandler {
        private RevealElementHandler() {
        }

        public void handleCommitInfo(final CDOCommitInfo commitInfo) {
            CommitHistoryComposite.this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CommitHistoryComposite.this.tableViewer.reveal((Object)commitInfo);
                }
            });
        }
    }
}

