/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.parameter.xtext.ui.contributions;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ParameterUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterEffectKind;
import org.eclipse.uml2.uml.Type;

public class UMLParameterEditorUtil
extends ParameterUtil {
    public static String getLabel(Parameter parameter) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)parameter));
        buffer.append(" ");
        buffer.append(parameter.getDirection().getLiteral());
        buffer.append(" ");
        if (parameter.getName() != null) {
            buffer.append(parameter.getName());
        }
        if (parameter.getType() != null) {
            EList namespaces = parameter.allNamespaces();
            buffer.append(" : " + UMLParameterEditorUtil.getTypeLabel(parameter.getType(), (Namespace)namespaces.get(namespaces.size() - 1)));
        } else {
            buffer.append(" : <Undefined>");
        }
        String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)parameter);
        if (!multiplicity.trim().equals("[1]")) {
            buffer.append(multiplicity);
        }
        if (parameter.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(parameter.getDefault());
        }
        buffer.append(ParameterUtil.getModifiersAsString((Parameter)parameter, (boolean)false));
        buffer.append(UMLParameterEditorUtil.getEffectAsString(parameter));
        return buffer.toString();
    }

    public static String getEffectAsString(Parameter parameter) {
        StringBuffer buffer = new StringBuffer();
        ParameterEffectKind effect = parameter.getEffect();
        buffer.append(effect.toString());
        if (!buffer.toString().equals("")) {
            buffer.insert(0, "{effect: ");
            buffer.append("}");
        }
        return buffer.toString();
    }

    public static String getTypeLabel(Type type, Namespace model) {
        String label = "";
        ArrayList importedPackages = new ArrayList(model.getImportedPackages());
        ArrayList<Package> visitedPackages = new ArrayList<Package>();
        Package currentPackage = type.getNearestPackage();
        boolean rootFound = false;
        while (currentPackage != null && !rootFound) {
            visitedPackages.add(currentPackage);
            if (importedPackages.contains(currentPackage) || currentPackage == model) {
                rootFound = true;
            }
            Element owner = currentPackage.getOwner();
            while (owner != null && !(owner instanceof Package)) {
                owner = owner.getOwner();
            }
            Package package_ = currentPackage = owner != null ? (Package)owner : null;
        }
        int i = visitedPackages.size() - 1;
        while (i >= 0) {
            label = String.valueOf(label) + ((Package)visitedPackages.get(i)).getName() + "::";
            --i;
        }
        return String.valueOf(label) + type.getName();
    }
}

