/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.team;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.cdo.internal.team.RepositoryProject;
import org.eclipse.emf.cdo.internal.team.RepositoryTeamProvider;
import org.eclipse.emf.cdo.internal.team.bundle.OM;
import org.eclipse.emf.cdo.team.IRepositoryManager;
import org.eclipse.emf.cdo.team.IRepositoryProject;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManager
extends Container<IRepositoryProject>
implements IRepositoryManager,
IResourceChangeListener {
    public static final RepositoryManager INSTANCE = new RepositoryManager();
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, RepositoryManager.class);
    private Map<IProject, RepositoryProject> map = new HashMap<IProject, RepositoryProject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRepositoryProject addElement(IProject project) {
        RepositoryProject element = new RepositoryProject(project);
        Map<IProject, RepositoryProject> map = this.map;
        synchronized (map) {
            this.map.put(project, element);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Added repository for project {0}", new Object[]{project.getName()});
        }
        this.fireElementAddedEvent(element);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(IProject project) {
        RepositoryProject element = null;
        Map<IProject, RepositoryProject> map = this.map;
        synchronized (map) {
            element = this.map.remove(project);
        }
        if (element != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Removed repository for project {0}", new Object[]{project.getName()});
            }
            this.fireElementRemovedEvent(element);
            element.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryProject getElement(IProject project) {
        Map<IProject, RepositoryProject> map = this.map;
        synchronized (map) {
            return this.map.get(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryProject[] getElements() {
        Map<IProject, RepositoryProject> map = this.map;
        synchronized (map) {
            return this.map.values().toArray(new RepositoryProject[this.map.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<IProject, RepositoryProject> map = this.map;
        synchronized (map) {
            return this.map.isEmpty();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                if (child instanceof IProject) {
                    IProject project = (IProject)child;
                    switch (delta.getKind()) {
                        case 16384: {
                            this.resourceChangedOpen(project);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void resourceChangedOpen(IProject project) {
        if (project.isOpen()) {
            if (RepositoryTeamProvider.isMapped(project)) {
                this.addElement(project);
            }
        } else {
            this.removeElement(project);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (RepositoryTeamProvider.isMapped(project)) {
                this.addElement(project);
            }
            ++n2;
        }
    }
}

