/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class RebaseOperation
implements IEGitOperation {
    private final Repository repository;
    private final Ref ref;
    private final RebaseCommand.Operation operation;
    private RebaseResult result;

    public RebaseOperation(Repository repository, Ref ref) {
        this.repository = repository;
        this.operation = RebaseCommand.Operation.BEGIN;
        this.ref = ref;
    }

    public RebaseOperation(Repository repository, RebaseCommand.Operation operation) {
        this.repository = repository;
        this.operation = operation;
        this.ref = null;
    }

    public void execute(IProgressMonitor m) throws CoreException {
        if (this.result != null) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), CoreText.OperationAlreadyExecuted));
        }
        Object monitor = m == null ? new NullProgressMonitor() : m;
        final IProject[] validProjects = ProjectUtil.getValidOpenProjects(this.repository);
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                RebaseCommand cmd = new Git(RebaseOperation.this.repository).rebase().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(actMonitor));
                try {
                    try {
                        if (RebaseOperation.this.operation == RebaseCommand.Operation.BEGIN) {
                            RebaseOperation.this.result = cmd.setUpstream(RebaseOperation.this.ref.getName()).call();
                        } else {
                            RebaseOperation.this.result = cmd.setOperation(RebaseOperation.this.operation).call();
                        }
                    }
                    catch (NoHeadException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                    catch (RefNotFoundException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                    catch (JGitInternalException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                    catch (GitAPIException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                }
                finally {
                    if (RebaseOperation.this.refreshNeeded()) {
                        ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)new SubProgressMonitor(actMonitor, 1));
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, monitor);
    }

    private boolean refreshNeeded() {
        if (this.result == null) {
            return true;
        }
        return this.result.getStatus() != RebaseResult.Status.UP_TO_DATE;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public RebaseResult getResult() {
        return this.result;
    }
}

