/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.model;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.examples.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.ocl.examples.modelregistry.model.Accessor;
import org.eclipse.ocl.examples.modelregistry.model.AccessorRegistry;
import org.eclipse.ocl.examples.modelregistry.model.ModelSerialization;
import org.eclipse.ocl.examples.modelregistry.model.ProjectRegistry;
import org.eclipse.ocl.examples.modelregistry.model.Registration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHandleRegistry
implements Comparable<FileHandleRegistry> {
    private final ProjectRegistry parent;
    private final FileHandle fileHandle;
    private final AccessorClassToAccessorRegistryMap map = new AccessorClassToAccessorRegistryMap();

    public FileHandleRegistry(ProjectRegistry parent, FileHandle fileHandle) {
        this.parent = parent;
        this.fileHandle = fileHandle;
    }

    public <A extends Accessor<A>> void add(A accessor, URI ecoreURI, ModelSerialization modelSerialisation) {
        AccessorRegistry<A> registry = this.getOrCreate(accessor.getNamespace());
        registry.add(accessor, ecoreURI, modelSerialisation);
    }

    public <A extends Accessor<A>> Registration<A> add(Registration<A> registration) {
        Accessor.Namespace<A> namespace = registration.getNamespace();
        AccessorRegistry<A> registry = this.getOrCreate(namespace);
        return registry.add(registration);
    }

    @Override
    public int compareTo(FileHandleRegistry fileHandleRegistry) {
        String name1 = this.getFileHandle().getProjectRelativeName();
        if (name1 == null) {
            return -1;
        }
        String name2 = fileHandleRegistry.getFileHandle().getProjectRelativeName();
        if (name2 == null) {
            return 1;
        }
        Path path1 = new Path(name1);
        Path path2 = new Path(name2);
        int segmentCount1 = path1.segmentCount();
        int segmentCount2 = path2.segmentCount();
        int segmentCount = Math.min(segmentCount1, segmentCount2);
        int i = 0;
        while (i < segmentCount) {
            int comparison = path1.segment(i).compareTo(path2.segment(i));
            if (comparison != 0) {
                return comparison;
            }
            ++i;
        }
        return segmentCount1 - segmentCount2;
    }

    public <A extends Accessor<A>> AccessorRegistry<A> get(Accessor.Namespace<A> namespace) {
        return this.map.get(namespace);
    }

    public AccessorRegistry<?> getOrCreate(String namespaceName) {
        Accessor.Namespace<?> namespace = ModelRegistryEnvironment.getInstance().getNamespaceRegistry().getNamespace(namespaceName);
        return this.getOrCreate(namespace);
    }

    public <A extends Accessor<A>> AccessorRegistry<A> getOrCreate(Accessor.Namespace<A> namespace) {
        AccessorRegistry<A> accessorRegistry = this.map.get(namespace);
        if (accessorRegistry == null) {
            accessorRegistry = new AccessorRegistry<A>(this, namespace);
            this.map.put(namespace, accessorRegistry);
        }
        return accessorRegistry;
    }

    public Collection<Accessor.Namespace<?>> getAccessorKeys() {
        return this.map.keySet();
    }

    public int getDepth() {
        int depth = 0;
        FileHandle ancestorHandle = this.fileHandle.getParentFileHandle();
        while (ancestorHandle != null) {
            ++depth;
            ancestorHandle = ancestorHandle.getParentFileHandle();
        }
        return depth;
    }

    public FileHandle getFileHandle() {
        return this.fileHandle;
    }

    public ProjectRegistry getProjectRegistry() {
        return this.parent;
    }

    public <A extends Accessor<A>> Registration<A> getRegistration(A accessor) {
        AccessorRegistry<A> accessorRegistry = this.get(accessor.getNamespace());
        return accessorRegistry != null ? accessorRegistry.get(accessor) : null;
    }

    public Collection<AccessorRegistry<? extends Accessor<?>>> getRegistries() {
        return this.map.values();
    }

    public <A extends Accessor<A>> URI getURI(A accessor) {
        Registration<A> registration = this.getRegistration(accessor);
        return registration != null ? registration.getURI() : null;
    }

    public <A extends Accessor<A>> Registration<A> remove(Registration<A> registration) {
        Accessor.Namespace<A> namespace = registration.getNamespace();
        AccessorRegistry<A> registry = this.getOrCreate(namespace);
        return registry.remove(registration);
    }

    public String toString() {
        return this.getFileHandle().getAbsoluteName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessorClassToAccessorRegistryMap {
        private HashMap<Accessor.Namespace<?>, AccessorRegistry<? extends Accessor<?>>> map = new HashMap();

        private AccessorClassToAccessorRegistryMap() {
        }

        public <A extends Accessor<A>> AccessorRegistry<A> get(Accessor.Namespace<A> key) {
            return this.map.get(key);
        }

        public <A extends Accessor<A>> AccessorRegistry<A> put(Accessor.Namespace<A> key, AccessorRegistry<A> value) {
            return this.map.put(key, value);
        }

        public Collection<Accessor.Namespace<?>> keySet() {
            return this.map.keySet();
        }

        public Collection<AccessorRegistry<? extends Accessor<?>>> values() {
            return this.map.values();
        }
    }
}

