/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.standalone;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ocl.examples.modelregistry.environment.ProjectHandle;
import org.eclipse.ocl.examples.modelregistry.standalone.JavaFileHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectHandle
extends JavaFileHandle
implements ProjectHandle {
    private Map<String, JavaFileHandle> handles = new HashMap<String, JavaFileHandle>();
    private List<String> registryNames;
    private String rootPath = null;

    public JavaProjectHandle(String projectFile, String registryPath) throws IOException {
        this(new File(projectFile), registryPath);
        this.handles.put(this.getFile().toString(), this);
    }

    public JavaProjectHandle(File projectFile, String registryPath) throws IOException {
        super(projectFile);
        this.setRegistryName(registryPath);
        this.handles.put(this.getFile().toString(), this);
    }

    @Override
    public JavaFileHandle getFileHandle(String name) throws IOException {
        File referenceFile = this.getFile();
        if (name.startsWith("/")) {
            name = name.substring(1);
            referenceFile = this.rootPath == null ? new File(referenceFile.getParent()) : new File(this.rootPath);
        }
        File memberFile = new File(referenceFile, name);
        return this.getFileHandle(memberFile);
    }

    public JavaFileHandle getFileHandle(File file) throws IOException {
        if (file == null) {
            return null;
        }
        String canonicalFileName = JavaProjectHandle.createCanonicalFileName(file);
        JavaFileHandle handle = this.handles.get(canonicalFileName);
        if (handle == null) {
            handle = new JavaFileHandle(this, file);
            this.handles.put(handle.getFile().toString(), handle);
        }
        return handle;
    }

    @Override
    public JavaFileHandle getParentFileHandle() {
        return null;
    }

    public File getRegistryFile() {
        return new File(this.file, this.getRegistryName());
    }

    @Override
    public String getRegistryName() {
        return this.registryNames.isEmpty() ? null : this.registryNames.get(0);
    }

    public List<String> getRegistryNames() {
        return this.registryNames;
    }

    @Override
    public URI getRegistryURI() {
        if (this.registryNames.isEmpty()) {
            return null;
        }
        URI registryURI = URI.createURI((String)this.registryNames.get(0));
        URI projectURI = this.getURI();
        URI resolvedURI = registryURI.resolve(projectURI);
        return resolvedURI;
    }

    @Override
    public List<URI> getRegistryURIs() {
        ArrayList<URI> registryURIs = new ArrayList<URI>();
        for (String registryName : this.registryNames) {
            URI registryURI = URI.createURI((String)registryName);
            URI projectURI = this.getURI();
            URI resolvedURI = registryURI.resolve(projectURI);
            registryURIs.add(resolvedURI);
        }
        return registryURIs;
    }

    public String getRoot() {
        return this.rootPath;
    }

    @Override
    public URI getURI() {
        return URI.createFileURI((String)(String.valueOf(this.getFile().toString()) + "/"));
    }

    @Override
    public void refreshRegistry() {
    }

    @Override
    public void setRegistryName(String name) {
        this.registryNames = Collections.singletonList(name != null ? name : ".settings/org.eclipse.ocl.modelregistry");
    }

    public void setRegistryNames(List<String> names) {
        this.registryNames = new ArrayList<String>(names);
    }

    public void setRoot(String rootPath) {
        this.rootPath = rootPath;
    }
}

