/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.services.controlmode.util.ControlHelper;

public class IsControlledFragmentTester
extends PropertyTester {
    public static String IS_MODEL_FRAGMENT_PROP = "isFragmentModel";
    public static String ID_PARENT_LOADED = "isParentLoaded";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_MODEL_FRAGMENT_PROP.equals(property)) {
            return (Boolean)expectedValue == this.isModelFragment(receiver);
        }
        if (ID_PARENT_LOADED.equals(property)) {
            return expectedValue == this.isParentLoaded(receiver);
        }
        return false;
    }

    protected Object isParentLoaded(Object receiver) {
        EObject eObject;
        if (receiver instanceof IStructuredSelection && (eObject = IsControlledFragmentTester.getSemanticObject(((IStructuredSelection)receiver).getFirstElement())) != null) {
            if (eObject.eContainer() != null) {
                return true;
            }
            return false;
        }
        return false;
    }

    protected Object isModelFragment(Object receiver) {
        EObject eObject;
        if (receiver instanceof IStructuredSelection && (eObject = IsControlledFragmentTester.getSemanticObject(((IStructuredSelection)receiver).getFirstElement())) != null) {
            return ControlHelper.isRootControlledObject(eObject);
        }
        return false;
    }

    public static EObject getSemanticObject(Object selectedElement) {
        EObject semanticObject = null;
        if (selectedElement instanceof IAdaptable) {
            semanticObject = (EObject)((IAdaptable)selectedElement).getAdapter(EObject.class);
        }
        if (selectedElement instanceof EObject) {
            semanticObject = (EObject)selectedElement;
        }
        if (selectedElement == null || selectedElement instanceof EReference || semanticObject instanceof EReference) {
            return null;
        }
        return semanticObject;
    }
}

