/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class FunctionReferenceRule
extends WordRule {
    private StringBuffer fBuffer = new StringBuffer();
    private static final String[] functions = new String[]{"subst", "patsubst", "strip", "findstring", "filter", "filter-out", "sort", "word", "words", "wordlist", "firstword", "lastword", "dir", "notdir", "suffix", "basename", "addsuffix", "addprefix", "join", "wildcard", "realpath", "abspath", "if", "or", "and", "foreach", "call", "value", "eval", "origin", "flavor", "shell", "error", "warning", "info"};

    public FunctionReferenceRule(IToken token) {
        super((IWordDetector)new TagDetector());
        String[] stringArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            this.addWord("$(" + f, token);
            this.addWord("$$(" + f, token);
            ++n2;
        }
        this.addWord(")", token);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c == 41) {
            if (((TagDetector)this.fDetector).bracketNesting > 0) {
                TagDetector tagDetector = (TagDetector)this.fDetector;
                tagDetector.bracketNesting = tagDetector.bracketNesting - 1;
                return (IToken)this.fWords.get(")");
            }
            return this.fDefaultToken;
        }
        if (c != -1 && this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            String buffer = this.fBuffer.toString();
            IToken token = (IToken)this.fWords.get(buffer);
            if (token != null) {
                if (buffer.equals("$(call") || buffer.equals("$$(call")) {
                    if ((char)scanner.read() == ' ') {
                        while ((c = scanner.read()) == 40 || c == 41 || this.fDetector.isWordPart((char)c)) {
                        }
                    }
                    scanner.unread();
                }
                TagDetector tagDetector = (TagDetector)this.fDetector;
                tagDetector.bracketNesting = tagDetector.bracketNesting + 1;
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }

    static class TagDetector
    implements IWordDetector {
        private boolean isClosedBracket = false;
        private int bracketNesting = 0;

        TagDetector() {
        }

        public boolean isWordStart(char c) {
            boolean bl = this.isClosedBracket = c == ')';
            return this.isClosedBracket || c == '$';
        }

        public boolean isWordPart(char c) {
            return !this.isClosedBracket && (c == '$' || c == '(' || Character.isJavaIdentifierPart(c) || c == '-');
        }
    }
}

