/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.reviewdb.Account;
import java.util.ArrayList;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsPackage;

public class GerritUserRemoteFactory
extends AbstractRemoteEmfFactory<IRepository, IUser, String, AccountInfo, Account.Id, String> {
    private final AccountInfoCache cache = new AccountInfoCache(new ArrayList());

    public GerritUserRemoteFactory(GerritRemoteFactoryProvider gerritRemoteFactoryProvider) {
        super((AbstractRemoteEmfFactoryProvider)gerritRemoteFactoryProvider, ReviewsPackage.Literals.REPOSITORY__USERS, ReviewsPackage.Literals.USER__ID);
    }

    public AccountInfo pull(IRepository parent, Account.Id id, IProgressMonitor monitor) throws CoreException {
        return this.cache.get(id);
    }

    public IUser createModel(IRepository repository, AccountInfo info) {
        IUser user = IReviewsFactory.INSTANCE.createUser();
        user.setId("" + info.getId());
        repository.getUsers().add(user);
        return user;
    }

    public boolean isPullNeeded(IRepository parent, IUser user, AccountInfo remote) {
        return true;
    }

    public boolean isAsynchronous() {
        return false;
    }

    public boolean updateModel(IRepository item, IUser user, AccountInfo info) {
        String gerritEmail;
        String gerritLabel = GerritUtil.getUserLabel(info);
        boolean changed = false;
        if (!gerritLabel.equals(user.getDisplayName())) {
            user.setDisplayName(gerritLabel);
            changed = true;
        }
        if (!ObjectUtils.equals((Object)(gerritEmail = info.getPreferredEmail()), (Object)user.getEmail())) {
            user.setEmail(gerritEmail);
            changed = true;
        }
        return changed;
    }

    public Account.Id getRemoteKey(AccountInfo info) {
        return info.getId();
    }

    public String getLocalKeyForRemoteKey(Account.Id remoteKey) {
        return Integer.toString(remoteKey.get());
    }

    public AccountInfoCache getCache() {
        return this.cache;
    }

    public String getModelCurrentValue(IRepository parentObject, IUser object) {
        return String.valueOf(object.getDisplayName()) + "|" + object.getEmail() + "|" + object.getId();
    }
}

