/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.modelexplorer.handlers;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.table.modelexplorer.handlers.AbstractTableModelExplorerHandler;
import org.eclipse.papyrus.infra.table.modelexplorer.messages.Messages;
import org.eclipse.swt.widgets.Display;

public class RenameTableHandler
extends AbstractTableModelExplorerHandler {
    protected Command getCommand() {
        PapyrusTableInstance table;
        String currentName;
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        List<PapyrusTableInstance> tables = this.getSelectedTables();
        if (editingDomain != null && tables.size() == 1 && (currentName = (table = tables.get(0)).getName()) != null) {
            AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editingDomain, "RenameTableCommand", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
                    InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.RenameTableHandler_RenameAnExistingTable_Title, Messages.RenameTableHandler_NewNameMessage, currentName, null);
                    if (dialog.open() == 0) {
                        String name = dialog.getValue();
                        if (name != null && name.length() > 0) {
                            table.setName(name);
                        }
                        return CommandResult.newOKCommandResult();
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            };
            return new GMFtoEMFCommandWrapper((ICommand)cmd);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

