/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.BehavioralFeatureOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationOperations
extends BehavioralFeatureOperations {
    protected OperationOperations() {
    }

    public static boolean validateAtMostOneReturn(Operation operation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        int count = 0;
        for (Parameter ownedParameter : operation.getOwnedParameters()) {
            if (ownedParameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            ++count;
        }
        if (count > 1) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 58, UMLPlugin.INSTANCE.getString("_UI_Operation_AtMostOneReturn_diagnostic", OperationOperations.getMessageSubstitutions(context, (Object)operation)), new Object[]{operation}));
            }
        }
        return result;
    }

    public static boolean validateOnlyBodyForQuery(Operation operation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (operation.getBodyCondition() != null && !operation.isQuery()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 59, UMLPlugin.INSTANCE.getString("_UI_Operation_OnlyBodyForQuery_diagnostic", OperationOperations.getMessageSubstitutions(context, (Object)operation)), new Object[]{operation}));
            }
        }
        return result;
    }

    public static boolean isOrdered(Operation operation) {
        Parameter returnResult = operation.getReturnResult();
        return returnResult != null ? returnResult.isOrdered() : false;
    }

    public static boolean isUnique(Operation operation) {
        Parameter returnResult = operation.getReturnResult();
        return returnResult != null ? returnResult.isUnique() : true;
    }

    public static Type getType(Operation operation) {
        Parameter returnResult = operation.getReturnResult();
        return returnResult != null ? (Type)returnResult.eGet((EStructuralFeature)UMLPackage.Literals.TYPED_ELEMENT__TYPE, false) : null;
    }

    public static EList<Parameter> returnResult(Operation operation) {
        UniqueEList.FastCompare returnResult = new UniqueEList.FastCompare();
        for (Parameter ownedParameter : operation.getOwnedParameters()) {
            if (ownedParameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            returnResult.add((Object)ownedParameter);
        }
        return ECollections.unmodifiableEList((EList)returnResult);
    }

    public static int getLower(Operation operation) {
        Parameter returnResult = operation.getReturnResult();
        return returnResult != null ? returnResult.getLower() : 1;
    }

    public static int getUpper(Operation operation) {
        Parameter returnResult = operation.getReturnResult();
        return returnResult != null ? returnResult.getUpper() : 1;
    }

    public static void setIsOrdered(Operation operation, boolean newIsOrdered) {
        Parameter returnResult = operation.getReturnResult();
        if (returnResult == null) {
            returnResult = operation.createOwnedParameter(null, null);
            returnResult.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        }
        returnResult.setIsOrdered(newIsOrdered);
    }

    public static void setIsUnique(Operation operation, boolean newIsUnique) {
        Parameter returnResult = operation.getReturnResult();
        if (returnResult == null) {
            returnResult = operation.createOwnedParameter(null, null);
            returnResult.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        }
        returnResult.setIsUnique(newIsUnique);
    }

    public static void setLower(Operation operation, int newLower) {
        Parameter returnResult = operation.getReturnResult();
        if (returnResult == null) {
            returnResult = operation.createOwnedParameter(null, null);
            returnResult.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        }
        returnResult.setLower(newLower);
    }

    public static void setUpper(Operation operation, int newUpper) {
        Parameter returnResult = operation.getReturnResult();
        if (returnResult == null) {
            returnResult = operation.createOwnedParameter(null, null);
            returnResult.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        }
        returnResult.setUpper(newUpper);
    }

    public static Parameter getReturnResult(Operation operation) {
        for (Parameter ownedParameter : operation.getOwnedParameters()) {
            if (ownedParameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            return ownedParameter;
        }
        return null;
    }

    public static void setType(Operation operation, Type newType) {
        Parameter returnResult = operation.getReturnResult();
        if (returnResult == null) {
            returnResult = operation.createOwnedParameter(null, null);
            returnResult.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        }
        returnResult.setType(newType);
    }

    public static boolean isConsistentWith(Operation operation, RedefinableElement redefinee) {
        if (redefinee instanceof Operation && redefinee.isRedefinitionContextValid(operation)) {
            Operation op = (Operation)redefinee;
            EList<Parameter> ownedParameters = operation.getOwnedParameters();
            int ownedParametersSize = ownedParameters.size();
            EList<Parameter> opOwnedParameters = op.getOwnedParameters();
            EList<Parameter> returnResult = operation.returnResult();
            int returnResultSize = returnResult.size();
            EList<Parameter> opReturnResult = op.returnResult();
            if (ownedParametersSize == opOwnedParameters.size() && returnResultSize == opReturnResult.size()) {
                int i = 0;
                while (i < ownedParametersSize) {
                    Type opOwnedParameterType = ((Parameter)opOwnedParameters.get(i)).getType();
                    Type ownedParameterType = ((Parameter)ownedParameters.get(i)).getType();
                    if (opOwnedParameterType == null ? ownedParameterType != null : !opOwnedParameterType.conformsTo(ownedParameterType)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < returnResultSize) {
                    Type opReturnResultType = ((Parameter)opReturnResult.get(i)).getType();
                    Type returnResultType = ((Parameter)returnResult.get(i)).getType();
                    if (opReturnResultType == null ? returnResultType != null : !opReturnResultType.conformsTo(returnResultType)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }
}

