/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelexplorer.handler;

import java.util.LinkedList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;

public class ToggleAdvancedModelExplorerHandler
extends AbstractHandler {
    public static final String SIMPLE_UML_CUSTOMIZATION = "SimpleUML";

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IViewPart page;
        IWorkbenchPart activePart;
        CustomizationManager customizationManager = Activator.getDefault().getCustomizationManager();
        if (customizationManager != null && event.getTrigger() instanceof Event && ((Event)event.getTrigger()).widget instanceof ToolItem) {
            ToolItem item = (ToolItem)((Event)event.getTrigger()).widget;
            MetamodelView simpleUMLCustomization = CustomizationsCatalog.getInstance().getCustomization(SIMPLE_UML_CUSTOMIZATION);
            if (simpleUMLCustomization != null) {
                if (item.getSelection()) {
                    LinkedList registeredCustomizations = new LinkedList(customizationManager.getRegisteredCustomizations());
                    if (!registeredCustomizations.remove(simpleUMLCustomization)) return null;
                    customizationManager.clearCustomizations();
                    for (MetamodelView customization : registeredCustomizations) {
                        customizationManager.registerCustomization(customization);
                    }
                } else {
                    if (customizationManager.getRegisteredCustomizations().contains(simpleUMLCustomization)) {
                        return null;
                    }
                    customizationManager.registerCustomization(simpleUMLCustomization);
                }
                customizationManager.loadCustomizations();
                org.eclipse.papyrus.infra.emf.Activator.getDefault().saveCustomizationManagerState();
            }
        }
        if (!((activePart = HandlerUtil.getActivePart((ExecutionEvent)event)) instanceof ModelExplorerPageBookView) || !((page = ((ModelExplorerPageBookView)activePart).getActiveView()) instanceof CommonNavigator)) return null;
        ((CommonNavigator)page).getCommonViewer().refresh();
        return null;
    }
}

