/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainFragment;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.types.AbstractInheritance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainProperties {
    @NonNull
    protected final DomainInheritance inheritance;
    @NonNull
    protected final Map<String, DomainProperty> name2property = new HashMap<String, DomainProperty>();

    public DomainProperties(@NonNull DomainInheritance inheritance) {
        this.inheritance = inheritance;
        this.init(inheritance.getAllSuperFragments());
    }

    protected void init(@NonNull Iterable<DomainFragment> allSuperFragments) {
        for (DomainFragment fragment : allSuperFragments) {
            for (DomainProperty property : fragment.getLocalProperties()) {
                this.name2property.put(property.getName(), property);
            }
        }
    }

    @NonNull
    public Iterable<? extends DomainProperty> getAllProperties(boolean selectStatic) {
        Iterable subItOps = Iterables.filter(this.name2property.values(), (Predicate)(selectStatic ? AbstractInheritance.SELECT_STATIC_PROPERTY : AbstractInheritance.REJECT_STATIC_PROPERTY));
        return subItOps;
    }

    @Nullable
    public DomainProperty getMemberProperty(@NonNull String name) {
        return this.name2property.get(name);
    }
}

