/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class RejectIteration
extends AbstractIteration {
    @NonNull
    public static final RejectIteration INSTANCE = new RejectIteration();

    @NonNull
    public CollectionValue.Accumulator createAccumulatorValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return RejectIteration.createCollectionAccumulatorValue((CollectionTypeId)((CollectionTypeId)accumulatorTypeId));
    }

    @Nullable
    protected Object updateAccumulator(@NonNull DomainIterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal == null) {
            throw new InvalidValueException(EvaluatorMessages.UndefinedBody, new Object[]{"reject"});
        }
        if (bodyVal == Boolean.FALSE) {
            Object value = iterationManager.get();
            CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
            assert (accumulatorValue != null);
            accumulatorValue.add(value);
        }
        return CARRY_ON;
    }
}

