/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.TreeAppendableUtil;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.legacy.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class DispatchMethodCompileStrategy
implements Procedures.Procedure1<ITreeAppendable> {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TreeAppendableUtil treeAppendableUtil;
    @Inject
    private CommonTypeComputationServices services;
    private List<JvmOperation> sortedDispatchOperations;
    private JvmOperation dispatchOperation;

    protected void initialize(JvmOperation dispatchOperation, List<JvmOperation> sortedDispatchOperations) {
        this.dispatchOperation = dispatchOperation;
        this.sortedDispatchOperations = sortedDispatchOperations;
    }

    public void apply(@Nullable ITreeAppendable a) {
        JvmFormalParameter parameter;
        if (a == null) {
            throw new IllegalArgumentException("a is never null");
        }
        boolean needsElse = true;
        int parameterCount = this.dispatchOperation.getParameters().size();
        boolean[] allCasesSameType = new boolean[parameterCount];
        int i = 0;
        while (i < parameterCount) {
            allCasesSameType[i] = true;
            JvmTypeReference dispatchParameterType = ((JvmFormalParameter)this.dispatchOperation.getParameters().get(i)).getParameterType();
            for (JvmOperation operation : this.sortedDispatchOperations) {
                parameter = (JvmFormalParameter)operation.getParameters().get(i);
                JvmTypeReference caseParameterType = parameter.getParameterType();
                if (Strings.equal((String)dispatchParameterType.getIdentifier(), (String)caseParameterType.getIdentifier())) continue;
                allCasesSameType[i] = false;
                break;
            }
            ++i;
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, (EObject)this.dispatchOperation);
        OwnedConverter converter = new OwnedConverter((ITypeReferenceOwner)owner);
        for (JvmOperation operation : this.sortedDispatchOperations) {
            ITreeAppendable operationAppendable = this.treeAppendableUtil.traceSignificant(a, (EObject)operation, true);
            ArrayList laters = Lists.newArrayList();
            int i2 = 0;
            while (i2 < parameterCount) {
                JvmFormalParameter dispatchParam = (JvmFormalParameter)this.dispatchOperation.getParameters().get(i2);
                final LightweightTypeReference dispatchParamType = converter.toLightweightReference(dispatchParam.getParameterType());
                JvmFormalParameter caseParam = (JvmFormalParameter)operation.getParameters().get(i2);
                final LightweightTypeReference caseParamType = converter.toLightweightReference(caseParam.getParameterType());
                final String name = this.getVarName((JvmIdentifiableElement)dispatchParam, (IAppendable)operationAppendable);
                if (caseParamType.isType(Void.class)) {
                    laters.add(new Later(){

                        public void exec(ITreeAppendable appendable) {
                            appendable.append((CharSequence)name).append((CharSequence)" == null");
                        }
                    });
                } else if (!allCasesSameType[i2]) {
                    laters.add(new Later(){

                        public void exec(ITreeAppendable appendable) {
                            if (caseParamType.isAssignableFrom(dispatchParamType, new TypeConformanceComputationArgument(true, false, true, true, false, false)) && !dispatchParamType.isPrimitive()) {
                                appendable.append((CharSequence)name).append((CharSequence)" != null");
                            } else {
                                appendable.append((CharSequence)name).append((CharSequence)" instanceof ");
                                JvmType type = caseParamType.getWrapperTypeIfPrimitive().getType();
                                if (type == null) {
                                    throw new IllegalStateException(String.valueOf(caseParamType));
                                }
                                appendable.append(type);
                            }
                        }
                    });
                }
                ++i2;
            }
            if (this.sortedDispatchOperations.get(0) != operation) {
                operationAppendable.append((CharSequence)" else ");
            }
            if (laters.isEmpty()) {
                needsElse = false;
                operationAppendable.append((CharSequence)"{").increaseIndentation();
            } else {
                operationAppendable.append((CharSequence)"if (");
                operationAppendable.increaseIndentation().increaseIndentation();
                Iterator iterator = laters.iterator();
                while (iterator.hasNext()) {
                    ((Later)iterator.next()).exec(operationAppendable);
                    if (!iterator.hasNext()) continue;
                    operationAppendable.newLine().append((CharSequence)" && ");
                }
                operationAppendable.decreaseIndentation().decreaseIndentation();
                operationAppendable.append((CharSequence)") {").increaseIndentation();
            }
            operationAppendable.newLine();
            boolean isCurrentVoid = this.typeReferences.is(operation.getReturnType(), Void.TYPE);
            boolean isDispatchVoid = this.typeReferences.is(this.dispatchOperation.getReturnType(), Void.TYPE);
            if (isDispatchVoid) {
                this.generateActualDispatchCall(this.dispatchOperation, operation, operationAppendable, converter);
                operationAppendable.append((CharSequence)";").newLine().append((CharSequence)"return;");
            } else {
                if (isCurrentVoid) {
                    this.generateActualDispatchCall(this.dispatchOperation, operation, operationAppendable, converter);
                    operationAppendable.append((CharSequence)";").newLine().append((CharSequence)"return null");
                } else {
                    operationAppendable.append((CharSequence)"return ");
                    this.generateActualDispatchCall(this.dispatchOperation, operation, operationAppendable, converter);
                }
                operationAppendable.append((CharSequence)";");
            }
            operationAppendable.decreaseIndentation();
            a.newLine().append((CharSequence)"}");
        }
        if (needsElse) {
            a.append((CharSequence)" else {").increaseIndentation();
            a.newLine();
            a.increaseIndentation();
            a.append((CharSequence)"throw new IllegalArgumentException(\"Unhandled parameter types: \" +").newLine();
            JvmType jvmType = this.typeReferences.findDeclaredType("java.util.Arrays", (Notifier)this.dispatchOperation);
            a.append(jvmType).append((CharSequence)".<Object>asList(");
            Iterator iterator = this.dispatchOperation.getParameters().iterator();
            while (iterator.hasNext()) {
                parameter = (JvmFormalParameter)iterator.next();
                String name = this.getVarName((JvmIdentifiableElement)parameter, (IAppendable)a);
                a.append((CharSequence)name);
                if (!iterator.hasNext()) continue;
                a.append((CharSequence)", ");
            }
            a.append((CharSequence)").toString());");
            a.decreaseIndentation();
            a.decreaseIndentation().newLine().append((CharSequence)"}");
        }
    }

    protected void generateActualDispatchCall(JvmOperation dispatchOperation, JvmOperation actualOperationToCall, ITreeAppendable a, OwnedConverter converter) {
        a.append((CharSequence)actualOperationToCall.getSimpleName()).append((CharSequence)"(");
        Iterator iter1 = dispatchOperation.getParameters().iterator();
        Iterator iter2 = actualOperationToCall.getParameters().iterator();
        while (iter2.hasNext()) {
            JvmFormalParameter p1 = (JvmFormalParameter)iter1.next();
            JvmFormalParameter p2 = (JvmFormalParameter)iter2.next();
            LightweightTypeReference type1 = converter.toLightweightReference(p1.getParameterType());
            LightweightTypeReference type2 = converter.toLightweightReference(p2.getParameterType());
            if (!type2.isAssignableFrom(type1, new TypeConformanceComputationArgument(true, false, true, true, false, false))) {
                a.append((CharSequence)"(").append(type2.getWrapperTypeIfPrimitive()).append((CharSequence)")");
            }
            if (this.typeReferences.is(p2.getParameterType(), Void.class)) {
                a.append((CharSequence)"null");
            } else {
                a.append((CharSequence)this.getVarName((JvmIdentifiableElement)p1, (IAppendable)a));
            }
            if (!iter2.hasNext()) continue;
            a.append((CharSequence)", ");
        }
        a.append((CharSequence)")");
    }

    protected String getVarName(JvmIdentifiableElement ex, IAppendable appendable) {
        return ex.getSimpleName();
    }
}

