/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.ui.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.validation.PivotEObjectValidator;
import org.eclipse.ocl.examples.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class LoadCompleteOCLResourceHandler
extends AbstractHandler {
    @Nullable
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object applicationContext = event.getApplicationContext();
        EditingDomain editingDomain = LoadCompleteOCLResourceHandler.getEditingDomain(applicationContext);
        ResourceSet resourceSet = LoadCompleteOCLResourceHandler.getResourceSet(applicationContext);
        Object shell = HandlerUtil.getVariable((Object)applicationContext, (String)"activeShell");
        if (!(shell instanceof Shell)) {
            return null;
        }
        if (resourceSet != null) {
            ResourceDialog dialog = new ResourceDialog((Shell)shell, editingDomain, resourceSet);
            dialog.open();
        }
        return null;
    }

    @Nullable
    public static EditingDomain getEditingDomain(@Nullable Object evaluationContext) {
        Object o = HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (!(o instanceof IEditorPart)) {
            return null;
        }
        IEditingDomainProvider editor = (IEditingDomainProvider)((IEditorPart)o).getAdapter(IEditingDomainProvider.class);
        if (editor == null) {
            return null;
        }
        EditingDomain editingDomain = editor.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        return editingDomain;
    }

    @Nullable
    public static ResourceSet getResourceSet(@Nullable Object evaluationContext) {
        Object o = HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (!(o instanceof IEditorPart)) {
            return null;
        }
        IEditingDomainProvider editingDomainProvider = (IEditingDomainProvider)((IEditorPart)o).getAdapter(IEditingDomainProvider.class);
        if (editingDomainProvider != null) {
            EditingDomain editingDomain = editingDomainProvider.getEditingDomain();
            if (editingDomain == null) {
                return null;
            }
            ResourceSet resourceSet = editingDomain.getResourceSet();
            return resourceSet;
        }
        XtextEditor xtextEditor = (XtextEditor)((IEditorPart)o).getAdapter(XtextEditor.class);
        if (xtextEditor != null) {
            IXtextDocument document = xtextEditor.getDocument();
            ResourceSet resourceSet = (ResourceSet)document.readOnly((IUnitOfWork)new IUnitOfWork<ResourceSet, XtextResource>(){

                public ResourceSet exec(XtextResource xtextResource) {
                    if (xtextResource == null) {
                        return null;
                    }
                    MetaModelManager metaModelManager = PivotUtil.findMetaModelManager((Resource)xtextResource);
                    if (metaModelManager != null) {
                        return metaModelManager.getExternalResourceSet();
                    }
                    return xtextResource.getResourceSet();
                }
            });
            return resourceSet;
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(LoadCompleteOCLResourceHandler.getResourceSet(evaluationContext) != null);
    }

    public static abstract class Helper {
        @NonNull
        protected final ResourceSet resourceSet;
        @NonNull
        protected final MetaModelManager metaModelManager;
        @NonNull
        protected final Set<EPackage> mmPackages;

        public Helper(@NonNull ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
            MetaModelManagerResourceSetAdapter adapter = MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)resourceSet, null);
            this.metaModelManager = adapter.getMetaModelManager();
            this.mmPackages = new HashSet<EPackage>();
        }

        public boolean loadMetaModels() {
            for (Resource resource : this.resourceSet.getResources()) {
                assert (resource != null);
                Ecore2Pivot ecore2Pivot = Ecore2Pivot.findAdapter((Resource)resource, (MetaModelManager)this.metaModelManager);
                if (ecore2Pivot != null) continue;
                TreeIterator tit = resource.getAllContents();
                while (tit.hasNext()) {
                    EPackage mmPackage;
                    EObject eObject = (EObject)tit.next();
                    EClass eClass = eObject.eClass();
                    if (eClass == null || (mmPackage = eClass.getEPackage()) == null) continue;
                    this.mmPackages.add(mmPackage);
                }
            }
            HashSet<Resource> mmResources = new HashSet<Resource>();
            for (EPackage mmPackage : this.mmPackages) {
                Resource mmResource = EcoreUtil.getRootContainer((EObject)mmPackage).eResource();
                if (mmResource == null) continue;
                mmResources.add(mmResource);
            }
            for (Resource mmResource : mmResources) {
                assert (mmResource != null);
                try {
                    Element pivotRoot = this.metaModelManager.loadResource(mmResource, null);
                    if (pivotRoot != null) {
                        EList errors = pivotRoot.eResource().getErrors();
                        assert (errors != null);
                        String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
                        if (message == null) continue;
                        return this.error("Failed to load Pivot from '" + mmResource.getURI(), message);
                    }
                    return this.error("Failed to load Pivot from '" + mmResource.getURI(), "");
                }
                catch (ParserException e) {
                    return this.error("Failed to load Pivot from '" + mmResource.getURI(), e.getMessage());
                }
            }
            return true;
        }

        protected abstract boolean error(@NonNull String var1, @Nullable String var2);

        public void installPackages() {
            PivotEObjectValidator.install((ResourceSet)this.resourceSet, (MetaModelManager)this.metaModelManager);
            for (EPackage mmPackage : this.mmPackages) {
                assert (mmPackage != null);
                PivotEObjectValidator.install((EPackage)mmPackage);
            }
        }

        public boolean loadDocument(@NonNull URI oclURI) {
            Resource resource = this.loadResource(oclURI);
            if (resource == null) {
                return false;
            }
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (eObject instanceof Package) {
                    EPackage mmPackage;
                    DomainPackage aPackage = this.metaModelManager.getPrimaryPackage((DomainPackage)((Package)eObject));
                    if (!(eObject instanceof Package) || (mmPackage = (EPackage)((Package)aPackage).getETarget()) == null) continue;
                    this.mmPackages.add(mmPackage);
                    continue;
                }
                if (!(eObject instanceof Type)) continue;
                tit.prune();
            }
            return true;
        }

        public Resource loadResource(@NonNull URI oclURI) {
            BaseResource xtextResource = null;
            CompleteOCLStandaloneSetup.init();
            try {
                xtextResource = (BaseResource)this.resourceSet.getResource(oclURI, true);
            }
            catch (WrappedException e) {
                IStatus status;
                URI retryURI = null;
                Throwable cause = e.getCause();
                if (cause instanceof CoreException && (status = ((CoreException)cause).getStatus()).getCode() == 368 && status.getPlugin().equals("org.eclipse.core.resources") && oclURI.isPlatformResource()) {
                    retryURI = URI.createPlatformPluginURI((String)oclURI.toPlatformString(false), (boolean)false);
                }
                if (retryURI != null) {
                    xtextResource = (BaseResource)this.resourceSet.getResource(retryURI, true);
                }
                throw e;
            }
            EList errors = xtextResource.getErrors();
            assert (errors != null);
            String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
            if (message != null) {
                this.error("Failed to load '" + oclURI, message);
                return null;
            }
            Resource pivotResource = xtextResource.getPivotResource(this.metaModelManager);
            errors = pivotResource.getErrors();
            assert (errors != null);
            message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
            if (message != null) {
                this.error("Failed to load Pivot from '" + oclURI, message);
                return null;
            }
            return pivotResource;
        }
    }

    protected class ResourceDialog
    extends LoadResourceAction.LoadResourceDialog {
        protected final Shell parent;
        @NonNull
        protected final ResourceSet resourceSet;
        private DropTarget target;

        protected ResourceDialog(Shell parent, @NonNull EditingDomain domain, ResourceSet resourceSet) {
            super(parent, domain);
            this.parent = parent;
            this.resourceSet = resourceSet;
            int shellStyle = this.getShellStyle();
            int newShellStyle = shellStyle & 0xFFFC7FFF;
            this.setShellStyle(newShellStyle);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Load Complete OCL Resource");
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            int operations = 5;
            this.target = new DropTarget((Control)this.uriField, operations);
            this.target.setTransfer(new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()});
            this.target.addDropListener((DropTargetListener)new URIDropTargetListener());
            return control;
        }

        protected Control createDialogArea(Composite parent) {
            Composite createDialogArea = (Composite)super.createDialogArea(parent);
            Label helpLabel = new Label(createDialogArea, 0x1000000);
            helpLabel.setText("You may Drag and Drop from an Eclipse or Operating System Explorer.");
            FormData data = new FormData();
            data.top = new FormAttachment((Control)this.uriField, 20);
            data.left = new FormAttachment(0, 10);
            data.right = new FormAttachment(100, -10);
            helpLabel.setLayoutData((Object)data);
            return createDialogArea;
        }

        protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
            Shell shell = this.parent;
            if (detailMessage != null) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, "source", 0, detailMessage, null);
                DiagnosticDialog.open((Shell)shell, (String)this.title, (String)primaryMessage, (Diagnostic)diagnostic);
            } else {
                MessageDialog.openInformation((Shell)shell, (String)this.title, (String)primaryMessage);
            }
            return false;
        }

        public int open() {
            try {
                int n = super.open();
                return n;
            }
            catch (Throwable e) {
                String primaryMessage = String.valueOf(e.getMessage());
                this.error(primaryMessage, null);
                return 1;
            }
            finally {
                if (this.target != null) {
                    this.target.dispose();
                    this.target = null;
                }
            }
        }

        protected boolean processResources() {
            Helper helper = new Helper(this.resourceSet){

                protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
                    return ResourceDialog.this.error(primaryMessage, detailMessage);
                }
            };
            if (!helper.loadMetaModels()) {
                return false;
            }
            for (URI oclURI : this.getURIs()) {
                assert (oclURI != null);
                try {
                    if (helper.loadDocument(oclURI)) continue;
                    return false;
                }
                catch (Throwable e) {
                    Status status = new Status(4, "org.eclipse.ocl.examples.xtext.completeocl.ui", e.getLocalizedMessage(), e);
                    ErrorDialog.openError((Shell)this.parent, (String)"Load Complete OCL Resource Failure", (String)("Failed to load '" + oclURI + "'"), (IStatus)status);
                    return false;
                }
            }
            helper.installPackages();
            return true;
        }

        protected boolean processResource(Resource resource) {
            throw new UnsupportedOperationException();
        }

        public class URIDropTargetListener
        extends DropTargetAdapter {
            public void dragEnter(DropTargetEvent e) {
                e.detail = 4;
            }

            public void dragOperationChanged(DropTargetEvent e) {
                e.detail = 4;
            }

            public void drop(DropTargetEvent event) {
                Object data = event.data;
                if (data == null) {
                    event.detail = 0;
                    return;
                }
                if (data instanceof IResource[]) {
                    StringBuilder s = new StringBuilder();
                    IResource[] iResourceArray = (IResource[])data;
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (s.length() > 0) {
                            s.append(" ");
                        }
                        s.append(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true));
                        ++n2;
                    }
                    ResourceDialog.this.uriField.setText(s.toString());
                } else if (data instanceof String[]) {
                    StringBuilder s = new StringBuilder();
                    String[] stringArray = (String[])data;
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String resource = stringArray[n3];
                        if (s.length() > 0) {
                            s.append(" ");
                        }
                        s.append(URI.createFileURI((String)resource));
                        ++n3;
                    }
                    ResourceDialog.this.uriField.setText(s.toString());
                } else {
                    ResourceDialog.this.uriField.setText((String)data);
                }
            }
        }
    }
}

