/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public class ObjectLockedIndication
extends CDOServerReadIndication {
    private boolean isLocked;

    public ObjectLockedIndication(CDOServerProtocol protocol) {
        super(protocol, (short)26);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        InternalView view = this.getSession().getView(viewID);
        InternalLockManager lockManager = this.getRepository().getLockingManager();
        IRWLockManager.LockType lockType = in.readCDOLockType();
        CDOID id = in.readCDOID();
        CDOID key = this.getRepository().isSupportingBranches() ? CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)view.getBranch()) : id;
        boolean byOthers = in.readBoolean();
        this.isLocked = byOthers ? lockManager.hasLockByOthers(lockType, (Object)view, (Object)key) : lockManager.hasLock(lockType, (Object)view, (Object)key);
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeBoolean(this.isLocked);
    }
}

